
# coding: utf-8
# Copyright (c) 2024 Huawei Technologies Co., Ltd.
# openUBMC is licensed under Mulan PSL v2.
# You can use this software according to the terms and conditions of the Mulan PSL v2.
# You may obtain a copy of Mulan PSL v2 at:
#         http://license.coscl.org.cn/MulanPSL2
# THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
# EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
# MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
# See the Mulan PSL v2 for more details.
from setuptools import setup

from bmcgo import __version__

setup(
    name="openubmc-bingo",
    version=__version__,
    description="Tools provided by openubmc",
    long_description="build and code generate tools",
    long_description_content_type="text/markdown",
    install_requires=[
        "inflection",
        "gitpython",
        "pyecharts",
        "dbus-python",
        "meson",
        "conan<=1.62.0",
        "mako",
        "launchpadlib",
        "jsonschema",
        "pyyaml-include",
        "typeguard==2.13.3",
        "protobuf==3.19.1",
        "pyinstaller",
        "pyopenssl>=23.2.0, <=24.1.0",
        "pysftp",
        "jsonref",
        "cryptography==42.0.7",
        "psutil",
        "ecdsa"
        ],
    url="https://openubmc.cn",
    packages=["bmcgo"],
    include_package_data=True,
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MulanPSL-2.0",
        "Operating System :: OS Independent",
    ],
    entry_points={
        'console_scripts': [
            'bingo=bmcgo.bmcgo:run',
        ],
    },
)
