#!/usr/bin/python
# -*- coding: UTF-8 -*-
# Copyright (c) 2024 Huawei Technologies Co., Ltd.
# openUBMC is licensed under Mulan PSL v2.
# You can use this software according to the terms and conditions of the Mulan PSL v2.
# You may obtain a copy of Mulan PSL v2 at:
#         http://license.coscl.org.cn/MulanPSL2
# THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
# EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
# MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
# See the Mulan PSL v2 for more details.

'''
功    能：
版权信息：华为技术有限公司，版本所有(C) 2021
修改记录：2021-10-11 创建
'''
import os
import re
import shutil

from bmcgo.tasks.task import Task


class TaskClass(Task):
    def download_dependency(self):
        self.info('开始下载依赖组件 ...')
        partner_sdk_dir = f"{os.path.expanduser('~')}/sdk"
        self.info(f"从缓存目录{partner_sdk_dir}复制sdk和rtos二进制文件")
        self.run_command(f"cp -rf {partner_sdk_dir}/. {self.config.sdk_path}")
        self.info('下载依赖组件结束')

    def move_dependency(self):
        # 移动到tools/build_tools目录中
        self.info("移动依赖组件结束")
        self.chdir(self.config.sdk_path)
        for file in os.listdir("."):
            if re.match("^Hi1711_[0-9]{8}_[0-9a-f]{40}.tar.gz$", file) is None:
                continue
            self.run_command(f"tar -xvf {file}")
            break

    def run(self):
        if os.path.isdir(self.config.sdk_path):
            shutil.rmtree(self.config.sdk_path)
            os.makedirs(self.config.sdk_path)

        self.download_dependency()
        self.move_dependency()
