-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-3-15
-- Description: DO NOT EDIT; Code generated by "model.lua.mako"
local mdb = require 'mc.mdb'
local class = require 'mc.class_mgnt'
local privilege = require 'mc.privilege'

local types = require 'class.types.types'
local account_service_class_types = require 'class.types.AccountService'
local manager_account_db_class_types = require 'class.types.ManagerAccountDB'
local manager_account_backup_class_types =
    require 'class.types.ManagerAccountBackup'
local snmp_user_info_class_types = require 'class.types.SNMPUserInfo'
local ipmi_user_info_class_types = require 'class.types.IpmiUserInfo'
local history_password_class_types = require 'class.types.HistoryPassword'
local login_rule_class_types = require 'class.types.LoginRule'
local role_class_types = require 'class.types.Role'
local snmp_community_class_types = require 'class.types.SnmpCommunity'
local account_backup_class_types = require 'class.types.AccountBackup'
local password_policy_class_types = require 'class.types.PasswordPolicy'
local account_policy_class_types = require 'class.types.AccountPolicy'
local account_service_intf_types = require 'account.json_types.AccountService'
local properties_intf_types = require 'account.json_types.Properties'
local manager_accounts_intf_types = require 'account.json_types.ManagerAccounts'
local manager_account_intf_types = require 'account.json_types.ManagerAccount'
local snmp_user_intf_types = require 'account.json_types.SnmpUser'
local rule_intf_types = require 'account.json_types.Rule'
local role_intf_types = require 'account.json_types.Role'
local snmp_community_intf_types = require 'account.json_types.SnmpCommunity'
local local_account_auth_n_intf_types =
    require 'account.json_types.LocalAccountAuthN'
local password_policy_intf_types = require 'account.json_types.PasswordPolicy'
local account_policy_intf_types = require 'account.json_types.AccountPolicy'

local AccountService = {
    ['table_name'] = 't_account_service',
    ['prop_configs'] = {
        ['PasswordExpirationDays'] = {
            ['baseType'] = 'U32',
            ['default'] = 4294967295,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = account_service_class_types.PasswordExpirationDays
        },
        ['AccountLockoutDuration'] = {
            ['baseType'] = 'S32',
            ['default'] = 300,
            ['description'] = '账号登录失败后锁定时长,单位为秒',
            ['validator'] = account_service_class_types.AccountLockoutDuration
        },
        ['AccountLockoutThreshold'] = {
            ['baseType'] = 'S32',
            ['default'] = 5,
            ['description'] = '账号登录失败该次数后被锁定',
            ['validator'] = account_service_class_types.AccountLockoutThreshold
        },
        ['UserMgmtEnable'] = {
            ['baseType'] = 'Boolean',
            ['default'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = account_service_class_types.UserMgmtEnable
        },
        ['TimeSource'] = {
            ['baseType'] = 'Enum',
            ['$ref'] = 'types.json#/defs/TimeSource',
            ['default'] = 'TS_NOT_NTP',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = account_service_class_types.TimeSource
        },
        ['PasswordComplexityIsLock'] = {
            ['baseType'] = 'Boolean',
            ['default'] = false,
            ['usage'] = {'PoweroffPer'},
            ['description'] = '密码复杂度是否允许解锁，IPMI设置为strong_enable时，不允许解锁',
            ['validator'] = account_service_class_types.PasswordComplexityIsLock
        },
        ['PreviousPasswordsDisallowed'] = {
            ['baseType'] = 'U8',
            ['default'] = 5,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = account_service_class_types.PreviousPasswordsDisallowed
        },
        ['Id'] = {
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['usage'] = {'PoweroffPer'},
            ['description'] = '因持久化需要而添加，无实际作用，AccountService仅有一条数据',
            ['validator'] = account_service_class_types.Id
        }
    },
    ['default_props'] = {
        ['PasswordExpirationDays'] = 4294967295,
        ['AccountLockoutDuration'] = 300,
        ['AccountLockoutThreshold'] = 5,
        ['UserMgmtEnable'] = true,
        ['TimeSource'] = types.TimeSource.TS_NOT_NTP:value(),
        ['PasswordComplexityIsLock'] = false,
        ['PreviousPasswordsDisallowed'] = 5,
        ['Id'] = account_service_class_types.Id.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.AccountService'] = {
            ['AccountLockoutCounterResetAfter'] = {
                ['baseType'] = 'S32',
                ['readOnly'] = false,
                ['default'] = 0,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '账户上次登陆失败后，锁定计数器重置剩余时间',
                ['validator'] = account_service_intf_types.AccountLockoutCounterResetAfter
            },
            ['AccountLockoutCounterResetEnabled'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = false,
                ['default'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '账户在AccountLockoutCounterResetAfter到期后是否重置',
                ['validator'] = account_service_intf_types.AccountLockoutCounterResetEnabled
            },
            ['AuthFailureLoggingThreshold'] = {
                ['baseType'] = 'S32',
                ['readOnly'] = false,
                ['default'] = 0,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '未使用',
                ['validator'] = account_service_intf_types.AuthFailureLoggingThreshold
            },
            ['MaxPasswordLength'] = {
                ['baseType'] = 'S32',
                ['readOnly'] = true,
                ['default'] = 20,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['description'] = '密码最长默认为20位',
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {
                    ['read'] = {'ReadOnly'},
                    ['write'] = {'SecurityMgmt'}
                },
                ['validator'] = account_service_intf_types.MaxPasswordLength
            },
            ['MinPasswordLength'] = {
                ['baseType'] = 'S32',
                ['readOnly'] = false,
                ['default'] = 8,
                ['minimum'] = 8,
                ['maximum'] = 20,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['description'] = '密码最短长度',
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {
                    ['read'] = {'ReadOnly'},
                    ['write'] = {'SecurityMgmt'}
                },
                ['validator'] = account_service_intf_types.MinPasswordLength
            },
            ['ServiceEnabled'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = false,
                ['default'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '未使用',
                ['privilege'] = {
                    ['read'] = {'ReadOnly'},
                    ['write'] = {'UserMgmt'}
                },
                ['validator'] = account_service_intf_types.ServiceEnabled
            },
            ['PasswordComplexityEnable'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = false,
                ['default'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['description'] = '密码复杂度检查开关',
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {
                    ['read'] = {'ReadOnly'},
                    ['write'] = {'SecurityMgmt'}
                },
                ['validator'] = account_service_intf_types.PasswordComplexityEnable
            },
            ['InitialPasswordPromptEnable'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = false,
                ['default'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = 'BMC支持生产定制化关闭首次登录修改密码提示功能',
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {
                    ['read'] = {'ReadOnly'},
                    ['write'] = {'SecurityMgmt'}
                },
                ['validator'] = account_service_intf_types.InitialPasswordPromptEnable
            },
            ['InitialPasswordNeedModify'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = false,
                ['default'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '初始密码需要强制修改',
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {
                    ['read'] = {'ReadOnly'},
                    ['write'] = {'SecurityMgmt'}
                },
                ['validator'] = account_service_intf_types.InitialPasswordNeedModify
            },
            ['InitialAccountPrivilegeRestrictEnabled'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = false,
                ['default'] = false,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['description'] = '初始账户权限限制开关',
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {
                    ['read'] = {'ReadOnly'},
                    ['write'] = {'SecurityMgmt'}
                },
                ['validator'] = account_service_intf_types.InitialAccountPrivilegeRestrictEnabled
            },
            ['MinPasswordValidDays'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = false,
                ['default'] = 0,
                ['minimum'] = 0,
                ['maximum'] = 365,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['description'] = '密码最短有效期',
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {
                    ['read'] = {'ReadOnly'},
                    ['write'] = {'SecurityMgmt'}
                },
                ['validator'] = account_service_intf_types.MinPasswordValidDays
            },
            ['MaxPasswordValidDays'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = false,
                ['default'] = 0,
                ['minimum'] = 0,
                ['maximum'] = 365,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['description'] = '密码最长有效期',
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {
                    ['read'] = {'ReadOnly'},
                    ['write'] = {'SecurityMgmt'}
                },
                ['validator'] = account_service_intf_types.MaxPasswordValidDays
            },
            ['EmergencyLoginAccountId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['default'] = 0,
                ['minimum'] = 0,
                ['maximum'] = 17,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['description'] = '逃生用户',
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {
                    ['read'] = {'ReadOnly'},
                    ['write'] = {'UserMgmt'}
                },
                ['validator'] = account_service_intf_types.EmergencyLoginAccountId
            },
            ['SNMPv3TrapAccountId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['default'] = 2,
                ['minimum'] = 0,
                ['maximum'] = 17,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['description'] = 'SNMPv3Trap用户',
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {
                    ['read'] = {'ReadOnly'},
                    ['write'] = {'BasicSetting'}
                },
                ['validator'] = account_service_intf_types.SNMPv3TrapAccountId
            },
            ['InactiveDaysThreshold'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = false,
                ['default'] = 0,
                ['minimum'] = 0,
                ['maximum'] = 365,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['description'] = '用户不活跃阈值',
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {
                    ['read'] = {'ReadOnly'},
                    ['write'] = {'SecurityMgmt'}
                },
                ['validator'] = account_service_intf_types.InactiveDaysThreshold
            },
            ['WeakPasswordDictionaryEnabled'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = false,
                ['default'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '弱口令字典使能开关',
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {
                    ['read'] = {'ReadOnly'},
                    ['write'] = {'SecurityMgmt'}
                },
                ['validator'] = account_service_intf_types.WeakPasswordDictionaryEnabled
            },
            ['HistoryPasswordCount'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['default'] = 5,
                ['minimum'] = 0,
                ['maximum'] = 5,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['description'] = '检查历史密码数',
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {
                    ['read'] = {'ReadOnly'},
                    ['write'] = {'SecurityMgmt'}
                },
                ['validator'] = account_service_intf_types.HistoryPasswordCount
            },
            ['HostUserManagementEnabled'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = false,
                ['default'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['description'] = '业务侧用户管理使能',
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {
                    ['read'] = {'ReadOnly'},
                    ['write'] = {'UserMgmt'}
                },
                ['validator'] = account_service_intf_types.HostUserManagementEnabled
            },
            ['OSAdministratorPrivilegeEnabled'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = false,
                ['default'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '业务侧管理员权限使能:true表示允许执行业务侧发送的（权限为用户管理、安全配置、调试诊断的）ipmi命令；false表示禁止执行业务侧发送的（权限为用户管理、安全配置、调试诊断）ipmi命令',
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {
                    ['read'] = {'ReadOnly'},
                    ['write'] = {'UserMgmt'}
                },
                ['validator'] = account_service_intf_types.OSAdministratorPrivilegeEnabled
            },
            ['SNMPv3TrapAccountLimitPolicy'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['default'] = 2,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['description'] = '根据trap使能状态和版本,调整对snmpv3trap用户的修改策略.',
                ['validator'] = account_service_intf_types.SNMPv3TrapAccountLimitPolicy
            },
            ['UserNamePasswordPrefixCompareEnabled'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = false,
                ['default'] = false,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['description'] = '密码与用户名前n个字节比较策略使能',
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {
                    ['read'] = {'ReadOnly'},
                    ['write'] = {'SecurityMgmt'}
                },
                ['validator'] = account_service_intf_types.UserNamePasswordPrefixCompareEnabled
            },
            ['UserNamePasswordPrefixCompareLength'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['default'] = 4,
                ['minimum'] = 4,
                ['maximum'] = 20,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['description'] = '密码与用户名前n个字节比较策略长度',
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {
                    ['read'] = {'ReadOnly'},
                    ['write'] = {'SecurityMgmt'}
                },
                ['validator'] = account_service_intf_types.UserNamePasswordPrefixCompareLength
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.AccountService'] = {
            ['ImportWeakPasswordDictionary'] = {
                ['initiator'] = true,
                ['privilege'] = {'SecurityMgmt'},
                ['req'] = {{['baseType'] = 'String', ['param'] = 'Path'}},
                ['rsp'] = {
                    {
                        ['baseType'] = 'U32',
                        ['description'] = '仅远程上传涉及，任务id',
                        ['param'] = 'TaskId'
                    }
                }
            },
            ['ExportWeakPasswordDictionary'] = {
                ['initiator'] = true,
                ['privilege'] = {'SecurityMgmt'},
                ['req'] = {{['baseType'] = 'String', ['param'] = 'Path'}},
                ['rsp'] = {
                    {
                        ['baseType'] = 'U32',
                        ['description'] = '仅远程上传涉及，任务id',
                        ['param'] = 'TaskId'
                    }
                }
            },
            ['GetRequestedPublicKey'] = {
                ['initiator'] = true,
                ['privilege'] = {'ReadOnly'},
                ['req'] = {
                    {
                        ['baseType'] = 'U8',
                        ['description'] = '公钥用途，当前将支持web前端加密公钥：1',
                        ['param'] = 'PublicKeyUsageType'
                    }
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'String',
                        ['description'] = '公钥字符串',
                        ['param'] = 'PublicKey'
                    }
                }
            },
            ['RecoverAccount'] = {
                ['initiator'] = true,
                ['privilege'] = {'UserMgmt'},
                ['req'] = {
                    {
                        ['baseType'] = 'U8',
                        ['maximum'] = 17,
                        ['minimum'] = 2,
                        ['param'] = 'AccountId'
                    },
                    {
                        ['baseType'] = 'U8',
                        ['maximum'] = 1,
                        ['minimum'] = 0,
                        ['param'] = 'Policy'
                    }
                },
                ['rsp'] = {}
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['GetOptions'] = {
                ['req'] = {
                    {
                        ['baseType'] = 'String',
                        ['description'] = '接口名',
                        ['param'] = 'Interface'
                    }, {
                        ['baseType'] = 'String',
                        ['description'] = '属性名',
                        ['param'] = 'Property'
                    }
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['description'] = '按接口名和属性名查询属性的能力选项'
            },
            ['GetPropertiesByOptions'] = {
                ['req'] = {
                    {
                        ['baseType'] = 'String',
                        ['description'] = '接口名',
                        ['param'] = 'Interface'
                    }, {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'String[]',
                        ['description'] = '属性名列表',
                        ['param'] = 'Properties'
                    }
                },
                ['description'] = '按接口名和能力选项查询符合条件的所有属性'
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/AccountService'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.AccountService'] = {
            ['property_defaults'] = {
                ['AccountLockoutCounterResetAfter'] = 0,
                ['AccountLockoutCounterResetEnabled'] = false,
                ['AuthFailureLoggingThreshold'] = 0,
                ['MaxPasswordLength'] = 20,
                ['MinPasswordLength'] = 8,
                ['ServiceEnabled'] = true,
                ['PasswordComplexityEnable'] = true,
                ['InitialPasswordPromptEnable'] = true,
                ['InitialPasswordNeedModify'] = true,
                ['InitialAccountPrivilegeRestrictEnabled'] = false,
                ['MinPasswordValidDays'] = 0,
                ['MaxPasswordValidDays'] = 0,
                ['EmergencyLoginAccountId'] = 0,
                ['SNMPv3TrapAccountId'] = 2,
                ['InactiveDaysThreshold'] = 0,
                ['WeakPasswordDictionaryEnabled'] = true,
                ['HistoryPasswordCount'] = 5,
                ['HostUserManagementEnabled'] = true,
                ['OSAdministratorPrivilegeEnabled'] = true,
                ['SNMPv3TrapAccountLimitPolicy'] = 2,
                ['UserNamePasswordPrefixCompareEnabled'] = false,
                ['UserNamePasswordPrefixCompareLength'] = 4
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {
                    ['MaxPasswordLength'] = {
                        ['read'] = privilege.ReadOnly,
                        ['write'] = privilege.SecurityMgmt
                    },
                    ['MinPasswordLength'] = {
                        ['read'] = privilege.ReadOnly,
                        ['write'] = privilege.SecurityMgmt
                    },
                    ['ServiceEnabled'] = {
                        ['read'] = privilege.ReadOnly,
                        ['write'] = privilege.UserMgmt
                    },
                    ['PasswordComplexityEnable'] = {
                        ['read'] = privilege.ReadOnly,
                        ['write'] = privilege.SecurityMgmt
                    },
                    ['InitialPasswordPromptEnable'] = {
                        ['read'] = privilege.ReadOnly,
                        ['write'] = privilege.SecurityMgmt
                    },
                    ['InitialPasswordNeedModify'] = {
                        ['read'] = privilege.ReadOnly,
                        ['write'] = privilege.SecurityMgmt
                    },
                    ['InitialAccountPrivilegeRestrictEnabled'] = {
                        ['read'] = privilege.ReadOnly,
                        ['write'] = privilege.SecurityMgmt
                    },
                    ['MinPasswordValidDays'] = {
                        ['read'] = privilege.ReadOnly,
                        ['write'] = privilege.SecurityMgmt
                    },
                    ['MaxPasswordValidDays'] = {
                        ['read'] = privilege.ReadOnly,
                        ['write'] = privilege.SecurityMgmt
                    },
                    ['EmergencyLoginAccountId'] = {
                        ['read'] = privilege.ReadOnly,
                        ['write'] = privilege.UserMgmt
                    },
                    ['SNMPv3TrapAccountId'] = {
                        ['read'] = privilege.ReadOnly,
                        ['write'] = privilege.BasicSetting
                    },
                    ['InactiveDaysThreshold'] = {
                        ['read'] = privilege.ReadOnly,
                        ['write'] = privilege.SecurityMgmt
                    },
                    ['WeakPasswordDictionaryEnabled'] = {
                        ['read'] = privilege.ReadOnly,
                        ['write'] = privilege.SecurityMgmt
                    },
                    ['HistoryPasswordCount'] = {
                        ['read'] = privilege.ReadOnly,
                        ['write'] = privilege.SecurityMgmt
                    },
                    ['HostUserManagementEnabled'] = {
                        ['read'] = privilege.ReadOnly,
                        ['write'] = privilege.UserMgmt
                    },
                    ['OSAdministratorPrivilegeEnabled'] = {
                        ['read'] = privilege.ReadOnly,
                        ['write'] = privilege.UserMgmt
                    },
                    ['UserNamePasswordPrefixCompareEnabled'] = {
                        ['read'] = privilege.ReadOnly,
                        ['write'] = privilege.SecurityMgmt
                    },
                    ['UserNamePasswordPrefixCompareLength'] = {
                        ['read'] = privilege.ReadOnly,
                        ['write'] = privilege.SecurityMgmt
                    }
                },
                ['methods'] = {
                    ['ImportWeakPasswordDictionary'] = privilege.SecurityMgmt,
                    ['ExportWeakPasswordDictionary'] = privilege.SecurityMgmt,
                    ['GetRequestedPublicKey'] = privilege.ReadOnly,
                    ['RecoverAccount'] = privilege.UserMgmt
                }
            },
            ['interface_types'] = account_service_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier
                    .default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local ManagerAccounts = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.AccountService.ManagerAccounts'] = {},
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.AccountService.ManagerAccounts'] = {
            ['New'] = {
                ['initiator'] = true,
                ['privilege'] = {'UserMgmt'},
                ['req'] = {
                    {
                        ['baseType'] = 'U8',
                        ['maximum'] = 17,
                        ['minimum'] = 0,
                        ['param'] = 'AccountId'
                    }, {
                        ['baseType'] = 'String',
                        ['maxLength'] = 32,
                        ['minLength'] = 1,
                        ['param'] = 'UserName'
                    },
                    {
                        ['baseType'] = 'U8[]',
                        ['maxLength'] = 32,
                        ['param'] = 'Password'
                    },
                    {
                        ['baseType'] = 'Enum',
                        ['$ref'] = '#/defs/RoleType',
                        ['param'] = 'RoleId'
                    }, {
                        ['baseType'] = 'Array',
                        ['items'] = {
                            ['baseType'] = 'Enum',
                            ['$ref'] = '#/defs/LoginInterfaceType'
                        },
                        ['param'] = 'LoginInterface'
                    }, {
                        ['baseType'] = 'Enum',
                        ['$ref'] = '#/defs/FirstLoginPolicy',
                        ['param'] = 'FirstLoginPolicy'
                    }
                },
                ['rsp'] = {{['baseType'] = 'U8', ['param'] = 'AccountId'}}
            },
            ['NewOEMAccount'] = {
                ['privilege'] = {'UserMgmt'},
                ['req'] = {
                    {
                        ['baseType'] = 'U8',
                        ['maximum'] = 115,
                        ['minimum'] = 101,
                        ['param'] = 'AccountId'
                    }, {
                        ['baseType'] = 'String',
                        ['maxLength'] = 32,
                        ['minLength'] = 1,
                        ['param'] = 'UserName'
                    }, {
                        ['baseType'] = 'String',
                        ['maxLength'] = 1024,
                        ['minLength'] = 1,
                        ['param'] = 'Password'
                    }, {
                        ['baseType'] = 'Dictionary',
                        ['$ref'] = '#/defs/ExtraData',
                        ['param'] = 'ExtraData'
                    }
                },
                ['rsp'] = {{['baseType'] = 'U8', ['param'] = 'AccountId'}}
            },
            ['GetIdByUserName'] = {
                ['initiator'] = true,
                ['privilege'] = {'ConfigureSelf'},
                ['req'] = {
                    {
                        ['baseType'] = 'String',
                        ['maxLength'] = 32,
                        ['minLength'] = 1,
                        ['param'] = 'UserName'
                    }
                },
                ['rsp'] = {{['baseType'] = 'U8', ['param'] = 'AccountId'}}
            },
            ['GetUidGidByUserName'] = {
                ['initiator'] = true,
                ['req'] = {
                    {
                        ['baseType'] = 'String',
                        ['maxLength'] = 32,
                        ['minLength'] = 1,
                        ['param'] = 'UserName'
                    }
                },
                ['rsp'] = {
                    {['baseType'] = 'U32', ['param'] = 'UID'},
                    {['baseType'] = 'U32', ['param'] = 'GID'}
                }
            },
            ['SetAccountWritable'] = {
                ['initiator'] = true,
                ['privilege'] = {'UserMgmt'},
                ['req'] = {
                    {
                        ['baseType'] = 'U8',
                        ['maximum'] = 115,
                        ['minimum'] = 2,
                        ['param'] = 'AccountId'
                    }, {
                        ['baseType'] = 'Dictionary',
                        ['$ref'] = '#/defs/PropertyWritable',
                        ['param'] = 'PropertiesWritable'
                    }
                },
                ['rsp'] = {}
            },
            ['GetAccountWritable'] = {
                ['initiator'] = true,
                ['privilege'] = {'UserMgmt'},
                ['req'] = {
                    {
                        ['baseType'] = 'U8',
                        ['maximum'] = 115,
                        ['minimum'] = 2,
                        ['param'] = 'AccountId'
                    }
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'Dictionary',
                        ['$ref'] = '#/defs/PropertyWritable',
                        ['param'] = 'PropertiesWritable'
                    }
                }
            },
            ['SetAccountLockState'] = {
                ['initiator'] = true,
                ['privilege'] = {'UserMgmt'},
                ['req'] = {
                    {
                        ['baseType'] = 'U8',
                        ['maximum'] = 115,
                        ['minimum'] = 2,
                        ['param'] = 'AccountId'
                    }, {['baseType'] = 'Boolean', ['param'] = 'Lockstatus'}
                },
                ['rsp'] = {}
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['GetOptions'] = {
                ['req'] = {
                    {
                        ['baseType'] = 'String',
                        ['description'] = '接口名',
                        ['param'] = 'Interface'
                    }, {
                        ['baseType'] = 'String',
                        ['description'] = '属性名',
                        ['param'] = 'Property'
                    }
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['description'] = '按接口名和属性名查询属性的能力选项'
            },
            ['GetPropertiesByOptions'] = {
                ['req'] = {
                    {
                        ['baseType'] = 'String',
                        ['description'] = '接口名',
                        ['param'] = 'Interface'
                    }, {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'String[]',
                        ['description'] = '属性名列表',
                        ['param'] = 'Properties'
                    }
                },
                ['description'] = '按接口名和能力选项查询符合条件的所有属性'
            }
        }
    },
    ['mdb_signal_configs'] = {
        ['bmc.kepler.AccountService.ManagerAccounts'] = {
            ['PasswordChangedSignal'] = {
                {['baseType'] = 'U8', ['param'] = 'AccountId'}
            },
            ['SnmpPasswordChangedSignal'] = {
                {['baseType'] = 'U8', ['param'] = 'AccountId'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/AccountService/Accounts'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.AccountService.ManagerAccounts'] = {
            ['property_defaults'] = {},
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['methods'] = {
                    ['New'] = privilege.UserMgmt,
                    ['NewOEMAccount'] = privilege.UserMgmt,
                    ['GetIdByUserName'] = privilege.ConfigureSelf,
                    ['SetAccountWritable'] = privilege.UserMgmt,
                    ['GetAccountWritable'] = privilege.UserMgmt,
                    ['SetAccountLockState'] = privilege.UserMgmt
                }
            },
            ['interface_types'] = manager_accounts_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier
                    .default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local ManagerAccount = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.AccountService.ManagerAccount'] = {
            ['AccountExpiration'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '账户过期说明',
                ['privilege'] = {
                    ['read'] = {'ConfigureSelf'},
                    ['write'] = {'UserMgmt'}
                },
                ['validator'] = manager_account_intf_types.AccountExpiration
            },
            ['Certificates'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['description'] = '证书认证证书Id',
                ['validator'] = manager_account_intf_types.Certificates
            },
            ['Enabled'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = false,
                ['description'] = '账户使能状态',
                ['privilege'] = {
                    ['read'] = {'ConfigureSelf'},
                    ['write'] = {'UserMgmt'}
                },
                ['validator'] = manager_account_intf_types.Enabled
            },
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '账户Id',
                ['usage'] = {'CSR'},
                ['privilege'] = {
                    ['read'] = {'ConfigureSelf'},
                    ['write'] = {'UserMgmt'}
                },
                ['validator'] = manager_account_intf_types.Id
            },
            ['Locked'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['description'] = '账户锁定状态',
                ['privilege'] = {
                    ['read'] = {'ConfigureSelf'},
                    ['write'] = {'UserMgmt'}
                },
                ['validator'] = manager_account_intf_types.Locked
            },
            ['UserName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['description'] = '账户名',
                ['privilege'] = {
                    ['read'] = {'ConfigureSelf'},
                    ['write'] = {'UserMgmt'}
                },
                ['validator'] = manager_account_intf_types.UserName
            },
            ['Deletable'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['description'] = '账户是否可以删除',
                ['privilege'] = {
                    ['read'] = {'ConfigureSelf'},
                    ['write'] = {'UserMgmt'}
                },
                ['validator'] = manager_account_intf_types.Deletable
            },
            ['PasswordChangeRequired'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = false,
                ['default'] = true,
                ['description'] = '密码初始状态',
                ['privilege'] = {
                    ['read'] = {'ConfigureSelf'},
                    ['write'] = {'ConfigureSelf'}
                },
                ['validator'] = manager_account_intf_types.PasswordChangeRequired
            },
            ['PasswordExpiration'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['description'] = '密码有效期（过期时间）',
                ['privilege'] = {
                    ['read'] = {'ConfigureSelf'},
                    ['write'] = {'UserMgmt'}
                },
                ['validator'] = manager_account_intf_types.PasswordExpiration
            },
            ['RoleId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['description'] = '角色Id',
                ['privilege'] = {
                    ['read'] = {'ConfigureSelf'},
                    ['write'] = {'UserMgmt'}
                },
                ['validator'] = manager_account_intf_types.RoleId
            },
            ['SshPublicKeyHash'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '账户公钥hash值',
                ['privilege'] = {
                    ['read'] = {'ConfigureSelf'},
                    ['write'] = {'UserMgmt'}
                },
                ['validator'] = manager_account_intf_types.SshPublicKeyHash
            },
            ['AccountType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '账户类型',
                ['privilege'] = {
                    ['read'] = {'ConfigureSelf'},
                    ['write'] = {'UserMgmt'}
                },
                ['validator'] = manager_account_intf_types.AccountType
            },
            ['LoginRuleIds'] = {
                ['baseType'] = 'String[]',
                ['readOnly'] = false,
                ['description'] = '登录规则集合',
                ['privilege'] = {
                    ['read'] = {'ConfigureSelf'},
                    ['write'] = {'UserMgmt'}
                },
                ['validator'] = manager_account_intf_types.LoginRuleIds
            },
            ['LastLoginTime'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['description'] = '上次登录时间',
                ['privilege'] = {
                    ['read'] = {'ConfigureSelf'},
                    ['write'] = {'UserMgmt'}
                },
                ['validator'] = manager_account_intf_types.LastLoginTime
            },
            ['LastLoginIP'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '上次登录IP',
                ['privilege'] = {
                    ['read'] = {'ConfigureSelf'},
                    ['write'] = {'UserMgmt'}
                },
                ['validator'] = manager_account_intf_types.LastLoginIP
            },
            ['LastLoginInterface'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '上次登录接口',
                ['privilege'] = {
                    ['read'] = {'ConfigureSelf'},
                    ['write'] = {'UserMgmt'}
                },
                ['validator'] = manager_account_intf_types.LastLoginInterface
            },
            ['FirstLoginPolicy'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['default'] = 2,
                ['description'] = '账户首次登陆口令修改策略',
                ['privilege'] = {
                    ['read'] = {'ConfigureSelf'},
                    ['write'] = {'UserMgmt'}
                },
                ['validator'] = manager_account_intf_types.FirstLoginPolicy
            },
            ['LoginInterface'] = {
                ['baseType'] = 'String[]',
                ['readOnly'] = false,
                ['description'] = '账户可用登陆接口集合',
                ['privilege'] = {
                    ['read'] = {'ConfigureSelf'},
                    ['write'] = {'UserMgmt'}
                },
                ['validator'] = manager_account_intf_types.LoginInterface
            },
            ['Privileges'] = {
                ['baseType'] = 'String[]',
                ['readOnly'] = true,
                ['description'] = '账户拥有的实际权限',
                ['privilege'] = {
                    ['read'] = {'ConfigureSelf'},
                    ['write'] = {'UserMgmt'}
                },
                ['validator'] = manager_account_intf_types.Privileges
            }
        },
        ['bmc.kepler.AccountService.ManagerAccount.SnmpUser'] = {
            ['AuthenticationProtocol'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = 'SNMP鉴权算法',
                ['privilege'] = {
                    ['read'] = {'ConfigureSelf'},
                    ['write'] = {'UserMgmt'}
                },
                ['validator'] = snmp_user_intf_types.AuthenticationProtocol
            },
            ['EncryptionProtocol'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = 'SNMP加密算法',
                ['privilege'] = {
                    ['read'] = {'ConfigureSelf'},
                    ['write'] = {'UserMgmt'}
                },
                ['validator'] = snmp_user_intf_types.EncryptionProtocol
            },
            ['SnmpEncryptionPasswordInitialStatus'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['description'] = 'SNMP加密密码初始状态',
                ['privilege'] = {
                    ['read'] = {'ConfigureSelf'},
                    ['write'] = {'UserMgmt'}
                },
                ['validator'] = snmp_user_intf_types.SnmpEncryptionPasswordInitialStatus
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.AccountService.ManagerAccount'] = {
            ['Delete'] = {
                ['initiator'] = true,
                ['privilege'] = {'UserMgmt'},
                ['req'] = {},
                ['rsp'] = {}
            },
            ['ChangePwd'] = {
                ['initiator'] = true,
                ['privilege'] = {'ConfigureSelf'},
                ['req'] = {
                    {
                        ['baseType'] = 'U8[]',
                        ['maxLength'] = 32,
                        ['minLength'] = 1,
                        ['description'] = '待设置的密码',
                        ['param'] = 'Password'
                    }
                },
                ['rsp'] = {}
            },
            ['ChangeSnmpPwd'] = {
                ['initiator'] = true,
                ['privilege'] = {'ConfigureSelf'},
                ['req'] = {
                    {
                        ['baseType'] = 'U8[]',
                        ['maxLength'] = 32,
                        ['minLength'] = 1,
                        ['description'] = '待设置的密码',
                        ['param'] = 'Password'
                    }
                },
                ['rsp'] = {}
            },
            ['ImportSSHPublicKey'] = {
                ['initiator'] = true,
                ['privilege'] = {'ConfigureSelf'},
                ['req'] = {
                    {
                        ['baseType'] = 'String',
                        ['description'] = 'Content类型：URI/Text',
                        ['param'] = 'Type'
                    }, {
                        ['baseType'] = 'String',
                        ['description'] = 'Type为URI时，代表远程路径/本地路径；Type为Text时，代表文本内容',
                        ['param'] = 'Content'
                    }
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'U32',
                        ['description'] = '远程上传时代表任务Id，否则为0',
                        ['param'] = 'TaskId'
                    }
                }
            },
            ['DeleteSSHPublicKey'] = {
                ['initiator'] = true,
                ['privilege'] = {'ConfigureSelf'},
                ['req'] = {},
                ['rsp'] = {}
            },
            ['SetLastLogin'] = {
                ['initiator'] = true,
                ['privilege'] = {'ConfigureSelf'},
                ['req'] = {
                    {
                        ['baseType'] = 'String',
                        ['description'] = '上次登录IP',
                        ['param'] = 'Ip'
                    }, {
                        ['baseType'] = 'String',
                        ['description'] = '上次登录接口',
                        ['param'] = 'Interface'
                    }
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'U8',
                        ['description'] = '处理结果',
                        ['param'] = 'Result'
                    }
                }
            }
        },
        ['bmc.kepler.AccountService.ManagerAccount.SnmpUser'] = {
            ['SetAuthenticationProtocol'] = {
                ['initiator'] = true,
                ['privilege'] = {'ConfigureSelf'},
                ['req'] = {
                    {
                        ['baseType'] = 'U8',
                        ['description'] = 'SNMP鉴权算法',
                        ['param'] = 'SNMPAuthenticationProtocol'
                    }, {
                        ['baseType'] = 'String',
                        ['maxLength'] = 32,
                        ['minLength'] = 1,
                        ['description'] = 'SNMP鉴权密码',
                        ['param'] = 'AuthPassword'
                    }, {
                        ['baseType'] = 'String',
                        ['maxLength'] = 32,
                        ['minLength'] = 1,
                        ['description'] = 'SNMP加密密码',
                        ['param'] = 'EncryPassword'
                    }
                },
                ['rsp'] = {}
            },
            ['SetEncryptionProtocol'] = {
                ['initiator'] = true,
                ['privilege'] = {'ConfigureSelf'},
                ['req'] = {
                    {
                        ['baseType'] = 'U8',
                        ['description'] = 'SNMP加密算法',
                        ['param'] = 'SNMPEncryptionProtocol'
                    }
                },
                ['rsp'] = {}
            },
            ['GetSnmpKeys'] = {
                ['privilege'] = {'UserMgmt'},
                ['req'] = {},
                ['rsp'] = {
                    {
                        ['baseType'] = 'String',
                        ['description'] = 'SNMP鉴权密码 Ku',
                        ['param'] = 'AuthenticationKey'
                    }, {
                        ['baseType'] = 'String',
                        ['description'] = 'SNMP加密密码 Ku',
                        ['param'] = 'EncryptionKey'
                    }
                }
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['GetOptions'] = {
                ['req'] = {
                    {
                        ['baseType'] = 'String',
                        ['description'] = '接口名',
                        ['param'] = 'Interface'
                    }, {
                        ['baseType'] = 'String',
                        ['description'] = '属性名',
                        ['param'] = 'Property'
                    }
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['description'] = '按接口名和属性名查询属性的能力选项'
            },
            ['GetPropertiesByOptions'] = {
                ['req'] = {
                    {
                        ['baseType'] = 'String',
                        ['description'] = '接口名',
                        ['param'] = 'Interface'
                    }, {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'String[]',
                        ['description'] = '属性名列表',
                        ['param'] = 'Properties'
                    }
                },
                ['description'] = '按接口名和能力选项查询符合条件的所有属性'
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj(
        '/bmc/kepler/AccountService/Accounts/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.AccountService.ManagerAccount'] = {
            ['property_defaults'] = {
                ['AccountExpiration'] = manager_account_intf_types.AccountExpiration
                    .default[1],
                ['Certificates'] = manager_account_intf_types.Certificates
                    .default[1],
                ['Enabled'] = manager_account_intf_types.Enabled.default[1],
                ['Id'] = manager_account_intf_types.Id.default[1],
                ['Locked'] = manager_account_intf_types.Locked.default[1],
                ['UserName'] = manager_account_intf_types.UserName.default[1],
                ['Deletable'] = manager_account_intf_types.Deletable.default[1],
                ['PasswordChangeRequired'] = true,
                ['PasswordExpiration'] = manager_account_intf_types.PasswordExpiration
                    .default[1],
                ['RoleId'] = manager_account_intf_types.RoleId.default[1],
                ['SshPublicKeyHash'] = manager_account_intf_types.SshPublicKeyHash
                    .default[1],
                ['AccountType'] = manager_account_intf_types.AccountType.default[1],
                ['LoginRuleIds'] = manager_account_intf_types.LoginRuleIds
                    .default[1],
                ['LastLoginTime'] = manager_account_intf_types.LastLoginTime
                    .default[1],
                ['LastLoginIP'] = manager_account_intf_types.LastLoginIP.default[1],
                ['LastLoginInterface'] = manager_account_intf_types.LastLoginInterface
                    .default[1],
                ['FirstLoginPolicy'] = 2,
                ['LoginInterface'] = manager_account_intf_types.LoginInterface
                    .default[1],
                ['Privileges'] = manager_account_intf_types.Privileges.default[1]
            },
            ['privileges'] = {
                ['path'] = privilege.ConfigureSelf,
                ['props'] = {
                    ['AccountExpiration'] = {
                        ['read'] = privilege.ConfigureSelf,
                        ['write'] = privilege.UserMgmt
                    },
                    ['Enabled'] = {
                        ['read'] = privilege.ConfigureSelf,
                        ['write'] = privilege.UserMgmt
                    },
                    ['Id'] = {
                        ['read'] = privilege.ConfigureSelf,
                        ['write'] = privilege.UserMgmt
                    },
                    ['Locked'] = {
                        ['read'] = privilege.ConfigureSelf,
                        ['write'] = privilege.UserMgmt
                    },
                    ['UserName'] = {
                        ['read'] = privilege.ConfigureSelf,
                        ['write'] = privilege.UserMgmt
                    },
                    ['Deletable'] = {
                        ['read'] = privilege.ConfigureSelf,
                        ['write'] = privilege.UserMgmt
                    },
                    ['PasswordChangeRequired'] = {
                        ['read'] = privilege.ConfigureSelf,
                        ['write'] = privilege.ConfigureSelf
                    },
                    ['PasswordExpiration'] = {
                        ['read'] = privilege.ConfigureSelf,
                        ['write'] = privilege.UserMgmt
                    },
                    ['RoleId'] = {
                        ['read'] = privilege.ConfigureSelf,
                        ['write'] = privilege.UserMgmt
                    },
                    ['SshPublicKeyHash'] = {
                        ['read'] = privilege.ConfigureSelf,
                        ['write'] = privilege.UserMgmt
                    },
                    ['AccountType'] = {
                        ['read'] = privilege.ConfigureSelf,
                        ['write'] = privilege.UserMgmt
                    },
                    ['LoginRuleIds'] = {
                        ['read'] = privilege.ConfigureSelf,
                        ['write'] = privilege.UserMgmt
                    },
                    ['LastLoginTime'] = {
                        ['read'] = privilege.ConfigureSelf,
                        ['write'] = privilege.UserMgmt
                    },
                    ['LastLoginIP'] = {
                        ['read'] = privilege.ConfigureSelf,
                        ['write'] = privilege.UserMgmt
                    },
                    ['LastLoginInterface'] = {
                        ['read'] = privilege.ConfigureSelf,
                        ['write'] = privilege.UserMgmt
                    },
                    ['FirstLoginPolicy'] = {
                        ['read'] = privilege.ConfigureSelf,
                        ['write'] = privilege.UserMgmt
                    },
                    ['LoginInterface'] = {
                        ['read'] = privilege.ConfigureSelf,
                        ['write'] = privilege.UserMgmt
                    },
                    ['Privileges'] = {
                        ['read'] = privilege.ConfigureSelf,
                        ['write'] = privilege.UserMgmt
                    }
                },
                ['methods'] = {
                    ['Delete'] = privilege.UserMgmt,
                    ['ChangePwd'] = privilege.ConfigureSelf,
                    ['ChangeSnmpPwd'] = privilege.ConfigureSelf,
                    ['ImportSSHPublicKey'] = privilege.ConfigureSelf,
                    ['DeleteSSHPublicKey'] = privilege.ConfigureSelf,
                    ['SetLastLogin'] = privilege.ConfigureSelf
                }
            },
            ['interface_types'] = manager_account_intf_types
        },
        ['bmc.kepler.AccountService.ManagerAccount.SnmpUser'] = {
            ['property_defaults'] = {
                ['AuthenticationProtocol'] = snmp_user_intf_types.AuthenticationProtocol
                    .default[1],
                ['EncryptionProtocol'] = snmp_user_intf_types.EncryptionProtocol
                    .default[1],
                ['SnmpEncryptionPasswordInitialStatus'] = snmp_user_intf_types.SnmpEncryptionPasswordInitialStatus
                    .default[1]
            },
            ['privileges'] = {
                ['path'] = privilege.ConfigureSelf,
                ['props'] = {
                    ['AuthenticationProtocol'] = {
                        ['read'] = privilege.ConfigureSelf,
                        ['write'] = privilege.UserMgmt
                    },
                    ['EncryptionProtocol'] = {
                        ['read'] = privilege.ConfigureSelf,
                        ['write'] = privilege.UserMgmt
                    },
                    ['SnmpEncryptionPasswordInitialStatus'] = {
                        ['read'] = privilege.ConfigureSelf,
                        ['write'] = privilege.UserMgmt
                    }
                },
                ['methods'] = {
                    ['SetAuthenticationProtocol'] = privilege.ConfigureSelf,
                    ['SetEncryptionProtocol'] = privilege.ConfigureSelf,
                    ['GetSnmpKeys'] = privilege.UserMgmt
                }
            },
            ['interface_types'] = snmp_user_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier
                    .default[1]
            },
            ['privileges'] = {['path'] = privilege.ConfigureSelf},
            ['interface_types'] = properties_intf_types
        }
    })
}

local ManagerAccountDB = {
    ['table_name'] = 't_manager_account',
    ['prop_configs'] = {
        ['AccountExpiration'] = {
            ['baseType'] = 'String',
            ['description'] = '',
            ['notAllowNull'] = false,
            ['critical'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = manager_account_db_class_types.AccountExpiration
        },
        ['Certificates'] = {
            ['baseType'] = 'U16',
            ['description'] = '',
            ['notAllowNull'] = false,
            ['critical'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = manager_account_db_class_types.Certificates
        },
        ['Enabled'] = {
            ['baseType'] = 'Boolean',
            ['description'] = '',
            ['default'] = false,
            ['critical'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = manager_account_db_class_types.Enabled
        },
        ['Id'] = {
            ['baseType'] = 'U8',
            ['description'] = '',
            ['primaryKey'] = true,
            ['critical'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = manager_account_db_class_types.Id
        },
        ['Locked'] = {
            ['baseType'] = 'Boolean',
            ['description'] = '',
            ['default'] = false,
            ['critical'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = manager_account_db_class_types.Locked
        },
        ['UserName'] = {
            ['baseType'] = 'String',
            ['description'] = '',
            ['uniqueKey'] = true,
            ['critical'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = manager_account_db_class_types.UserName
        },
        ['Deletable'] = {
            ['baseType'] = 'Boolean',
            ['description'] = '',
            ['default'] = false,
            ['critical'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = manager_account_db_class_types.Deletable
        },
        ['Password'] = {
            ['baseType'] = 'String',
            ['description'] = '',
            ['notAllowNull'] = true,
            ['critical'] = true,
            ['usage'] = {'PoweroffPer'},
            ['sensitive'] = true,
            ['validator'] = manager_account_db_class_types.Password
        },
        ['KDFPassword'] = {
            ['baseType'] = 'String',
            ['description'] = '',
            ['critical'] = true,
            ['usage'] = {'PoweroffPer'},
            ['sensitive'] = true,
            ['validator'] = manager_account_db_class_types.KDFPassword
        },
        ['PasswordChangeRequired'] = {
            ['baseType'] = 'Boolean',
            ['description'] = '',
            ['default'] = true,
            ['critical'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = manager_account_db_class_types.PasswordChangeRequired
        },
        ['PasswordExpiration'] = {
            ['baseType'] = 'U32',
            ['description'] = '',
            ['default'] = 4294967295,
            ['critical'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = manager_account_db_class_types.PasswordExpiration
        },
        ['RoleId'] = {
            ['baseType'] = 'U8',
            ['description'] = '',
            ['default'] = 0,
            ['critical'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = manager_account_db_class_types.RoleId
        },
        ['SshPublicKeyHash'] = {
            ['baseType'] = 'String',
            ['description'] = '',
            ['default'] = '',
            ['critical'] = true,
            ['usage'] = {'PoweroffPer'},
            ['sensitive'] = true,
            ['validator'] = manager_account_db_class_types.SshPublicKeyHash
        },
        ['IpmiPassword'] = {
            ['baseType'] = 'String',
            ['description'] = '',
            ['notAllowNull'] = true,
            ['critical'] = true,
            ['usage'] = {'PoweroffPer'},
            ['sensitive'] = true,
            ['validator'] = manager_account_db_class_types.IpmiPassword
        },
        ['IpmiPasswordBak'] = {
            ['baseType'] = 'String',
            ['description'] = '',
            ['critical'] = true,
            ['usage'] = {'PoweroffPer'},
            ['sensitive'] = true,
            ['validator'] = manager_account_db_class_types.IpmiPasswordBak
        },
        ['WithinMinPasswordDays'] = {
            ['baseType'] = 'Boolean',
            ['description'] = '',
            ['default'] = false,
            ['critical'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = manager_account_db_class_types.WithinMinPasswordDays
        },
        ['LoginRuleIds'] = {
            ['baseType'] = 'U8',
            ['description'] = '',
            ['default'] = 0,
            ['critical'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = manager_account_db_class_types.LoginRuleIds
        },
        ['InactUserRemainDays'] = {
            ['baseType'] = 'U32',
            ['description'] = '',
            ['default'] = 4294967295,
            ['critical'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = manager_account_db_class_types.InactUserRemainDays
        },
        ['LastLoginTime'] = {
            ['baseType'] = 'U32',
            ['description'] = '',
            ['default'] = 4294967295,
            ['critical'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = manager_account_db_class_types.LastLoginTime
        },
        ['LastLoginIP'] = {
            ['baseType'] = 'String',
            ['description'] = '',
            ['default'] = '',
            ['critical'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = manager_account_db_class_types.LastLoginIP
        },
        ['LastLoginInterface'] = {
            ['baseType'] = 'Enum',
            ['description'] = '',
            ['default'] = 'Web',
            ['$ref'] = 'types.json#/defs/LoginInterface',
            ['critical'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = manager_account_db_class_types.LastLoginInterface
        },
        ['FirstLoginPolicy'] = {
            ['baseType'] = 'Enum',
            ['description'] = '',
            ['default'] = 'ForcePasswordReset',
            ['$ref'] = 'types.json#/defs/FirstLoginPolicy',
            ['critical'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = manager_account_db_class_types.FirstLoginPolicy
        },
        ['AccountType'] = {
            ['baseType'] = 'Enum',
            ['description'] = '',
            ['default'] = 'Local',
            ['$ref'] = 'types.json#/defs/AccountType',
            ['critical'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = manager_account_db_class_types.AccountType
        },
        ['LoginInterface'] = {
            ['baseType'] = 'U32',
            ['description'] = '',
            ['default'] = 0,
            ['critical'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = manager_account_db_class_types.LoginInterface
        },
        ['PasswordValidStartTime'] = {
            ['baseType'] = 'U32',
            ['description'] = '',
            ['default'] = 0,
            ['critical'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = manager_account_db_class_types.PasswordValidStartTime
        },
        ['InactiveStartTime'] = {
            ['baseType'] = 'U32',
            ['description'] = '',
            ['default'] = 0,
            ['critical'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = manager_account_db_class_types.InactiveStartTime
        },
        ['PasswordWritable'] = {
            ['baseType'] = 'Boolean',
            ['description'] = '密码是否可修改',
            ['default'] = true,
            ['critical'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = manager_account_db_class_types.PasswordWritable
        },
        ['UserNameWritable'] = {
            ['baseType'] = 'Boolean',
            ['description'] = '用户名是否可修改',
            ['default'] = true,
            ['critical'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = manager_account_db_class_types.UserNameWritable
        },
        ['LoginInterfaceWritable'] = {
            ['baseType'] = 'Boolean',
            ['description'] = '登录接口是否可修改',
            ['default'] = true,
            ['critical'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = manager_account_db_class_types.LoginInterfaceWritable
        },
        ['RoleIdWritable'] = {
            ['baseType'] = 'Boolean',
            ['description'] = '管理角色是否可修改',
            ['default'] = true,
            ['critical'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = manager_account_db_class_types.RoleIdWritable
        },
        ['EnabledWritable'] = {
            ['baseType'] = 'Boolean',
            ['description'] = '启用状态是否可修改',
            ['default'] = true,
            ['critical'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = manager_account_db_class_types.EnabledWritable
        },
        ['LoginRuleIdsWritable'] = {
            ['baseType'] = 'Boolean',
            ['description'] = '登录规则是否可修改',
            ['default'] = true,
            ['critical'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = manager_account_db_class_types.LoginRuleIdsWritable
        },
        ['AuthenticationProtocolWritable'] = {
            ['baseType'] = 'Boolean',
            ['description'] = '鉴权算法是否可修改',
            ['default'] = true,
            ['critical'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = manager_account_db_class_types.AuthenticationProtocolWritable
        },
        ['EncryptionProtocolWritable'] = {
            ['baseType'] = 'Boolean',
            ['description'] = '加密算法是否可修改',
            ['default'] = true,
            ['critical'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = manager_account_db_class_types.EncryptionProtocolWritable
        },
        ['SNMPPasswordWritable'] = {
            ['baseType'] = 'Boolean',
            ['description'] = 'snmp密码是否可修改',
            ['default'] = true,
            ['critical'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = manager_account_db_class_types.SNMPPasswordWritable
        }
    },
    ['default_props'] = {
        ['AccountExpiration'] = manager_account_db_class_types.AccountExpiration
            .default[1],
        ['Certificates'] = manager_account_db_class_types.Certificates.default[1],
        ['Enabled'] = false,
        ['Id'] = manager_account_db_class_types.Id.default[1],
        ['Locked'] = false,
        ['UserName'] = manager_account_db_class_types.UserName.default[1],
        ['Deletable'] = false,
        ['Password'] = manager_account_db_class_types.Password.default[1],
        ['KDFPassword'] = manager_account_db_class_types.KDFPassword.default[1],
        ['PasswordChangeRequired'] = true,
        ['PasswordExpiration'] = 4294967295,
        ['RoleId'] = 0,
        ['SshPublicKeyHash'] = '',
        ['IpmiPassword'] = manager_account_db_class_types.IpmiPassword.default[1],
        ['IpmiPasswordBak'] = manager_account_db_class_types.IpmiPasswordBak
            .default[1],
        ['WithinMinPasswordDays'] = false,
        ['LoginRuleIds'] = 0,
        ['InactUserRemainDays'] = 4294967295,
        ['LastLoginTime'] = 4294967295,
        ['LastLoginIP'] = '',
        ['LastLoginInterface'] = types.LoginInterface.Web:value(),
        ['FirstLoginPolicy'] = types.FirstLoginPolicy.ForcePasswordReset:value(),
        ['AccountType'] = types.AccountType.Local:value(),
        ['LoginInterface'] = 0,
        ['PasswordValidStartTime'] = 0,
        ['InactiveStartTime'] = 0,
        ['PasswordWritable'] = true,
        ['UserNameWritable'] = true,
        ['LoginInterfaceWritable'] = true,
        ['RoleIdWritable'] = true,
        ['EnabledWritable'] = true,
        ['LoginRuleIdsWritable'] = true,
        ['AuthenticationProtocolWritable'] = true,
        ['EncryptionProtocolWritable'] = true,
        ['SNMPPasswordWritable'] = true
    }
}

local ManagerAccountBackup = {
    ['table_name'] = 't_manager_account_backup',
    ['prop_configs'] = {
        ['Id'] = {
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['description'] = '用户id',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = manager_account_backup_class_types.Id
        },
        ['ManagerAccountData'] = {
            ['baseType'] = 'String',
            ['description'] = 'manager account数据表备份',
            ['notAllowNull'] = false,
            ['usage'] = {'PoweroffPer'},
            ['sensitive'] = true,
            ['validator'] = manager_account_backup_class_types.ManagerAccountData
        },
        ['IpmiAccountData'] = {
            ['baseType'] = 'String',
            ['description'] = 'ipmi account数据表备份',
            ['notAllowNull'] = false,
            ['usage'] = {'PoweroffPer'},
            ['sensitive'] = true,
            ['validator'] = manager_account_backup_class_types.IpmiAccountData
        },
        ['SnmpAccountData'] = {
            ['baseType'] = 'String',
            ['description'] = 'snmp account数据表备份',
            ['notAllowNull'] = false,
            ['usage'] = {'PoweroffPer'},
            ['sensitive'] = true,
            ['validator'] = manager_account_backup_class_types.SnmpAccountData
        }
    },
    ['default_props'] = {
        ['Id'] = manager_account_backup_class_types.Id.default[1],
        ['ManagerAccountData'] = manager_account_backup_class_types.ManagerAccountData
            .default[1],
        ['IpmiAccountData'] = manager_account_backup_class_types.IpmiAccountData
            .default[1],
        ['SnmpAccountData'] = manager_account_backup_class_types.SnmpAccountData
            .default[1]
    }
}

local SNMPUserInfo = {
    ['table_name'] = 't_snmp_user_info',
    ['prop_configs'] = {
        ['AccountId'] = {
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['usage'] = {'PoweroffPer'},
            ['description'] = '',
            ['validator'] = snmp_user_info_class_types.AccountId
        },
        ['AuthenticationKey'] = {
            ['baseType'] = 'String',
            ['notAllowNull'] = true,
            ['usage'] = {'PoweroffPer'},
            ['sensitive'] = true,
            ['description'] = 'AuthKu',
            ['validator'] = snmp_user_info_class_types.AuthenticationKey
        },
        ['AuthenticationKeySet'] = {
            ['baseType'] = 'Boolean',
            ['default'] = false,
            ['usage'] = {'PoweroffPer'},
            ['description'] = '',
            ['validator'] = snmp_user_info_class_types.AuthenticationKeySet
        },
        ['AuthenticationProtocol'] = {
            ['baseType'] = 'Enum',
            ['$ref'] = 'types.json#/defs/SNMPAuthenticationProtocols',
            ['default'] = 'SHA256',
            ['usage'] = {'PoweroffPer'},
            ['description'] = 'AuthProtocol',
            ['validator'] = snmp_user_info_class_types.AuthenticationProtocol
        },
        ['EncryptionKey'] = {
            ['baseType'] = 'String',
            ['notAllowNull'] = true,
            ['usage'] = {'PoweroffPer'},
            ['sensitive'] = true,
            ['description'] = 'PrivKu',
            ['validator'] = snmp_user_info_class_types.EncryptionKey
        },
        ['EncryptionKeySet'] = {
            ['baseType'] = 'Boolean',
            ['default'] = false,
            ['usage'] = {'PoweroffPer'},
            ['description'] = '',
            ['validator'] = snmp_user_info_class_types.EncryptionKeySet
        },
        ['EncryptionProtocol'] = {
            ['baseType'] = 'Enum',
            ['$ref'] = 'types.json#/defs/SNMPEncryptionProtocols',
            ['default'] = 'AES128',
            ['usage'] = {'PoweroffPer'},
            ['description'] = 'PrivProtocol',
            ['validator'] = snmp_user_info_class_types.EncryptionProtocol
        },
        ['SNMPPassword'] = {
            ['baseType'] = 'String',
            ['notAllowNull'] = true,
            ['usage'] = {'PoweroffPer'},
            ['sensitive'] = true,
            ['description'] = '',
            ['validator'] = snmp_user_info_class_types.SNMPPassword
        },
        ['SNMPKDFPassword'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['sensitive'] = true,
            ['description'] = '',
            ['validator'] = snmp_user_info_class_types.SNMPKDFPassword
        },
        ['SnmpEncryptionPasswordInitialStatus'] = {
            ['baseType'] = 'Boolean',
            ['default'] = true,
            ['usage'] = {'PoweroffPer'},
            ['description'] = 'IsSnmpPrivacyInitialPwd',
            ['validator'] = snmp_user_info_class_types.SnmpEncryptionPasswordInitialStatus
        }
    },
    ['default_props'] = {
        ['AccountId'] = snmp_user_info_class_types.AccountId.default[1],
        ['AuthenticationKey'] = snmp_user_info_class_types.AuthenticationKey
            .default[1],
        ['AuthenticationKeySet'] = false,
        ['AuthenticationProtocol'] = types.SNMPAuthenticationProtocols.SHA256:value(),
        ['EncryptionKey'] = snmp_user_info_class_types.EncryptionKey.default[1],
        ['EncryptionKeySet'] = false,
        ['EncryptionProtocol'] = types.SNMPEncryptionProtocols.AES128:value(),
        ['SNMPPassword'] = snmp_user_info_class_types.SNMPPassword.default[1],
        ['SNMPKDFPassword'] = snmp_user_info_class_types.SNMPKDFPassword.default[1],
        ['SnmpEncryptionPasswordInitialStatus'] = true
    }
}

local IpmiUserInfo = {
    ['table_name'] = 't_ipmi_user_info',
    ['prop_configs'] = {
        ['AccountId'] = {
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['usage'] = {'PoweroffPer'},
            ['description'] = '',
            ['validator'] = ipmi_user_info_class_types.AccountId
        },
        ['Use20BytesPasswd'] = {
            ['baseType'] = 'U8',
            ['default'] = 1,
            ['usage'] = {'PoweroffPer'},
            ['description'] = '',
            ['validator'] = ipmi_user_info_class_types.Use20BytesPasswd
        },
        ['IsCallin'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'PoweroffPer'},
            ['description'] = '',
            ['validator'] = ipmi_user_info_class_types.IsCallin
        },
        ['IsEnableAuth'] = {
            ['baseType'] = 'U8',
            ['default'] = 1,
            ['usage'] = {'PoweroffPer'},
            ['description'] = '',
            ['validator'] = ipmi_user_info_class_types.IsEnableAuth
        },
        ['IsEnableIpmiMsg'] = {
            ['baseType'] = 'U8',
            ['default'] = 1,
            ['usage'] = {'PoweroffPer'},
            ['description'] = '',
            ['validator'] = ipmi_user_info_class_types.IsEnableIpmiMsg
        },
        ['IsEnableByPasswd'] = {
            ['baseType'] = 'Enum',
            ['$ref'] = 'types.json#/defs/IpmiUserEnableByPassword',
            ['default'] = 'Disable',
            ['usage'] = {'PoweroffPer'},
            ['description'] = '',
            ['validator'] = ipmi_user_info_class_types.IsEnableByPasswd
        },
        ['Privilege0'] = {
            ['baseType'] = 'Enum',
            ['$ref'] = 'types.json#/defs/IpmiPrivilege',
            ['default'] = 'RESERVED',
            ['usage'] = {'PoweroffPer'},
            ['description'] = '',
            ['validator'] = ipmi_user_info_class_types.Privilege0
        },
        ['Privilege1'] = {
            ['baseType'] = 'Enum',
            ['$ref'] = 'types.json#/defs/IpmiPrivilege',
            ['default'] = 'RESERVED',
            ['usage'] = {'PoweroffPer'},
            ['description'] = '',
            ['validator'] = ipmi_user_info_class_types.Privilege1
        }
    },
    ['default_props'] = {
        ['AccountId'] = ipmi_user_info_class_types.AccountId.default[1],
        ['Use20BytesPasswd'] = 1,
        ['IsCallin'] = 0,
        ['IsEnableAuth'] = 1,
        ['IsEnableIpmiMsg'] = 1,
        ['IsEnableByPasswd'] = types.IpmiUserEnableByPassword.Disable:value(),
        ['Privilege0'] = types.IpmiPrivilege.RESERVED:value(),
        ['Privilege1'] = types.IpmiPrivilege.RESERVED:value()
    }
}

local HistoryPassword = {
    ['table_name'] = 't_history_password',
    ['prop_configs'] = {
        ['AccountId'] = {
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['notAllowNull'] = true,
            ['usage'] = {'PoweroffPer'},
            ['description'] = '',
            ['validator'] = history_password_class_types.AccountId
        },
        ['SequenceNumber'] = {
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['notAllowNull'] = true,
            ['usage'] = {'PoweroffPer'},
            ['description'] = '',
            ['validator'] = history_password_class_types.SequenceNumber
        },
        ['Password'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['sensitive'] = true,
            ['description'] = '',
            ['validator'] = history_password_class_types.Password
        },
        ['KDFPassword'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['sensitive'] = true,
            ['description'] = '',
            ['validator'] = history_password_class_types.KDFPassword
        }
    },
    ['default_props'] = {
        ['AccountId'] = history_password_class_types.AccountId.default[1],
        ['SequenceNumber'] = history_password_class_types.SequenceNumber.default[1],
        ['Password'] = history_password_class_types.Password.default[1],
        ['KDFPassword'] = history_password_class_types.KDFPassword.default[1]
    }
}

local Rule = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.AccountService.Rule'] = {
            ['Enabled'] = {
                ['baseType'] = 'Boolean',
                ['default'] = false,
                ['readOnly'] = false,
                ['description'] = '登录规则使能状态',
                ['privilege'] = {
                    ['read'] = {'ReadOnly'},
                    ['write'] = {'SecurityMgmt'}
                },
                ['validator'] = rule_intf_types.Enabled
            },
            ['IpRule'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['description'] = 'IP登录规则',
                ['privilege'] = {
                    ['read'] = {'ReadOnly'},
                    ['write'] = {'SecurityMgmt'}
                },
                ['validator'] = rule_intf_types.IpRule
            },
            ['MacRule'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['description'] = 'MAC地址登录规则',
                ['privilege'] = {
                    ['read'] = {'ReadOnly'},
                    ['write'] = {'SecurityMgmt'}
                },
                ['validator'] = rule_intf_types.MacRule
            },
            ['TimeRule'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['description'] = '时间登录规则',
                ['privilege'] = {
                    ['read'] = {'ReadOnly'},
                    ['write'] = {'SecurityMgmt'}
                },
                ['validator'] = rule_intf_types.TimeRule
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Object.Properties'] = {
            ['GetOptions'] = {
                ['req'] = {
                    {
                        ['baseType'] = 'String',
                        ['description'] = '接口名',
                        ['param'] = 'Interface'
                    }, {
                        ['baseType'] = 'String',
                        ['description'] = '属性名',
                        ['param'] = 'Property'
                    }
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['description'] = '按接口名和属性名查询属性的能力选项'
            },
            ['GetPropertiesByOptions'] = {
                ['req'] = {
                    {
                        ['baseType'] = 'String',
                        ['description'] = '接口名',
                        ['param'] = 'Interface'
                    }, {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'String[]',
                        ['description'] = '属性名列表',
                        ['param'] = 'Properties'
                    }
                },
                ['description'] = '按接口名和能力选项查询符合条件的所有属性'
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj(
        '/bmc/kepler/AccountService/Rules/:RuleId'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.AccountService.Rule'] = {
            ['property_defaults'] = {
                ['Enabled'] = false,
                ['IpRule'] = rule_intf_types.IpRule.default[1],
                ['MacRule'] = rule_intf_types.MacRule.default[1],
                ['TimeRule'] = rule_intf_types.TimeRule.default[1]
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {
                    ['Enabled'] = {
                        ['read'] = privilege.ReadOnly,
                        ['write'] = privilege.SecurityMgmt
                    },
                    ['IpRule'] = {
                        ['read'] = privilege.ReadOnly,
                        ['write'] = privilege.SecurityMgmt
                    },
                    ['MacRule'] = {
                        ['read'] = privilege.ReadOnly,
                        ['write'] = privilege.SecurityMgmt
                    },
                    ['TimeRule'] = {
                        ['read'] = privilege.ReadOnly,
                        ['write'] = privilege.SecurityMgmt
                    }
                }
            },
            ['interface_types'] = rule_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier
                    .default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local LoginRule = {
    ['table_name'] = 't_login_rule',
    ['prop_configs'] = {
        ['RuleId'] = {
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = login_rule_class_types.RuleId
        },
        ['IpRule'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = login_rule_class_types.IpRule
        },
        ['Ipv6Rule'] = {
            ['baseType'] = 'String',
            ['default'] = '',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = login_rule_class_types.Ipv6Rule
        },
        ['TimeRule'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = login_rule_class_types.TimeRule
        },
        ['MacRule'] = {
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = login_rule_class_types.MacRule
        },
        ['Enabled'] = {
            ['baseType'] = 'Boolean',
            ['default'] = false,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = login_rule_class_types.Enabled
        }
    },
    ['default_props'] = {
        ['RuleId'] = login_rule_class_types.RuleId.default[1],
        ['IpRule'] = login_rule_class_types.IpRule.default[1],
        ['Ipv6Rule'] = '',
        ['TimeRule'] = login_rule_class_types.TimeRule.default[1],
        ['MacRule'] = login_rule_class_types.MacRule.default[1],
        ['Enabled'] = false
    }
}

local Role = {
    ['table_name'] = 't_role',
    ['prop_configs'] = {
        ['Id'] = {
            ['baseType'] = 'Enum',
            ['$ref'] = 'types.json#/defs/RoleType',
            ['primaryKey'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = role_class_types.Id
        },
        ['RoleName'] = {
            ['baseType'] = 'String',
            ['uniqueKey'] = true,
            ['usage'] = {'PoweroffPer'},
            ['description'] = '角色 Name',
            ['validator'] = role_class_types.RoleName
        },
        ['UserMgmt'] = {
            ['baseType'] = 'Boolean',
            ['default'] = false,
            ['usage'] = {'PoweroffPer'},
            ['description'] = '用户管理权限',
            ['validator'] = role_class_types.UserMgmt
        },
        ['BasicSetting'] = {
            ['baseType'] = 'Boolean',
            ['default'] = false,
            ['usage'] = {'PoweroffPer'},
            ['description'] = '基本设置功能权限',
            ['validator'] = role_class_types.BasicSetting
        },
        ['KVMMgmt'] = {
            ['baseType'] = 'Boolean',
            ['default'] = false,
            ['usage'] = {'PoweroffPer'},
            ['description'] = 'KVM使用权限',
            ['validator'] = role_class_types.KVMMgmt
        },
        ['ReadOnly'] = {
            ['baseType'] = 'Boolean',
            ['default'] = false,
            ['usage'] = {'PoweroffPer'},
            ['description'] = '只读功能权限',
            ['validator'] = role_class_types.ReadOnly
        },
        ['VMMMgmt'] = {
            ['baseType'] = 'Boolean',
            ['default'] = false,
            ['usage'] = {'PoweroffPer'},
            ['description'] = 'VMM使用权限',
            ['validator'] = role_class_types.VMMMgmt
        },
        ['SecurityMgmt'] = {
            ['baseType'] = 'Boolean',
            ['default'] = false,
            ['usage'] = {'PoweroffPer'},
            ['description'] = '安全配置权限',
            ['validator'] = role_class_types.SecurityMgmt
        },
        ['PowerMgmt'] = {
            ['baseType'] = 'Boolean',
            ['default'] = false,
            ['usage'] = {'PoweroffPer'},
            ['description'] = '电源控制权限',
            ['validator'] = role_class_types.PowerMgmt
        },
        ['DiagnoseMgmt'] = {
            ['baseType'] = 'Boolean',
            ['default'] = false,
            ['usage'] = {'PoweroffPer'},
            ['description'] = '诊断调试权限',
            ['validator'] = role_class_types.DiagnoseMgmt
        },
        ['ConfigureSelf'] = {
            ['baseType'] = 'Boolean',
            ['default'] = false,
            ['usage'] = {'PoweroffPer'},
            ['description'] = '配置自身权限',
            ['validator'] = role_class_types.ConfigureSelf
        }
    },
    ['default_props'] = {
        ['Id'] = role_class_types.Id.default[1]:value(),
        ['RoleName'] = role_class_types.RoleName.default[1],
        ['UserMgmt'] = false,
        ['BasicSetting'] = false,
        ['KVMMgmt'] = false,
        ['ReadOnly'] = false,
        ['VMMMgmt'] = false,
        ['SecurityMgmt'] = false,
        ['PowerMgmt'] = false,
        ['DiagnoseMgmt'] = false,
        ['ConfigureSelf'] = false
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.AccountService.Role'] = {
            ['RolePrivilege'] = {
                ['baseType'] = 'String[]',
                ['readOnly'] = true,
                ['default'] = {},
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['description'] = '角色的九大权限',
                ['privilege'] = {
                    ['read'] = {'ReadOnly'},
                    ['write'] = {'UserMgmt'}
                },
                ['validator'] = role_intf_types.RolePrivilege
            },
            ['Name'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['description'] = '角色的九大权限名称',
                ['privilege'] = {
                    ['read'] = {'ReadOnly'},
                    ['write'] = {'UserMgmt'}
                },
                ['validator'] = role_intf_types.Name
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.AccountService.Role'] = {
            ['SetRolePrivilege'] = {
                ['initiator'] = true,
                ['privilege'] = {'UserMgmt'},
                ['req'] = {
                    {['baseType'] = 'U8', ['param'] = 'PrivilegeType'},
                    {['baseType'] = 'Boolean', ['param'] = 'PrivilegeValue'}
                },
                ['rsp'] = {}
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['GetOptions'] = {
                ['req'] = {
                    {
                        ['baseType'] = 'String',
                        ['description'] = '接口名',
                        ['param'] = 'Interface'
                    }, {
                        ['baseType'] = 'String',
                        ['description'] = '属性名',
                        ['param'] = 'Property'
                    }
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['description'] = '按接口名和属性名查询属性的能力选项'
            },
            ['GetPropertiesByOptions'] = {
                ['req'] = {
                    {
                        ['baseType'] = 'String',
                        ['description'] = '接口名',
                        ['param'] = 'Interface'
                    }, {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'String[]',
                        ['description'] = '属性名列表',
                        ['param'] = 'Properties'
                    }
                },
                ['description'] = '按接口名和能力选项查询符合条件的所有属性'
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/AccountService/Roles/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.AccountService.Role'] = {
            ['property_defaults'] = {
                ['RolePrivilege'] = {},
                ['Name'] = role_intf_types.Name.default[1]
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {
                    ['RolePrivilege'] = {
                        ['read'] = privilege.ReadOnly,
                        ['write'] = privilege.UserMgmt
                    },
                    ['Name'] = {
                        ['read'] = privilege.ReadOnly,
                        ['write'] = privilege.UserMgmt
                    }
                },
                ['methods'] = {['SetRolePrivilege'] = privilege.UserMgmt}
            },
            ['interface_types'] = role_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier
                    .default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local SnmpCommunity = {
    ['table_name'] = 't_snmp_community',
    ['prop_configs'] = {
        ['Id'] = {
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['usage'] = {'PoweroffPer'},
            ['description'] = '因持久化需要而添加，无实际作用，AccountService仅有一条数据',
            ['validator'] = snmp_community_class_types.Id
        }
    },
    ['default_props'] = {['Id'] = snmp_community_class_types.Id.default[1]},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Managers.SnmpService.SnmpCommunity'] = {
            ['LongCommunityEnabled'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = false,
                ['default'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['description'] = '长密码开关使能状态',
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {
                    ['read'] = {'ReadOnly'},
                    ['write'] = {'UserMgmt'}
                },
                ['validator'] = snmp_community_intf_types.LongCommunityEnabled
            },
            ['RwCommunityEnabled'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = false,
                ['default'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['description'] = '读写团体名使能',
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {
                    ['read'] = {'ReadOnly'},
                    ['write'] = {'UserMgmt'}
                },
                ['validator'] = snmp_community_intf_types.RwCommunityEnabled
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Managers.SnmpService.SnmpCommunity'] = {
            ['SetRwCommunity'] = {
                ['privilege'] = {'UserMgmt'},
                ['req'] = {{['baseType'] = 'String', ['param'] = 'RwCommunity'}},
                ['rsp'] = {}
            },
            ['SetRoCommunity'] = {
                ['privilege'] = {'UserMgmt'},
                ['req'] = {{['baseType'] = 'String', ['param'] = 'RwCommunity'}},
                ['rsp'] = {}
            },
            ['GetSnmpCommunity'] = {
                ['privilege'] = {'UserMgmt'},
                ['req'] = {},
                ['rsp'] = {
                    {['baseType'] = 'String', ['param'] = 'RwCommunity'},
                    {['baseType'] = 'String', ['param'] = 'RoCommunity'}
                }
            },
            ['SetSnmpCommunityLoginRule'] = {
                ['privilege'] = {'UserMgmt'},
                ['req'] = {
                    {['baseType'] = 'String[]', ['param'] = 'LoginRuleIds'}
                },
                ['rsp'] = {}
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['GetOptions'] = {
                ['req'] = {
                    {
                        ['baseType'] = 'String',
                        ['description'] = '接口名',
                        ['param'] = 'Interface'
                    }, {
                        ['baseType'] = 'String',
                        ['description'] = '属性名',
                        ['param'] = 'Property'
                    }
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['description'] = '按接口名和属性名查询属性的能力选项'
            },
            ['GetPropertiesByOptions'] = {
                ['req'] = {
                    {
                        ['baseType'] = 'String',
                        ['description'] = '接口名',
                        ['param'] = 'Interface'
                    }, {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'String[]',
                        ['description'] = '属性名列表',
                        ['param'] = 'Properties'
                    }
                },
                ['description'] = '按接口名和能力选项查询符合条件的所有属性'
            }
        }
    },
    ['mdb_signal_configs'] = {
        ['bmc.kepler.Managers.SnmpService.SnmpCommunity'] = {
            ['SnmpCommunityChangedSignal'] = {
                {['baseType'] = 'String', ['param'] = 'RoCommunity'},
                {['baseType'] = 'String', ['param'] = 'RwCommunity'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj(
        '/bmc/kepler/Managers/:ManagerId/SnmpService/SnmpCommunity'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Managers.SnmpService.SnmpCommunity'] = {
            ['property_defaults'] = {
                ['LongCommunityEnabled'] = true,
                ['RwCommunityEnabled'] = true
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {
                    ['LongCommunityEnabled'] = {
                        ['read'] = privilege.ReadOnly,
                        ['write'] = privilege.UserMgmt
                    },
                    ['RwCommunityEnabled'] = {
                        ['read'] = privilege.ReadOnly,
                        ['write'] = privilege.UserMgmt
                    }
                },
                ['methods'] = {
                    ['SetRwCommunity'] = privilege.UserMgmt,
                    ['SetRoCommunity'] = privilege.UserMgmt,
                    ['GetSnmpCommunity'] = privilege.UserMgmt,
                    ['SetSnmpCommunityLoginRule'] = privilege.UserMgmt
                }
            },
            ['interface_types'] = snmp_community_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier
                    .default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local LocalAccountAuthN = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.AccountService.LocalAccountAuthN'] = {},
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.AccountService.LocalAccountAuthN'] = {
            ['LocalAuthenticate'] = {
                ['initiator'] = true,
                ['privilege'] = {'ReadOnly'},
                ['req'] = {
                    {
                        ['baseType'] = 'String',
                        ['maxLength'] = 32,
                        ['minLength'] = 1,
                        ['param'] = 'UserName'
                    }, {['baseType'] = 'U8[]', ['param'] = 'Password'},
                    {
                        ['baseType'] = 'Dictionary',
                        ['$ref'] = '#/defs/Config',
                        ['param'] = 'Config'
                    }
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'Dictionary',
                        ['$ref'] = '#/defs/AccountData',
                        ['param'] = 'AccountData'
                    }
                }
            },
            ['VncAuthenticate'] = {
                ['initiator'] = true,
                ['privilege'] = {'ReadOnly'},
                ['req'] = {
                    {['baseType'] = 'String', ['param'] = 'CipherText'},
                    {['baseType'] = 'String', ['param'] = 'AuthChallenge'}
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'Dictionary',
                        ['$ref'] = '#/defs/AccountData',
                        ['param'] = 'AccountData'
                    }
                }
            },
            ['GenRmcp20Code'] = {
                ['initiator'] = true,
                ['req'] = {
                    {['baseType'] = 'U8', ['param'] = 'AuthAlgo'}, {
                        ['baseType'] = 'String',
                        ['maxLength'] = 32,
                        ['minLength'] = 1,
                        ['param'] = 'UserName'
                    }, {['baseType'] = 'U32', ['param'] = 'ConsoleSid'},
                    {['baseType'] = 'U32', ['param'] = 'ManagedSid'}, {
                        ['baseType'] = 'U8[]',
                        ['maxLength'] = 16,
                        ['minLength'] = 16,
                        ['param'] = 'ConsoleRandom'
                    }, {
                        ['baseType'] = 'U8[]',
                        ['maxLength'] = 16,
                        ['minLength'] = 16,
                        ['param'] = 'ManagedRandom'
                    }, {
                        ['baseType'] = 'U8[]',
                        ['maxLength'] = 16,
                        ['minLength'] = 16,
                        ['param'] = 'ManagedGuid'
                    }, {['baseType'] = 'U8', ['param'] = 'Role'},
                    {['baseType'] = 'String', ['param'] = 'Ip'}
                },
                ['rsp'] = {
                    {['baseType'] = 'U8[]', ['param'] = 'Rap2AuthCode'},
                    {['baseType'] = 'U8[]', ['param'] = 'Sik'},
                    {['baseType'] = 'U8[]', ['param'] = 'Rap3AuthCode'}
                }
            },
            ['GenRmcp15Code'] = {
                ['initiator'] = true,
                ['req'] = {
                    {['baseType'] = 'U8', ['param'] = 'AuthAlgo'}, {
                        ['baseType'] = 'U8[]',
                        ['maxLength'] = 255,
                        ['minLength'] = 1,
                        ['param'] = 'PayLoad'
                    }, {['baseType'] = 'U8', ['param'] = 'AccountId'},
                    {['baseType'] = 'U32', ['param'] = 'SessionId'},
                    {['baseType'] = 'U32', ['param'] = 'SessionSequence'}
                },
                ['rsp'] = {{['baseType'] = 'U8[]', ['param'] = 'AuthCode'}},
                ['description'] = 'IPMI1.5版本用户认证方法'
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['GetOptions'] = {
                ['req'] = {
                    {
                        ['baseType'] = 'String',
                        ['description'] = '接口名',
                        ['param'] = 'Interface'
                    }, {
                        ['baseType'] = 'String',
                        ['description'] = '属性名',
                        ['param'] = 'Property'
                    }
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['description'] = '按接口名和属性名查询属性的能力选项'
            },
            ['GetPropertiesByOptions'] = {
                ['req'] = {
                    {
                        ['baseType'] = 'String',
                        ['description'] = '接口名',
                        ['param'] = 'Interface'
                    }, {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'String[]',
                        ['description'] = '属性名列表',
                        ['param'] = 'Properties'
                    }
                },
                ['description'] = '按接口名和能力选项查询符合条件的所有属性'
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj(
        '/bmc/kepler/AccountService/LocalAccountAuthN'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.AccountService.LocalAccountAuthN'] = {
            ['property_defaults'] = {},
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['methods'] = {
                    ['LocalAuthenticate'] = privilege.ReadOnly,
                    ['VncAuthenticate'] = privilege.ReadOnly
                }
            },
            ['interface_types'] = local_account_auth_n_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier
                    .default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local AccountBackup = {
    ['table_name'] = 't_account_backup',
    ['prop_configs'] = {
        ['Id'] = {
            ['baseType'] = 'U8',
            ['description'] = '',
            ['primaryKey'] = true,
            ['usage'] = {'PermanentPer'},
            ['validator'] = account_backup_class_types.Id
        },
        ['UserName'] = {
            ['baseType'] = 'String',
            ['description'] = '',
            ['uniqueKey'] = true,
            ['usage'] = {'PermanentPer'},
            ['validator'] = account_backup_class_types.UserName
        },
        ['Password'] = {
            ['baseType'] = 'String',
            ['description'] = '',
            ['notAllowNull'] = true,
            ['usage'] = {'PermanentPer'},
            ['sensitive'] = true,
            ['validator'] = account_backup_class_types.Password
        },
        ['RoleId'] = {
            ['baseType'] = 'U8',
            ['description'] = '',
            ['default'] = 0,
            ['usage'] = {'PermanentPer'},
            ['validator'] = account_backup_class_types.RoleId
        },
        ['LoginInterface'] = {
            ['baseType'] = 'U32',
            ['description'] = '',
            ['default'] = 0,
            ['usage'] = {'PermanentPer'},
            ['validator'] = account_backup_class_types.LoginInterface
        },
        ['Enabled'] = {
            ['baseType'] = 'Boolean',
            ['description'] = '',
            ['default'] = false,
            ['usage'] = {'PermanentPer'},
            ['validator'] = account_backup_class_types.Enabled
        }
    },
    ['default_props'] = {
        ['Id'] = account_backup_class_types.Id.default[1],
        ['UserName'] = account_backup_class_types.UserName.default[1],
        ['Password'] = account_backup_class_types.Password.default[1],
        ['RoleId'] = 0,
        ['LoginInterface'] = 0,
        ['Enabled'] = false
    }
}

local PasswordPolicy = {
    ['table_name'] = 't_password_policy',
    ['prop_configs'] = {
        ['AccountType'] = {
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = password_policy_class_types.AccountType
        }
    },
    ['default_props'] = {
        ['AccountType'] = password_policy_class_types.AccountType.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.AccountService.PasswordPolicy'] = {
            ['Policy'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '密码校验策略,以bit位区分,bit0 默认开关,bit1 指定开关,取值不可为0',
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {
                    ['read'] = {'ReadOnly'},
                    ['write'] = {'SecurityMgmt'}
                },
                ['default'] = 1,
                ['validator'] = password_policy_intf_types.Policy
            },
            ['Pattern'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['maxLength'] = 255,
                ['minLength'] = 0,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '密码校验正则表达式',
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {
                    ['read'] = {'ReadOnly'},
                    ['write'] = {'SecurityMgmt'}
                },
                ['validator'] = password_policy_intf_types.Pattern
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Object.Properties'] = {
            ['GetOptions'] = {
                ['req'] = {
                    {
                        ['baseType'] = 'String',
                        ['description'] = '接口名',
                        ['param'] = 'Interface'
                    }, {
                        ['baseType'] = 'String',
                        ['description'] = '属性名',
                        ['param'] = 'Property'
                    }
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['description'] = '按接口名和属性名查询属性的能力选项'
            },
            ['GetPropertiesByOptions'] = {
                ['req'] = {
                    {
                        ['baseType'] = 'String',
                        ['description'] = '接口名',
                        ['param'] = 'Interface'
                    }, {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'String[]',
                        ['description'] = '属性名列表',
                        ['param'] = 'Properties'
                    }
                },
                ['description'] = '按接口名和能力选项查询符合条件的所有属性'
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj(
        '/bmc/kepler/AccountService/PasswordPolicys/:AccountType'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.AccountService.PasswordPolicy'] = {
            ['property_defaults'] = {
                ['Policy'] = 1,
                ['Pattern'] = password_policy_intf_types.Pattern.default[1]
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {
                    ['Policy'] = {
                        ['read'] = privilege.ReadOnly,
                        ['write'] = privilege.SecurityMgmt
                    },
                    ['Pattern'] = {
                        ['read'] = privilege.ReadOnly,
                        ['write'] = privilege.SecurityMgmt
                    }
                }
            },
            ['interface_types'] = password_policy_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier
                    .default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local LocalAccountPolicy = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.AccountService.AccountPolicy'] = {
            ['NamePattern'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['default'] = '',
                ['maxLength'] = 255,
                ['minLength'] = 0,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '用户名正则规则',
                ['privilege'] = {
                    ['read'] = {'ReadOnly'},
                    ['write'] = {'SecurityMgmt'}
                },
                ['validator'] = account_policy_intf_types.NamePattern
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Object.Properties'] = {
            ['GetOptions'] = {
                ['req'] = {
                    {
                        ['baseType'] = 'String',
                        ['description'] = '接口名',
                        ['param'] = 'Interface'
                    }, {
                        ['baseType'] = 'String',
                        ['description'] = '属性名',
                        ['param'] = 'Property'
                    }
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['description'] = '按接口名和属性名查询属性的能力选项'
            },
            ['GetPropertiesByOptions'] = {
                ['req'] = {
                    {
                        ['baseType'] = 'String',
                        ['description'] = '接口名',
                        ['param'] = 'Interface'
                    }, {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'String[]',
                        ['description'] = '属性名列表',
                        ['param'] = 'Properties'
                    }
                },
                ['description'] = '按接口名和能力选项查询符合条件的所有属性'
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj(
        '/bmc/kepler/AccountService/AccountPolicies/Local'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.AccountService.AccountPolicy'] = {
            ['property_defaults'] = {['NamePattern'] = ''},
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {
                    ['NamePattern'] = {
                        ['read'] = privilege.ReadOnly,
                        ['write'] = privilege.SecurityMgmt
                    }
                }
            },
            ['interface_types'] = account_policy_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier
                    .default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local AccountPolicy = {
    ['table_name'] = 't_account_policy',
    ['prop_configs'] = {
        ['AccountType'] = {
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = account_policy_class_types.AccountType
        },
        ['NamePattern'] = {
            ['baseType'] = 'String',
            ['default'] = '',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = account_policy_class_types.NamePattern
        }
    },
    ['default_props'] = {
        ['AccountType'] = account_policy_class_types.AccountType.default[1],
        ['NamePattern'] = ''
    }
}

local M = {}

function M.init(bus)
    class('AccountService', AccountService):set_bus(bus)
    class('ManagerAccounts', ManagerAccounts):set_bus(bus)
    class('ManagerAccount', ManagerAccount):set_bus(bus)
    class('ManagerAccountDB', ManagerAccountDB):set_bus(bus)
    class('ManagerAccountBackup', ManagerAccountBackup):set_bus(bus)
    class('SNMPUserInfo', SNMPUserInfo):set_bus(bus)
    class('IpmiUserInfo', IpmiUserInfo):set_bus(bus)
    class('HistoryPassword', HistoryPassword):set_bus(bus)
    class('Rule', Rule):set_bus(bus)
    class('LoginRule', LoginRule):set_bus(bus)
    class('Role', Role):set_bus(bus)
    class('SnmpCommunity', SnmpCommunity):set_bus(bus)
    class('LocalAccountAuthN', LocalAccountAuthN):set_bus(bus)
    class('AccountBackup', AccountBackup):set_bus(bus)
    class('PasswordPolicy', PasswordPolicy):set_bus(bus)
    class('LocalAccountPolicy', LocalAccountPolicy):set_bus(bus)
    class('AccountPolicy', AccountPolicy):set_bus(bus)
end

-- The callback needs to be registered during app initialization
function M.ImplAccountServiceAccountServiceImportWeakPasswordDictionary(cb)
    class('AccountService')['bmc.kepler.AccountService']
        .ImportWeakPasswordDictionary = function(obj, ctx, ...)
        local req = account_service_intf_types.ImportWeakPasswordDictionaryReq
                        .new(...):validate(nil, nil, true)
        local rsp = account_service_intf_types.ImportWeakPasswordDictionaryRsp
                        .new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplAccountServiceAccountServiceExportWeakPasswordDictionary(cb)
    class('AccountService')['bmc.kepler.AccountService']
        .ExportWeakPasswordDictionary = function(obj, ctx, ...)
        local req = account_service_intf_types.ExportWeakPasswordDictionaryReq
                        .new(...):validate(nil, nil, true)
        local rsp = account_service_intf_types.ExportWeakPasswordDictionaryRsp
                        .new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplAccountServiceAccountServiceGetRequestedPublicKey(cb)
    class('AccountService')['bmc.kepler.AccountService'].GetRequestedPublicKey =
        function(obj, ctx, ...)
            local req =
                account_service_intf_types.GetRequestedPublicKeyReq.new(...):validate(
                    nil, nil, true)
            local rsp =
                account_service_intf_types.GetRequestedPublicKeyRsp.new(cb(obj,
                                                                           ctx,
                                                                           req:unpack())):validate()
            return rsp:unpack(true)
        end
end

-- The callback needs to be registered during app initialization
function M.ImplAccountServiceAccountServiceRecoverAccount(cb)
    class('AccountService')['bmc.kepler.AccountService'].RecoverAccount =
        function(obj, ctx, ...)
            local req =
                account_service_intf_types.RecoverAccountReq.new(...):validate(
                    nil, nil, true)
            local rsp = account_service_intf_types.RecoverAccountRsp.new(cb(obj,
                                                                            ctx,
                                                                            req:unpack())):validate()
            return rsp:unpack(true)
        end
end

-- The callback needs to be registered during app initialization
function M.ImplAccountServicePropertiesGetOptions(cb)
    class('AccountService')['bmc.kepler.Object.Properties'].GetOptions =
        function(obj, ctx, ...)
            local req =
                properties_intf_types.GetOptionsReq.new(...):validate(nil, nil,
                                                                      true)
            local rsp = properties_intf_types.GetOptionsRsp.new(cb(obj, ctx,
                                                                   req:unpack())):validate()
            return rsp:unpack(true)
        end
end

-- The callback needs to be registered during app initialization
function M.ImplAccountServicePropertiesGetPropertiesByOptions(cb)
    class('AccountService')['bmc.kepler.Object.Properties']
        .GetPropertiesByOptions = function(obj, ctx, ...)
        local req =
            properties_intf_types.GetPropertiesByOptionsReq.new(...):validate(
                nil, nil, true)
        local rsp = properties_intf_types.GetPropertiesByOptionsRsp.new(cb(obj,
                                                                           ctx,
                                                                           req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplManagerAccountsManagerAccountsNew(cb)
    class('ManagerAccounts')['bmc.kepler.AccountService.ManagerAccounts'].New =
        function(obj, ctx, ...)
            local req =
                manager_accounts_intf_types.NewReq.new(...):validate(nil, nil,
                                                                     true)
            local rsp = manager_accounts_intf_types.NewRsp.new(cb(obj, ctx,
                                                                  req:unpack())):validate()
            return rsp:unpack(true)
        end
end

-- The callback needs to be registered during app initialization
function M.ImplManagerAccountsManagerAccountsNewOEMAccount(cb)
    class('ManagerAccounts')['bmc.kepler.AccountService.ManagerAccounts']
        .NewOEMAccount = function(obj, ctx, ...)
        local req =
            manager_accounts_intf_types.NewOEMAccountReq.new(...):validate(nil,
                                                                           nil,
                                                                           true)
        local rsp = manager_accounts_intf_types.NewOEMAccountRsp.new(cb(obj,
                                                                        ctx,
                                                                        req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplManagerAccountsManagerAccountsGetIdByUserName(cb)
    class('ManagerAccounts')['bmc.kepler.AccountService.ManagerAccounts']
        .GetIdByUserName = function(obj, ctx, ...)
        local req =
            manager_accounts_intf_types.GetIdByUserNameReq.new(...):validate(
                nil, nil, true)
        local rsp = manager_accounts_intf_types.GetIdByUserNameRsp.new(cb(obj,
                                                                          ctx,
                                                                          req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplManagerAccountsManagerAccountsGetUidGidByUserName(cb)
    class('ManagerAccounts')['bmc.kepler.AccountService.ManagerAccounts']
        .GetUidGidByUserName = function(obj, ctx, ...)
        local req =
            manager_accounts_intf_types.GetUidGidByUserNameReq.new(...):validate(
                nil, nil, true)
        local rsp = manager_accounts_intf_types.GetUidGidByUserNameRsp.new(cb(
                                                                               obj,
                                                                               ctx,
                                                                               req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplManagerAccountsManagerAccountsSetAccountWritable(cb)
    class('ManagerAccounts')['bmc.kepler.AccountService.ManagerAccounts']
        .SetAccountWritable = function(obj, ctx, ...)
        local req =
            manager_accounts_intf_types.SetAccountWritableReq.new(...):validate(
                nil, nil, true)
        local rsp = manager_accounts_intf_types.SetAccountWritableRsp.new(cb(
                                                                              obj,
                                                                              ctx,
                                                                              req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplManagerAccountsManagerAccountsGetAccountWritable(cb)
    class('ManagerAccounts')['bmc.kepler.AccountService.ManagerAccounts']
        .GetAccountWritable = function(obj, ctx, ...)
        local req =
            manager_accounts_intf_types.GetAccountWritableReq.new(...):validate(
                nil, nil, true)
        local rsp = manager_accounts_intf_types.GetAccountWritableRsp.new(cb(
                                                                              obj,
                                                                              ctx,
                                                                              req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplManagerAccountsManagerAccountsSetAccountLockState(cb)
    class('ManagerAccounts')['bmc.kepler.AccountService.ManagerAccounts']
        .SetAccountLockState = function(obj, ctx, ...)
        local req =
            manager_accounts_intf_types.SetAccountLockStateReq.new(...):validate(
                nil, nil, true)
        local rsp = manager_accounts_intf_types.SetAccountLockStateRsp.new(cb(
                                                                               obj,
                                                                               ctx,
                                                                               req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplManagerAccountsPropertiesGetOptions(cb)
    class('ManagerAccounts')['bmc.kepler.Object.Properties'].GetOptions =
        function(obj, ctx, ...)
            local req =
                properties_intf_types.GetOptionsReq.new(...):validate(nil, nil,
                                                                      true)
            local rsp = properties_intf_types.GetOptionsRsp.new(cb(obj, ctx,
                                                                   req:unpack())):validate()
            return rsp:unpack(true)
        end
end

-- The callback needs to be registered during app initialization
function M.ImplManagerAccountsPropertiesGetPropertiesByOptions(cb)
    class('ManagerAccounts')['bmc.kepler.Object.Properties']
        .GetPropertiesByOptions = function(obj, ctx, ...)
        local req =
            properties_intf_types.GetPropertiesByOptionsReq.new(...):validate(
                nil, nil, true)
        local rsp = properties_intf_types.GetPropertiesByOptionsRsp.new(cb(obj,
                                                                           ctx,
                                                                           req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplManagerAccountManagerAccountDelete(cb)
    class('ManagerAccount')['bmc.kepler.AccountService.ManagerAccount'].Delete =
        function(obj, ctx, ...)
            local req =
                manager_account_intf_types.DeleteReq.new(...):validate(nil, nil,
                                                                       true)
            local rsp = manager_account_intf_types.DeleteRsp.new(cb(obj, ctx,
                                                                    req:unpack())):validate()
            return rsp:unpack(true)
        end
end

-- The callback needs to be registered during app initialization
function M.ImplManagerAccountManagerAccountChangePwd(cb)
    class('ManagerAccount')['bmc.kepler.AccountService.ManagerAccount']
        .ChangePwd = function(obj, ctx, ...)
        local req = manager_account_intf_types.ChangePwdReq.new(...):validate(
                        nil, nil, true)
        local rsp = manager_account_intf_types.ChangePwdRsp.new(cb(obj, ctx,
                                                                   req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplManagerAccountManagerAccountChangeSnmpPwd(cb)
    class('ManagerAccount')['bmc.kepler.AccountService.ManagerAccount']
        .ChangeSnmpPwd = function(obj, ctx, ...)
        local req =
            manager_account_intf_types.ChangeSnmpPwdReq.new(...):validate(nil,
                                                                          nil,
                                                                          true)
        local rsp = manager_account_intf_types.ChangeSnmpPwdRsp.new(cb(obj, ctx,
                                                                       req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplManagerAccountManagerAccountImportSSHPublicKey(cb)
    class('ManagerAccount')['bmc.kepler.AccountService.ManagerAccount']
        .ImportSSHPublicKey = function(obj, ctx, ...)
        local req =
            manager_account_intf_types.ImportSSHPublicKeyReq.new(...):validate(
                nil, nil, true)
        local rsp = manager_account_intf_types.ImportSSHPublicKeyRsp.new(cb(obj,
                                                                            ctx,
                                                                            req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplManagerAccountManagerAccountDeleteSSHPublicKey(cb)
    class('ManagerAccount')['bmc.kepler.AccountService.ManagerAccount']
        .DeleteSSHPublicKey = function(obj, ctx, ...)
        local req =
            manager_account_intf_types.DeleteSSHPublicKeyReq.new(...):validate(
                nil, nil, true)
        local rsp = manager_account_intf_types.DeleteSSHPublicKeyRsp.new(cb(obj,
                                                                            ctx,
                                                                            req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplManagerAccountManagerAccountSetLastLogin(cb)
    class('ManagerAccount')['bmc.kepler.AccountService.ManagerAccount']
        .SetLastLogin = function(obj, ctx, ...)
        local req =
            manager_account_intf_types.SetLastLoginReq.new(...):validate(nil,
                                                                         nil,
                                                                         true)
        local rsp = manager_account_intf_types.SetLastLoginRsp.new(cb(obj, ctx,
                                                                      req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplManagerAccountSnmpUserSetAuthenticationProtocol(cb)
    class('ManagerAccount')['bmc.kepler.AccountService.ManagerAccount.SnmpUser']
        .SetAuthenticationProtocol = function(obj, ctx, ...)
        local req =
            snmp_user_intf_types.SetAuthenticationProtocolReq.new(...):validate(
                nil, nil, true)
        local rsp = snmp_user_intf_types.SetAuthenticationProtocolRsp.new(cb(
                                                                              obj,
                                                                              ctx,
                                                                              req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplManagerAccountSnmpUserSetEncryptionProtocol(cb)
    class('ManagerAccount')['bmc.kepler.AccountService.ManagerAccount.SnmpUser']
        .SetEncryptionProtocol = function(obj, ctx, ...)
        local req =
            snmp_user_intf_types.SetEncryptionProtocolReq.new(...):validate(nil,
                                                                            nil,
                                                                            true)
        local rsp = snmp_user_intf_types.SetEncryptionProtocolRsp.new(cb(obj,
                                                                         ctx,
                                                                         req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplManagerAccountSnmpUserGetSnmpKeys(cb)
    class('ManagerAccount')['bmc.kepler.AccountService.ManagerAccount.SnmpUser']
        .GetSnmpKeys = function(obj, ctx, ...)
        local req = snmp_user_intf_types.GetSnmpKeysReq.new(...):validate(nil,
                                                                          nil,
                                                                          true)
        local rsp = snmp_user_intf_types.GetSnmpKeysRsp.new(cb(obj, ctx,
                                                               req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplManagerAccountPropertiesGetOptions(cb)
    class('ManagerAccount')['bmc.kepler.Object.Properties'].GetOptions =
        function(obj, ctx, ...)
            local req =
                properties_intf_types.GetOptionsReq.new(...):validate(nil, nil,
                                                                      true)
            local rsp = properties_intf_types.GetOptionsRsp.new(cb(obj, ctx,
                                                                   req:unpack())):validate()
            return rsp:unpack(true)
        end
end

-- The callback needs to be registered during app initialization
function M.ImplManagerAccountPropertiesGetPropertiesByOptions(cb)
    class('ManagerAccount')['bmc.kepler.Object.Properties']
        .GetPropertiesByOptions = function(obj, ctx, ...)
        local req =
            properties_intf_types.GetPropertiesByOptionsReq.new(...):validate(
                nil, nil, true)
        local rsp = properties_intf_types.GetPropertiesByOptionsRsp.new(cb(obj,
                                                                           ctx,
                                                                           req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplRulePropertiesGetOptions(cb)
    class('Rule')['bmc.kepler.Object.Properties'].GetOptions =
        function(obj, ctx, ...)
            local req =
                properties_intf_types.GetOptionsReq.new(...):validate(nil, nil,
                                                                      true)
            local rsp = properties_intf_types.GetOptionsRsp.new(cb(obj, ctx,
                                                                   req:unpack())):validate()
            return rsp:unpack(true)
        end
end

-- The callback needs to be registered during app initialization
function M.ImplRulePropertiesGetPropertiesByOptions(cb)
    class('Rule')['bmc.kepler.Object.Properties'].GetPropertiesByOptions =
        function(obj, ctx, ...)
            local req =
                properties_intf_types.GetPropertiesByOptionsReq.new(...):validate(
                    nil, nil, true)
            local rsp =
                properties_intf_types.GetPropertiesByOptionsRsp.new(cb(obj, ctx,
                                                                       req:unpack())):validate()
            return rsp:unpack(true)
        end
end

-- The callback needs to be registered during app initialization
function M.ImplRoleRoleSetRolePrivilege(cb)
    class('Role')['bmc.kepler.AccountService.Role'].SetRolePrivilege = function(
        obj, ctx, ...)
        local req = role_intf_types.SetRolePrivilegeReq.new(...):validate(nil,
                                                                          nil,
                                                                          true)
        local rsp = role_intf_types.SetRolePrivilegeRsp.new(cb(obj, ctx,
                                                               req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplRolePropertiesGetOptions(cb)
    class('Role')['bmc.kepler.Object.Properties'].GetOptions =
        function(obj, ctx, ...)
            local req =
                properties_intf_types.GetOptionsReq.new(...):validate(nil, nil,
                                                                      true)
            local rsp = properties_intf_types.GetOptionsRsp.new(cb(obj, ctx,
                                                                   req:unpack())):validate()
            return rsp:unpack(true)
        end
end

-- The callback needs to be registered during app initialization
function M.ImplRolePropertiesGetPropertiesByOptions(cb)
    class('Role')['bmc.kepler.Object.Properties'].GetPropertiesByOptions =
        function(obj, ctx, ...)
            local req =
                properties_intf_types.GetPropertiesByOptionsReq.new(...):validate(
                    nil, nil, true)
            local rsp =
                properties_intf_types.GetPropertiesByOptionsRsp.new(cb(obj, ctx,
                                                                       req:unpack())):validate()
            return rsp:unpack(true)
        end
end

-- The callback needs to be registered during app initialization
function M.ImplSnmpCommunitySnmpCommunitySetRwCommunity(cb)
    class('SnmpCommunity')['bmc.kepler.Managers.SnmpService.SnmpCommunity']
        .SetRwCommunity = function(obj, ctx, ...)
        local req =
            snmp_community_intf_types.SetRwCommunityReq.new(...):validate(nil,
                                                                          nil,
                                                                          true)
        local rsp = snmp_community_intf_types.SetRwCommunityRsp.new(cb(obj, ctx,
                                                                       req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSnmpCommunitySnmpCommunitySetRoCommunity(cb)
    class('SnmpCommunity')['bmc.kepler.Managers.SnmpService.SnmpCommunity']
        .SetRoCommunity = function(obj, ctx, ...)
        local req =
            snmp_community_intf_types.SetRoCommunityReq.new(...):validate(nil,
                                                                          nil,
                                                                          true)
        local rsp = snmp_community_intf_types.SetRoCommunityRsp.new(cb(obj, ctx,
                                                                       req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSnmpCommunitySnmpCommunityGetSnmpCommunity(cb)
    class('SnmpCommunity')['bmc.kepler.Managers.SnmpService.SnmpCommunity']
        .GetSnmpCommunity = function(obj, ctx, ...)
        local req =
            snmp_community_intf_types.GetSnmpCommunityReq.new(...):validate(nil,
                                                                            nil,
                                                                            true)
        local rsp = snmp_community_intf_types.GetSnmpCommunityRsp.new(cb(obj,
                                                                         ctx,
                                                                         req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSnmpCommunitySnmpCommunitySetSnmpCommunityLoginRule(cb)
    class('SnmpCommunity')['bmc.kepler.Managers.SnmpService.SnmpCommunity']
        .SetSnmpCommunityLoginRule = function(obj, ctx, ...)
        local req = snmp_community_intf_types.SetSnmpCommunityLoginRuleReq.new(
                        ...):validate(nil, nil, true)
        local rsp = snmp_community_intf_types.SetSnmpCommunityLoginRuleRsp.new(
                        cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSnmpCommunityPropertiesGetOptions(cb)
    class('SnmpCommunity')['bmc.kepler.Object.Properties'].GetOptions =
        function(obj, ctx, ...)
            local req =
                properties_intf_types.GetOptionsReq.new(...):validate(nil, nil,
                                                                      true)
            local rsp = properties_intf_types.GetOptionsRsp.new(cb(obj, ctx,
                                                                   req:unpack())):validate()
            return rsp:unpack(true)
        end
end

-- The callback needs to be registered during app initialization
function M.ImplSnmpCommunityPropertiesGetPropertiesByOptions(cb)
    class('SnmpCommunity')['bmc.kepler.Object.Properties']
        .GetPropertiesByOptions = function(obj, ctx, ...)
        local req =
            properties_intf_types.GetPropertiesByOptionsReq.new(...):validate(
                nil, nil, true)
        local rsp = properties_intf_types.GetPropertiesByOptionsRsp.new(cb(obj,
                                                                           ctx,
                                                                           req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplLocalAccountAuthNLocalAccountAuthNLocalAuthenticate(cb)
    class('LocalAccountAuthN')['bmc.kepler.AccountService.LocalAccountAuthN']
        .LocalAuthenticate = function(obj, ctx, ...)
        local req = local_account_auth_n_intf_types.LocalAuthenticateReq
                        .new(...):validate(nil, nil, true)
        local rsp = local_account_auth_n_intf_types.LocalAuthenticateRsp.new(cb(
                                                                                 obj,
                                                                                 ctx,
                                                                                 req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplLocalAccountAuthNLocalAccountAuthNVncAuthenticate(cb)
    class('LocalAccountAuthN')['bmc.kepler.AccountService.LocalAccountAuthN']
        .VncAuthenticate = function(obj, ctx, ...)
        local req =
            local_account_auth_n_intf_types.VncAuthenticateReq.new(...):validate(
                nil, nil, true)
        local rsp = local_account_auth_n_intf_types.VncAuthenticateRsp.new(cb(
                                                                               obj,
                                                                               ctx,
                                                                               req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplLocalAccountAuthNLocalAccountAuthNGenRmcp20Code(cb)
    class('LocalAccountAuthN')['bmc.kepler.AccountService.LocalAccountAuthN']
        .GenRmcp20Code = function(obj, ctx, ...)
        local req =
            local_account_auth_n_intf_types.GenRmcp20CodeReq.new(...):validate(
                nil, nil, true)
        local rsp = local_account_auth_n_intf_types.GenRmcp20CodeRsp.new(cb(obj,
                                                                            ctx,
                                                                            req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplLocalAccountAuthNLocalAccountAuthNGenRmcp15Code(cb)
    class('LocalAccountAuthN')['bmc.kepler.AccountService.LocalAccountAuthN']
        .GenRmcp15Code = function(obj, ctx, ...)
        local req =
            local_account_auth_n_intf_types.GenRmcp15CodeReq.new(...):validate(
                nil, nil, true)
        local rsp = local_account_auth_n_intf_types.GenRmcp15CodeRsp.new(cb(obj,
                                                                            ctx,
                                                                            req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplLocalAccountAuthNPropertiesGetOptions(cb)
    class('LocalAccountAuthN')['bmc.kepler.Object.Properties'].GetOptions =
        function(obj, ctx, ...)
            local req =
                properties_intf_types.GetOptionsReq.new(...):validate(nil, nil,
                                                                      true)
            local rsp = properties_intf_types.GetOptionsRsp.new(cb(obj, ctx,
                                                                   req:unpack())):validate()
            return rsp:unpack(true)
        end
end

-- The callback needs to be registered during app initialization
function M.ImplLocalAccountAuthNPropertiesGetPropertiesByOptions(cb)
    class('LocalAccountAuthN')['bmc.kepler.Object.Properties']
        .GetPropertiesByOptions = function(obj, ctx, ...)
        local req =
            properties_intf_types.GetPropertiesByOptionsReq.new(...):validate(
                nil, nil, true)
        local rsp = properties_intf_types.GetPropertiesByOptionsRsp.new(cb(obj,
                                                                           ctx,
                                                                           req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplPasswordPolicyPropertiesGetOptions(cb)
    class('PasswordPolicy')['bmc.kepler.Object.Properties'].GetOptions =
        function(obj, ctx, ...)
            local req =
                properties_intf_types.GetOptionsReq.new(...):validate(nil, nil,
                                                                      true)
            local rsp = properties_intf_types.GetOptionsRsp.new(cb(obj, ctx,
                                                                   req:unpack())):validate()
            return rsp:unpack(true)
        end
end

-- The callback needs to be registered during app initialization
function M.ImplPasswordPolicyPropertiesGetPropertiesByOptions(cb)
    class('PasswordPolicy')['bmc.kepler.Object.Properties']
        .GetPropertiesByOptions = function(obj, ctx, ...)
        local req =
            properties_intf_types.GetPropertiesByOptionsReq.new(...):validate(
                nil, nil, true)
        local rsp = properties_intf_types.GetPropertiesByOptionsRsp.new(cb(obj,
                                                                           ctx,
                                                                           req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplLocalAccountPolicyPropertiesGetOptions(cb)
    class('LocalAccountPolicy')['bmc.kepler.Object.Properties'].GetOptions =
        function(obj, ctx, ...)
            local req =
                properties_intf_types.GetOptionsReq.new(...):validate(nil, nil,
                                                                      true)
            local rsp = properties_intf_types.GetOptionsRsp.new(cb(obj, ctx,
                                                                   req:unpack())):validate()
            return rsp:unpack(true)
        end
end

-- The callback needs to be registered during app initialization
function M.ImplLocalAccountPolicyPropertiesGetPropertiesByOptions(cb)
    class('LocalAccountPolicy')['bmc.kepler.Object.Properties']
        .GetPropertiesByOptions = function(obj, ctx, ...)
        local req =
            properties_intf_types.GetPropertiesByOptionsReq.new(...):validate(
                nil, nil, true)
        local rsp = properties_intf_types.GetPropertiesByOptionsRsp.new(cb(obj,
                                                                           ctx,
                                                                           req:unpack())):validate()
        return rsp:unpack(true)
    end
end

return M
