-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-3-15
-- Description: DO NOT EDIT; Code generated by "message.lua.mako"
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'
local create_enum_type = require 'mc.enum'

local SnmpUser = {}

---@class SnmpUser.SNMPKuType: Enum
local ESNMPKuType = create_enum_type('SNMPKuType')
ESNMPKuType.default = ESNMPKuType.new(2147483647)
ESNMPKuType.struct = nil
ESNMPKuType.Authentication = ESNMPKuType.new(0)
ESNMPKuType.Encryption = ESNMPKuType.new(1)

SnmpUser.SNMPKuType = ESNMPKuType

---@class SnmpUser.SNMPEncryptionProtocols: Enum
local ESNMPEncryptionProtocols = create_enum_type('SNMPEncryptionProtocols')
ESNMPEncryptionProtocols.default = ESNMPEncryptionProtocols.new(2147483647)
ESNMPEncryptionProtocols.struct = nil
ESNMPEncryptionProtocols.None = ESNMPEncryptionProtocols.new(0)
ESNMPEncryptionProtocols.DES = ESNMPEncryptionProtocols.new(1)
ESNMPEncryptionProtocols.AES128 = ESNMPEncryptionProtocols.new(2)
ESNMPEncryptionProtocols.AES256 = ESNMPEncryptionProtocols.new(3)

SnmpUser.SNMPEncryptionProtocols = ESNMPEncryptionProtocols

---@class SnmpUser.SNMPAuthenticationProtocols: Enum
local ESNMPAuthenticationProtocols = create_enum_type(
                                         'SNMPAuthenticationProtocols')
ESNMPAuthenticationProtocols.default = ESNMPAuthenticationProtocols.new(
                                           2147483647)
ESNMPAuthenticationProtocols.struct = nil
ESNMPAuthenticationProtocols.None = ESNMPAuthenticationProtocols.new(0)
ESNMPAuthenticationProtocols.MD5 = ESNMPAuthenticationProtocols.new(1)
ESNMPAuthenticationProtocols.SHA96 = ESNMPAuthenticationProtocols.new(2)
ESNMPAuthenticationProtocols.SHA224 = ESNMPAuthenticationProtocols.new(3)
ESNMPAuthenticationProtocols.SHA256 = ESNMPAuthenticationProtocols.new(4)
ESNMPAuthenticationProtocols.SHA384 = ESNMPAuthenticationProtocols.new(5)
ESNMPAuthenticationProtocols.SHA512 = ESNMPAuthenticationProtocols.new(6)

SnmpUser.SNMPAuthenticationProtocols = ESNMPAuthenticationProtocols

---@class SnmpUser.SnmpEncryptionPasswordInitialStatus
---@field SnmpEncryptionPasswordInitialStatus boolean
local TSnmpEncryptionPasswordInitialStatus = {}
TSnmpEncryptionPasswordInitialStatus.__index =
    TSnmpEncryptionPasswordInitialStatus
TSnmpEncryptionPasswordInitialStatus.group = {}

local function TSnmpEncryptionPasswordInitialStatus_from_obj(obj)
    return setmetatable(obj, TSnmpEncryptionPasswordInitialStatus)
end

function TSnmpEncryptionPasswordInitialStatus.new(
    SnmpEncryptionPasswordInitialStatus)
    return TSnmpEncryptionPasswordInitialStatus_from_obj({
        SnmpEncryptionPasswordInitialStatus = SnmpEncryptionPasswordInitialStatus
    })
end
---@param obj SnmpUser.SnmpEncryptionPasswordInitialStatus
function TSnmpEncryptionPasswordInitialStatus:init_from_obj(obj)
    self.SnmpEncryptionPasswordInitialStatus =
        obj.SnmpEncryptionPasswordInitialStatus
end

function TSnmpEncryptionPasswordInitialStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs,
                                    TSnmpEncryptionPasswordInitialStatus.group)
end

TSnmpEncryptionPasswordInitialStatus.from_obj =
    TSnmpEncryptionPasswordInitialStatus_from_obj

TSnmpEncryptionPasswordInitialStatus.proto_property = {
    'SnmpEncryptionPasswordInitialStatus'
}

TSnmpEncryptionPasswordInitialStatus.default = {false}

TSnmpEncryptionPasswordInitialStatus.struct = {
    {
        name = 'SnmpEncryptionPasswordInitialStatus',
        is_array = false,
        struct = nil
    }
}

function TSnmpEncryptionPasswordInitialStatus:validate(prefix, errs,
                                                       need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SnmpEncryptionPasswordInitialStatus',
                      self.SnmpEncryptionPasswordInitialStatus, "bool", true,
                      errs, need_convert)

    TSnmpEncryptionPasswordInitialStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self,
                                 TSnmpEncryptionPasswordInitialStatus.proto_property,
                                 errs, need_convert)
    return self
end

function TSnmpEncryptionPasswordInitialStatus:unpack(_)
    return self.SnmpEncryptionPasswordInitialStatus
end

SnmpUser.SnmpEncryptionPasswordInitialStatus =
    TSnmpEncryptionPasswordInitialStatus

---@class SnmpUser.EncryptionProtocol
---@field EncryptionProtocol integer
local TEncryptionProtocol = {}
TEncryptionProtocol.__index = TEncryptionProtocol
TEncryptionProtocol.group = {}

local function TEncryptionProtocol_from_obj(obj)
    return setmetatable(obj, TEncryptionProtocol)
end

function TEncryptionProtocol.new(EncryptionProtocol)
    return TEncryptionProtocol_from_obj({
        EncryptionProtocol = EncryptionProtocol
    })
end
---@param obj SnmpUser.EncryptionProtocol
function TEncryptionProtocol:init_from_obj(obj)
    self.EncryptionProtocol = obj.EncryptionProtocol
end

function TEncryptionProtocol:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEncryptionProtocol.group)
end

TEncryptionProtocol.from_obj = TEncryptionProtocol_from_obj

TEncryptionProtocol.proto_property = {'EncryptionProtocol'}

TEncryptionProtocol.default = {0}

TEncryptionProtocol.struct = {
    {name = 'EncryptionProtocol', is_array = false, struct = nil}
}

function TEncryptionProtocol:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EncryptionProtocol', self.EncryptionProtocol,
                      "uint8", true, errs, need_convert)

    TEncryptionProtocol:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEncryptionProtocol.proto_property, errs,
                                 need_convert)
    return self
end

function TEncryptionProtocol:unpack(_) return self.EncryptionProtocol end

SnmpUser.EncryptionProtocol = TEncryptionProtocol

---@class SnmpUser.AuthenticationProtocol
---@field AuthenticationProtocol integer
local TAuthenticationProtocol = {}
TAuthenticationProtocol.__index = TAuthenticationProtocol
TAuthenticationProtocol.group = {}

local function TAuthenticationProtocol_from_obj(obj)
    return setmetatable(obj, TAuthenticationProtocol)
end

function TAuthenticationProtocol.new(AuthenticationProtocol)
    return TAuthenticationProtocol_from_obj({
        AuthenticationProtocol = AuthenticationProtocol
    })
end
---@param obj SnmpUser.AuthenticationProtocol
function TAuthenticationProtocol:init_from_obj(obj)
    self.AuthenticationProtocol = obj.AuthenticationProtocol
end

function TAuthenticationProtocol:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAuthenticationProtocol.group)
end

TAuthenticationProtocol.from_obj = TAuthenticationProtocol_from_obj

TAuthenticationProtocol.proto_property = {'AuthenticationProtocol'}

TAuthenticationProtocol.default = {0}

TAuthenticationProtocol.struct = {
    {name = 'AuthenticationProtocol', is_array = false, struct = nil}
}

function TAuthenticationProtocol:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AuthenticationProtocol',
                      self.AuthenticationProtocol, "uint8", true, errs,
                      need_convert)

    TAuthenticationProtocol:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAuthenticationProtocol.proto_property,
                                 errs, need_convert)
    return self
end

function TAuthenticationProtocol:unpack(_) return self.AuthenticationProtocol end

SnmpUser.AuthenticationProtocol = TAuthenticationProtocol

---@class SnmpUser.GetSnmpKeysRsp
---@field AuthenticationKey string
---@field EncryptionKey string
local TGetSnmpKeysRsp = {}
TGetSnmpKeysRsp.__index = TGetSnmpKeysRsp
TGetSnmpKeysRsp.group = {}

local function TGetSnmpKeysRsp_from_obj(obj)
    return setmetatable(obj, TGetSnmpKeysRsp)
end

function TGetSnmpKeysRsp.new(AuthenticationKey, EncryptionKey)
    return TGetSnmpKeysRsp_from_obj({
        AuthenticationKey = AuthenticationKey,
        EncryptionKey = EncryptionKey
    })
end
---@param obj SnmpUser.GetSnmpKeysRsp
function TGetSnmpKeysRsp:init_from_obj(obj)
    self.AuthenticationKey = obj.AuthenticationKey
    self.EncryptionKey = obj.EncryptionKey
end

function TGetSnmpKeysRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSnmpKeysRsp.group)
end

TGetSnmpKeysRsp.from_obj = TGetSnmpKeysRsp_from_obj

TGetSnmpKeysRsp.proto_property = {'AuthenticationKey', 'EncryptionKey'}

TGetSnmpKeysRsp.default = {'', ''}

TGetSnmpKeysRsp.struct = {
    {name = 'AuthenticationKey', is_array = false, struct = nil},
    {name = 'EncryptionKey', is_array = false, struct = nil}
}

function TGetSnmpKeysRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AuthenticationKey', self.AuthenticationKey,
                      "string", false, errs, need_convert)
    validate.Optional(prefix .. 'EncryptionKey', self.EncryptionKey, "string",
                      false, errs, need_convert)

    TGetSnmpKeysRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSnmpKeysRsp.proto_property, errs,
                                 need_convert)
    return self
end

function TGetSnmpKeysRsp:unpack(_)
    return self.AuthenticationKey, self.EncryptionKey
end

SnmpUser.GetSnmpKeysRsp = TGetSnmpKeysRsp

---@class SnmpUser.GetSnmpKeysReq
local TGetSnmpKeysReq = {}
TGetSnmpKeysReq.__index = TGetSnmpKeysReq
TGetSnmpKeysReq.group = {}

local function TGetSnmpKeysReq_from_obj(obj)
    return setmetatable(obj, TGetSnmpKeysReq)
end

function TGetSnmpKeysReq.new() return TGetSnmpKeysReq_from_obj({}) end
---@param obj SnmpUser.GetSnmpKeysReq
function TGetSnmpKeysReq:init_from_obj(obj) end

function TGetSnmpKeysReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSnmpKeysReq.group)
end

TGetSnmpKeysReq.from_obj = TGetSnmpKeysReq_from_obj

TGetSnmpKeysReq.proto_property = {}

TGetSnmpKeysReq.default = {}

TGetSnmpKeysReq.struct = {}

function TGetSnmpKeysReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetSnmpKeysReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSnmpKeysReq.proto_property, errs,
                                 need_convert)
    return self
end

function TGetSnmpKeysReq:unpack(_) end

SnmpUser.GetSnmpKeysReq = TGetSnmpKeysReq

---@class SnmpUser.SetEncryptionProtocolRsp
local TSetEncryptionProtocolRsp = {}
TSetEncryptionProtocolRsp.__index = TSetEncryptionProtocolRsp
TSetEncryptionProtocolRsp.group = {}

local function TSetEncryptionProtocolRsp_from_obj(obj)
    return setmetatable(obj, TSetEncryptionProtocolRsp)
end

function TSetEncryptionProtocolRsp.new()
    return TSetEncryptionProtocolRsp_from_obj({})
end
---@param obj SnmpUser.SetEncryptionProtocolRsp
function TSetEncryptionProtocolRsp:init_from_obj(obj) end

function TSetEncryptionProtocolRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetEncryptionProtocolRsp.group)
end

TSetEncryptionProtocolRsp.from_obj = TSetEncryptionProtocolRsp_from_obj

TSetEncryptionProtocolRsp.proto_property = {}

TSetEncryptionProtocolRsp.default = {}

TSetEncryptionProtocolRsp.struct = {}

function TSetEncryptionProtocolRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetEncryptionProtocolRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetEncryptionProtocolRsp.proto_property,
                                 errs, need_convert)
    return self
end

function TSetEncryptionProtocolRsp:unpack(_) end

SnmpUser.SetEncryptionProtocolRsp = TSetEncryptionProtocolRsp

---@class SnmpUser.SetEncryptionProtocolReq
---@field SNMPEncryptionProtocol integer
local TSetEncryptionProtocolReq = {}
TSetEncryptionProtocolReq.__index = TSetEncryptionProtocolReq
TSetEncryptionProtocolReq.group = {}

local function TSetEncryptionProtocolReq_from_obj(obj)
    return setmetatable(obj, TSetEncryptionProtocolReq)
end

function TSetEncryptionProtocolReq.new(SNMPEncryptionProtocol)
    return TSetEncryptionProtocolReq_from_obj({
        SNMPEncryptionProtocol = SNMPEncryptionProtocol
    })
end
---@param obj SnmpUser.SetEncryptionProtocolReq
function TSetEncryptionProtocolReq:init_from_obj(obj)
    self.SNMPEncryptionProtocol = obj.SNMPEncryptionProtocol
end

function TSetEncryptionProtocolReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetEncryptionProtocolReq.group)
end

TSetEncryptionProtocolReq.from_obj = TSetEncryptionProtocolReq_from_obj

TSetEncryptionProtocolReq.proto_property = {'SNMPEncryptionProtocol'}

TSetEncryptionProtocolReq.default = {0}

TSetEncryptionProtocolReq.struct = {
    {name = 'SNMPEncryptionProtocol', is_array = false, struct = nil}
}

function TSetEncryptionProtocolReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SNMPEncryptionProtocol',
                      self.SNMPEncryptionProtocol, "uint8", false, errs,
                      need_convert)

    TSetEncryptionProtocolReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetEncryptionProtocolReq.proto_property,
                                 errs, need_convert)
    return self
end

function TSetEncryptionProtocolReq:unpack(_) return self.SNMPEncryptionProtocol end

SnmpUser.SetEncryptionProtocolReq = TSetEncryptionProtocolReq

---@class SnmpUser.SetAuthenticationProtocolRsp
local TSetAuthenticationProtocolRsp = {}
TSetAuthenticationProtocolRsp.__index = TSetAuthenticationProtocolRsp
TSetAuthenticationProtocolRsp.group = {}

local function TSetAuthenticationProtocolRsp_from_obj(obj)
    return setmetatable(obj, TSetAuthenticationProtocolRsp)
end

function TSetAuthenticationProtocolRsp.new()
    return TSetAuthenticationProtocolRsp_from_obj({})
end
---@param obj SnmpUser.SetAuthenticationProtocolRsp
function TSetAuthenticationProtocolRsp:init_from_obj(obj) end

function TSetAuthenticationProtocolRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs,
                                    TSetAuthenticationProtocolRsp.group)
end

TSetAuthenticationProtocolRsp.from_obj = TSetAuthenticationProtocolRsp_from_obj

TSetAuthenticationProtocolRsp.proto_property = {}

TSetAuthenticationProtocolRsp.default = {}

TSetAuthenticationProtocolRsp.struct = {}

function TSetAuthenticationProtocolRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetAuthenticationProtocolRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self,
                                 TSetAuthenticationProtocolRsp.proto_property,
                                 errs, need_convert)
    return self
end

function TSetAuthenticationProtocolRsp:unpack(_) end

SnmpUser.SetAuthenticationProtocolRsp = TSetAuthenticationProtocolRsp

---@class SnmpUser.SetAuthenticationProtocolReq
---@field SNMPAuthenticationProtocol integer
---@field AuthPassword string
---@field EncryPassword string
local TSetAuthenticationProtocolReq = {}
TSetAuthenticationProtocolReq.__index = TSetAuthenticationProtocolReq
TSetAuthenticationProtocolReq.group = {}

local function TSetAuthenticationProtocolReq_from_obj(obj)
    return setmetatable(obj, TSetAuthenticationProtocolReq)
end

function TSetAuthenticationProtocolReq.new(SNMPAuthenticationProtocol,
                                           AuthPassword, EncryPassword)
    return TSetAuthenticationProtocolReq_from_obj({
        SNMPAuthenticationProtocol = SNMPAuthenticationProtocol,
        AuthPassword = AuthPassword,
        EncryPassword = EncryPassword
    })
end
---@param obj SnmpUser.SetAuthenticationProtocolReq
function TSetAuthenticationProtocolReq:init_from_obj(obj)
    self.SNMPAuthenticationProtocol = obj.SNMPAuthenticationProtocol
    self.AuthPassword = obj.AuthPassword
    self.EncryPassword = obj.EncryPassword
end

function TSetAuthenticationProtocolReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs,
                                    TSetAuthenticationProtocolReq.group)
end

TSetAuthenticationProtocolReq.from_obj = TSetAuthenticationProtocolReq_from_obj

TSetAuthenticationProtocolReq.proto_property = {
    'SNMPAuthenticationProtocol', 'AuthPassword', 'EncryPassword'
}

TSetAuthenticationProtocolReq.default = {0, '', ''}

TSetAuthenticationProtocolReq.struct = {
    {name = 'SNMPAuthenticationProtocol', is_array = false, struct = nil},
    {name = 'AuthPassword', is_array = false, struct = nil},
    {name = 'EncryPassword', is_array = false, struct = nil}
}

function TSetAuthenticationProtocolReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SNMPAuthenticationProtocol',
                      self.SNMPAuthenticationProtocol, "uint8", false, errs,
                      need_convert)
    validate.Optional(prefix .. 'AuthPassword', self.AuthPassword, "string",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'EncryPassword', self.EncryPassword, "string",
                      false, errs, need_convert)

    if self.AuthPassword ~= nil then
        validate.lens(prefix .. 'AuthPassword', self.AuthPassword, 1, 32, errs,
                      need_convert)
    end
    if self.EncryPassword ~= nil then
        validate.lens(prefix .. 'EncryPassword', self.EncryPassword, 1, 32,
                      errs, need_convert)
    end

    TSetAuthenticationProtocolReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self,
                                 TSetAuthenticationProtocolReq.proto_property,
                                 errs, need_convert)
    return self
end

function TSetAuthenticationProtocolReq:unpack(_)
    return self.SNMPAuthenticationProtocol, self.AuthPassword,
           self.EncryPassword
end

SnmpUser.SetAuthenticationProtocolReq = TSetAuthenticationProtocolReq

SnmpUser.interface = mdb.register_interface(
                         'bmc.kepler.AccountService.ManagerAccount.SnmpUser', {
        AuthenticationProtocol = {'y', nil, true, nil, false},
        EncryptionProtocol = {'y', nil, true, nil, false},
        SnmpEncryptionPasswordInitialStatus = {'b', nil, true, nil, false}
    }, {
        SetAuthenticationProtocol = {
            'a{ss}yss', '', TSetAuthenticationProtocolReq,
            TSetAuthenticationProtocolRsp
        },
        SetEncryptionProtocol = {
            'a{ss}y', '', TSetEncryptionProtocolReq, TSetEncryptionProtocolRsp
        },
        GetSnmpKeys = {'a{ss}', 'ss', TGetSnmpKeysReq, TGetSnmpKeysRsp}
    }, {})

return SnmpUser
