-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-3-15
-- Description: DO NOT EDIT; Code generated by "message.lua.mako"
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Ipv6 = {}

---@class Ipv6.ChangedInfoItem
---@field Field string
---@field OldValue string
---@field NewValue string
local TChangedInfoItem = {}
TChangedInfoItem.__index = TChangedInfoItem
TChangedInfoItem.group = {}

local function TChangedInfoItem_from_obj(obj)
    return setmetatable(obj, TChangedInfoItem)
end

function TChangedInfoItem.new(Field, OldValue, NewValue)
    return TChangedInfoItem_from_obj({
        Field = Field,
        OldValue = OldValue,
        NewValue = NewValue
    })
end
---@param obj Ipv6.ChangedInfoItem
function TChangedInfoItem:init_from_obj(obj)
    self.Field = obj.Field
    self.OldValue = obj.OldValue
    self.NewValue = obj.NewValue
end

function TChangedInfoItem:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChangedInfoItem.group)
end

TChangedInfoItem.from_obj = TChangedInfoItem_from_obj

TChangedInfoItem.proto_property = {'Field', 'OldValue', 'NewValue'}

TChangedInfoItem.default = {'', '', ''}

TChangedInfoItem.struct = {
    {name = 'Field', is_array = false, struct = nil},
    {name = 'OldValue', is_array = false, struct = nil},
    {name = 'NewValue', is_array = false, struct = nil}
}

function TChangedInfoItem:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Field', self.Field, "string", false, errs,
                      need_convert)
    validate.Optional(prefix .. 'OldValue', self.OldValue, "string", false,
                      errs, need_convert)
    validate.Optional(prefix .. 'NewValue', self.NewValue, "string", false,
                      errs, need_convert)

    TChangedInfoItem:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChangedInfoItem.proto_property, errs,
                                 need_convert)
    return self
end

function TChangedInfoItem:unpack(_)
    return self.Field, self.OldValue, self.NewValue
end

Ipv6.ChangedInfoItem = TChangedInfoItem

---@class Ipv6.DefaultGateway
---@field DefaultGateway string
local TDefaultGateway = {}
TDefaultGateway.__index = TDefaultGateway
TDefaultGateway.group = {}

local function TDefaultGateway_from_obj(obj)
    return setmetatable(obj, TDefaultGateway)
end

function TDefaultGateway.new(DefaultGateway)
    return TDefaultGateway_from_obj({DefaultGateway = DefaultGateway})
end
---@param obj Ipv6.DefaultGateway
function TDefaultGateway:init_from_obj(obj)
    self.DefaultGateway = obj.DefaultGateway
end

function TDefaultGateway:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDefaultGateway.group)
end

TDefaultGateway.from_obj = TDefaultGateway_from_obj

TDefaultGateway.proto_property = {'DefaultGateway'}

TDefaultGateway.default = {''}

TDefaultGateway.struct = {
    {name = 'DefaultGateway', is_array = false, struct = nil}
}

function TDefaultGateway:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DefaultGateway', self.DefaultGateway, "string",
                      true, errs, need_convert)

    TDefaultGateway:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDefaultGateway.proto_property, errs,
                                 need_convert)
    return self
end

function TDefaultGateway:unpack(_) return self.DefaultGateway end

Ipv6.DefaultGateway = TDefaultGateway

---@class Ipv6.Scope
---@field Scope string
local TScope = {}
TScope.__index = TScope
TScope.group = {}

local function TScope_from_obj(obj) return setmetatable(obj, TScope) end

function TScope.new(Scope) return TScope_from_obj({Scope = Scope}) end
---@param obj Ipv6.Scope
function TScope:init_from_obj(obj) self.Scope = obj.Scope end

function TScope:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TScope.group)
end

TScope.from_obj = TScope_from_obj

TScope.proto_property = {'Scope'}

TScope.default = {''}

TScope.struct = {{name = 'Scope', is_array = false, struct = nil}}

function TScope:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Scope', self.Scope, "string", true, errs,
                      need_convert)

    TScope:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TScope.proto_property, errs, need_convert)
    return self
end

function TScope:unpack(_) return self.Scope end

Ipv6.Scope = TScope

---@class Ipv6.PrefixLength
---@field PrefixLength integer
local TPrefixLength = {}
TPrefixLength.__index = TPrefixLength
TPrefixLength.group = {}

local function TPrefixLength_from_obj(obj)
    return setmetatable(obj, TPrefixLength)
end

function TPrefixLength.new(PrefixLength)
    return TPrefixLength_from_obj({PrefixLength = PrefixLength})
end
---@param obj Ipv6.PrefixLength
function TPrefixLength:init_from_obj(obj) self.PrefixLength = obj.PrefixLength end

function TPrefixLength:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPrefixLength.group)
end

TPrefixLength.from_obj = TPrefixLength_from_obj

TPrefixLength.proto_property = {'PrefixLength'}

TPrefixLength.default = {0}

TPrefixLength.struct = {{name = 'PrefixLength', is_array = false, struct = nil}}

function TPrefixLength:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PrefixLength', self.PrefixLength, "int32",
                      true, errs, need_convert)

    TPrefixLength:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPrefixLength.proto_property, errs,
                                 need_convert)
    return self
end

function TPrefixLength:unpack(_) return self.PrefixLength end

Ipv6.PrefixLength = TPrefixLength

---@class Ipv6.IpAddr
---@field IpAddr string
local TIpAddr = {}
TIpAddr.__index = TIpAddr
TIpAddr.group = {}

local function TIpAddr_from_obj(obj) return setmetatable(obj, TIpAddr) end

function TIpAddr.new(IpAddr) return TIpAddr_from_obj({IpAddr = IpAddr}) end
---@param obj Ipv6.IpAddr
function TIpAddr:init_from_obj(obj) self.IpAddr = obj.IpAddr end

function TIpAddr:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIpAddr.group)
end

TIpAddr.from_obj = TIpAddr_from_obj

TIpAddr.proto_property = {'IpAddr'}

TIpAddr.default = {''}

TIpAddr.struct = {{name = 'IpAddr', is_array = false, struct = nil}}

function TIpAddr:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IpAddr', self.IpAddr, "string", true, errs,
                      need_convert)

    TIpAddr:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIpAddr.proto_property, errs,
                                 need_convert)
    return self
end

function TIpAddr:unpack(_) return self.IpAddr end

Ipv6.IpAddr = TIpAddr

---@class Ipv6.IpMode
---@field IpMode string
local TIpMode = {}
TIpMode.__index = TIpMode
TIpMode.group = {}

local function TIpMode_from_obj(obj) return setmetatable(obj, TIpMode) end

function TIpMode.new(IpMode) return TIpMode_from_obj({IpMode = IpMode}) end
---@param obj Ipv6.IpMode
function TIpMode:init_from_obj(obj) self.IpMode = obj.IpMode end

function TIpMode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIpMode.group)
end

TIpMode.from_obj = TIpMode_from_obj

TIpMode.proto_property = {'IpMode'}

TIpMode.default = {''}

TIpMode.struct = {{name = 'IpMode', is_array = false, struct = nil}}

function TIpMode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IpMode', self.IpMode, "string", false, errs,
                      need_convert)

    if self.IpMode ~= nil then
        validate.Enum(prefix .. 'IpMode', self.IpMode, '', {"DHCPv6", "Static"},
                      errs, need_convert)
    end

    TIpMode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIpMode.proto_property, errs,
                                 need_convert)
    return self
end

function TIpMode:unpack(_) return self.IpMode end

Ipv6.IpMode = TIpMode

---@class Ipv6.ChangedSignalSignature
---@field ChangedInfo Ipv6.ChangedInfoItem[]
local TChangedSignalSignature = {}
TChangedSignalSignature.__index = TChangedSignalSignature
TChangedSignalSignature.group = {}

local function TChangedSignalSignature_from_obj(obj)
    obj.ChangedInfo =
        utils.from_obj(Ipv6.ChangedInfoItem, obj.ChangedInfo, true)
    return setmetatable(obj, TChangedSignalSignature)
end

function TChangedSignalSignature.new(ChangedInfo)
    return TChangedSignalSignature_from_obj({ChangedInfo = ChangedInfo})
end
---@param obj Ipv6.ChangedSignalSignature
function TChangedSignalSignature:init_from_obj(obj)
    self.ChangedInfo = obj.ChangedInfo
end

function TChangedSignalSignature:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChangedSignalSignature.group)
end

TChangedSignalSignature.from_obj = TChangedSignalSignature_from_obj

TChangedSignalSignature.proto_property = {'ChangedInfo'}

TChangedSignalSignature.default = {{}}

TChangedSignalSignature.struct = {
    {
        name = 'ChangedInfo',
        is_array = true,
        struct = Ipv6.ChangedInfoItem.struct
    }
}

function TChangedSignalSignature:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.ChangedInfo) do
        Ipv6.ChangedInfoItem.new(v.Field, v.OldValue, v.NewValue):validate(
            prefix, errs, need_convert)
    end

    TChangedSignalSignature:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChangedSignalSignature.proto_property,
                                 errs, need_convert)
    return self
end

function TChangedSignalSignature:unpack(raw)
    return utils.unpack(raw, self.ChangedInfo, true)
end

Ipv6.ChangedSignalSignature = TChangedSignalSignature

---@class Ipv6.SetDefaultGatewayRsp
---@field Result boolean
local TSetDefaultGatewayRsp = {}
TSetDefaultGatewayRsp.__index = TSetDefaultGatewayRsp
TSetDefaultGatewayRsp.group = {}

local function TSetDefaultGatewayRsp_from_obj(obj)
    return setmetatable(obj, TSetDefaultGatewayRsp)
end

function TSetDefaultGatewayRsp.new(Result)
    return TSetDefaultGatewayRsp_from_obj({Result = Result})
end
---@param obj Ipv6.SetDefaultGatewayRsp
function TSetDefaultGatewayRsp:init_from_obj(obj) self.Result = obj.Result end

function TSetDefaultGatewayRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDefaultGatewayRsp.group)
end

TSetDefaultGatewayRsp.from_obj = TSetDefaultGatewayRsp_from_obj

TSetDefaultGatewayRsp.proto_property = {'Result'}

TSetDefaultGatewayRsp.default = {false}

TSetDefaultGatewayRsp.struct = {
    {name = 'Result', is_array = false, struct = nil}
}

function TSetDefaultGatewayRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, "bool", false, errs,
                      need_convert)

    TSetDefaultGatewayRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDefaultGatewayRsp.proto_property,
                                 errs, need_convert)
    return self
end

function TSetDefaultGatewayRsp:unpack(_) return self.Result end

Ipv6.SetDefaultGatewayRsp = TSetDefaultGatewayRsp

---@class Ipv6.SetDefaultGatewayReq
---@field DefaultGateway string
local TSetDefaultGatewayReq = {}
TSetDefaultGatewayReq.__index = TSetDefaultGatewayReq
TSetDefaultGatewayReq.group = {}

local function TSetDefaultGatewayReq_from_obj(obj)
    return setmetatable(obj, TSetDefaultGatewayReq)
end

function TSetDefaultGatewayReq.new(DefaultGateway)
    return TSetDefaultGatewayReq_from_obj({DefaultGateway = DefaultGateway})
end
---@param obj Ipv6.SetDefaultGatewayReq
function TSetDefaultGatewayReq:init_from_obj(obj)
    self.DefaultGateway = obj.DefaultGateway
end

function TSetDefaultGatewayReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDefaultGatewayReq.group)
end

TSetDefaultGatewayReq.from_obj = TSetDefaultGatewayReq_from_obj

TSetDefaultGatewayReq.proto_property = {'DefaultGateway'}

TSetDefaultGatewayReq.default = {''}

TSetDefaultGatewayReq.struct = {
    {name = 'DefaultGateway', is_array = false, struct = nil}
}

function TSetDefaultGatewayReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DefaultGateway', self.DefaultGateway, "string",
                      false, errs, need_convert)

    TSetDefaultGatewayReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDefaultGatewayReq.proto_property,
                                 errs, need_convert)
    return self
end

function TSetDefaultGatewayReq:unpack(_) return self.DefaultGateway end

Ipv6.SetDefaultGatewayReq = TSetDefaultGatewayReq

---@class Ipv6.SetIpAddrRsp
---@field Result boolean
local TSetIpAddrRsp = {}
TSetIpAddrRsp.__index = TSetIpAddrRsp
TSetIpAddrRsp.group = {}

local function TSetIpAddrRsp_from_obj(obj)
    return setmetatable(obj, TSetIpAddrRsp)
end

function TSetIpAddrRsp.new(Result)
    return TSetIpAddrRsp_from_obj({Result = Result})
end
---@param obj Ipv6.SetIpAddrRsp
function TSetIpAddrRsp:init_from_obj(obj) self.Result = obj.Result end

function TSetIpAddrRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetIpAddrRsp.group)
end

TSetIpAddrRsp.from_obj = TSetIpAddrRsp_from_obj

TSetIpAddrRsp.proto_property = {'Result'}

TSetIpAddrRsp.default = {false}

TSetIpAddrRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TSetIpAddrRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, "bool", false, errs,
                      need_convert)

    TSetIpAddrRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetIpAddrRsp.proto_property, errs,
                                 need_convert)
    return self
end

function TSetIpAddrRsp:unpack(_) return self.Result end

Ipv6.SetIpAddrRsp = TSetIpAddrRsp

---@class Ipv6.SetIpAddrReq
---@field IpAddr string
---@field PrefixLength integer
local TSetIpAddrReq = {}
TSetIpAddrReq.__index = TSetIpAddrReq
TSetIpAddrReq.group = {}

local function TSetIpAddrReq_from_obj(obj)
    return setmetatable(obj, TSetIpAddrReq)
end

function TSetIpAddrReq.new(IpAddr, PrefixLength)
    return
        TSetIpAddrReq_from_obj({IpAddr = IpAddr, PrefixLength = PrefixLength})
end
---@param obj Ipv6.SetIpAddrReq
function TSetIpAddrReq:init_from_obj(obj)
    self.IpAddr = obj.IpAddr
    self.PrefixLength = obj.PrefixLength
end

function TSetIpAddrReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetIpAddrReq.group)
end

TSetIpAddrReq.from_obj = TSetIpAddrReq_from_obj

TSetIpAddrReq.proto_property = {'IpAddr', 'PrefixLength'}

TSetIpAddrReq.default = {'', 0}

TSetIpAddrReq.struct = {
    {name = 'IpAddr', is_array = false, struct = nil},
    {name = 'PrefixLength', is_array = false, struct = nil}
}

function TSetIpAddrReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IpAddr', self.IpAddr, "string", false, errs,
                      need_convert)
    validate.Optional(prefix .. 'PrefixLength', self.PrefixLength, "int32",
                      false, errs, need_convert)

    TSetIpAddrReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetIpAddrReq.proto_property, errs,
                                 need_convert)
    return self
end

function TSetIpAddrReq:unpack(_) return self.IpAddr, self.PrefixLength end

Ipv6.SetIpAddrReq = TSetIpAddrReq

---@class Ipv6.SetIpv6PrefixGatewayRsp
---@field IpAddr string
local TSetIpv6PrefixGatewayRsp = {}
TSetIpv6PrefixGatewayRsp.__index = TSetIpv6PrefixGatewayRsp
TSetIpv6PrefixGatewayRsp.group = {}

local function TSetIpv6PrefixGatewayRsp_from_obj(obj)
    return setmetatable(obj, TSetIpv6PrefixGatewayRsp)
end

function TSetIpv6PrefixGatewayRsp.new(IpAddr)
    return TSetIpv6PrefixGatewayRsp_from_obj({IpAddr = IpAddr})
end
---@param obj Ipv6.SetIpv6PrefixGatewayRsp
function TSetIpv6PrefixGatewayRsp:init_from_obj(obj) self.IpAddr = obj.IpAddr end

function TSetIpv6PrefixGatewayRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetIpv6PrefixGatewayRsp.group)
end

TSetIpv6PrefixGatewayRsp.from_obj = TSetIpv6PrefixGatewayRsp_from_obj

TSetIpv6PrefixGatewayRsp.proto_property = {'IpAddr'}

TSetIpv6PrefixGatewayRsp.default = {''}

TSetIpv6PrefixGatewayRsp.struct = {
    {name = 'IpAddr', is_array = false, struct = nil}
}

function TSetIpv6PrefixGatewayRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IpAddr', self.IpAddr, "string", false, errs,
                      need_convert)

    TSetIpv6PrefixGatewayRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetIpv6PrefixGatewayRsp.proto_property,
                                 errs, need_convert)
    return self
end

function TSetIpv6PrefixGatewayRsp:unpack(_) return self.IpAddr end

Ipv6.SetIpv6PrefixGatewayRsp = TSetIpv6PrefixGatewayRsp

---@class Ipv6.SetIpv6PrefixGatewayReq
---@field IpAddr string
---@field PrefixLength integer
---@field DefaultGateway string
local TSetIpv6PrefixGatewayReq = {}
TSetIpv6PrefixGatewayReq.__index = TSetIpv6PrefixGatewayReq
TSetIpv6PrefixGatewayReq.group = {}

local function TSetIpv6PrefixGatewayReq_from_obj(obj)
    return setmetatable(obj, TSetIpv6PrefixGatewayReq)
end

function TSetIpv6PrefixGatewayReq.new(IpAddr, PrefixLength, DefaultGateway)
    return TSetIpv6PrefixGatewayReq_from_obj({
        IpAddr = IpAddr,
        PrefixLength = PrefixLength,
        DefaultGateway = DefaultGateway
    })
end
---@param obj Ipv6.SetIpv6PrefixGatewayReq
function TSetIpv6PrefixGatewayReq:init_from_obj(obj)
    self.IpAddr = obj.IpAddr
    self.PrefixLength = obj.PrefixLength
    self.DefaultGateway = obj.DefaultGateway
end

function TSetIpv6PrefixGatewayReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetIpv6PrefixGatewayReq.group)
end

TSetIpv6PrefixGatewayReq.from_obj = TSetIpv6PrefixGatewayReq_from_obj

TSetIpv6PrefixGatewayReq.proto_property = {
    'IpAddr', 'PrefixLength', 'DefaultGateway'
}

TSetIpv6PrefixGatewayReq.default = {'', 0, ''}

TSetIpv6PrefixGatewayReq.struct = {
    {name = 'IpAddr', is_array = false, struct = nil},
    {name = 'PrefixLength', is_array = false, struct = nil},
    {name = 'DefaultGateway', is_array = false, struct = nil}
}

function TSetIpv6PrefixGatewayReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IpAddr', self.IpAddr, "string", false, errs,
                      need_convert)
    validate.Optional(prefix .. 'PrefixLength', self.PrefixLength, "int32",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'DefaultGateway', self.DefaultGateway, "string",
                      false, errs, need_convert)

    TSetIpv6PrefixGatewayReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetIpv6PrefixGatewayReq.proto_property,
                                 errs, need_convert)
    return self
end

function TSetIpv6PrefixGatewayReq:unpack(_)
    return self.IpAddr, self.PrefixLength, self.DefaultGateway
end

Ipv6.SetIpv6PrefixGatewayReq = TSetIpv6PrefixGatewayReq

Ipv6.interface = mdb.register_interface(
                     'bmc.kepler.Managers.EthernetInterfaces.Ipv6', {
        IpMode = {'s', nil, false, nil, false},
        IpAddr = {'s', nil, true, nil, false},
        PrefixLength = {'i', nil, true, nil, false},
        Scope = {'s', {}, true, nil, false},
        DefaultGateway = {'s', nil, true, nil, false}
    }, {
        SetIpv6PrefixGateway = {
            'a{ss}sis', 's', TSetIpv6PrefixGatewayReq, TSetIpv6PrefixGatewayRsp
        },
        SetIpAddr = {'a{ss}si', 'b', TSetIpAddrReq, TSetIpAddrRsp},
        SetDefaultGateway = {
            'a{ss}s', 'b', TSetDefaultGatewayReq, TSetDefaultGatewayRsp
        }
    }, {ChangedSignal = 'a{ss}a(sss)'})

return Ipv6
