-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-3-15
-- Description: DO NOT EDIT; Code generated by "message.lua.mako"
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Ipv4 = {}

---@class Ipv4.ChangedInfoItem
---@field Field string
---@field OldValue string
---@field NewValue string
local TChangedInfoItem = {}
TChangedInfoItem.__index = TChangedInfoItem
TChangedInfoItem.group = {}

local function TChangedInfoItem_from_obj(obj)
    return setmetatable(obj, TChangedInfoItem)
end

function TChangedInfoItem.new(Field, OldValue, NewValue)
    return TChangedInfoItem_from_obj({
        Field = Field,
        OldValue = OldValue,
        NewValue = NewValue
    })
end
---@param obj Ipv4.ChangedInfoItem
function TChangedInfoItem:init_from_obj(obj)
    self.Field = obj.Field
    self.OldValue = obj.OldValue
    self.NewValue = obj.NewValue
end

function TChangedInfoItem:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChangedInfoItem.group)
end

TChangedInfoItem.from_obj = TChangedInfoItem_from_obj

TChangedInfoItem.proto_property = {'Field', 'OldValue', 'NewValue'}

TChangedInfoItem.default = {'', '', ''}

TChangedInfoItem.struct = {
    {name = 'Field', is_array = false, struct = nil},
    {name = 'OldValue', is_array = false, struct = nil},
    {name = 'NewValue', is_array = false, struct = nil}
}

function TChangedInfoItem:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Field', self.Field, "string", false, errs,
                      need_convert)
    validate.Optional(prefix .. 'OldValue', self.OldValue, "string", false,
                      errs, need_convert)
    validate.Optional(prefix .. 'NewValue', self.NewValue, "string", false,
                      errs, need_convert)

    TChangedInfoItem:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChangedInfoItem.proto_property, errs,
                                 need_convert)
    return self
end

function TChangedInfoItem:unpack(_)
    return self.Field, self.OldValue, self.NewValue
end

Ipv4.ChangedInfoItem = TChangedInfoItem

---@class Ipv4.DefaultGateway
---@field DefaultGateway string
local TDefaultGateway = {}
TDefaultGateway.__index = TDefaultGateway
TDefaultGateway.group = {}

local function TDefaultGateway_from_obj(obj)
    return setmetatable(obj, TDefaultGateway)
end

function TDefaultGateway.new(DefaultGateway)
    return TDefaultGateway_from_obj({DefaultGateway = DefaultGateway})
end
---@param obj Ipv4.DefaultGateway
function TDefaultGateway:init_from_obj(obj)
    self.DefaultGateway = obj.DefaultGateway
end

function TDefaultGateway:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDefaultGateway.group)
end

TDefaultGateway.from_obj = TDefaultGateway_from_obj

TDefaultGateway.proto_property = {'DefaultGateway'}

TDefaultGateway.default = {''}

TDefaultGateway.struct = {
    {name = 'DefaultGateway', is_array = false, struct = nil}
}

function TDefaultGateway:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DefaultGateway', self.DefaultGateway, "string",
                      true, errs, need_convert)

    TDefaultGateway:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDefaultGateway.proto_property, errs,
                                 need_convert)
    return self
end

function TDefaultGateway:unpack(_) return self.DefaultGateway end

Ipv4.DefaultGateway = TDefaultGateway

---@class Ipv4.BackupSubnetMask
---@field BackupSubnetMask string
local TBackupSubnetMask = {}
TBackupSubnetMask.__index = TBackupSubnetMask
TBackupSubnetMask.group = {}

local function TBackupSubnetMask_from_obj(obj)
    return setmetatable(obj, TBackupSubnetMask)
end

function TBackupSubnetMask.new(BackupSubnetMask)
    return TBackupSubnetMask_from_obj({BackupSubnetMask = BackupSubnetMask})
end
---@param obj Ipv4.BackupSubnetMask
function TBackupSubnetMask:init_from_obj(obj)
    self.BackupSubnetMask = obj.BackupSubnetMask
end

function TBackupSubnetMask:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBackupSubnetMask.group)
end

TBackupSubnetMask.from_obj = TBackupSubnetMask_from_obj

TBackupSubnetMask.proto_property = {'BackupSubnetMask'}

TBackupSubnetMask.default = {''}

TBackupSubnetMask.struct = {
    {name = 'BackupSubnetMask', is_array = false, struct = nil}
}

function TBackupSubnetMask:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BackupSubnetMask', self.BackupSubnetMask,
                      "string", false, errs, need_convert)

    TBackupSubnetMask:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBackupSubnetMask.proto_property, errs,
                                 need_convert)
    return self
end

function TBackupSubnetMask:unpack(_) return self.BackupSubnetMask end

Ipv4.BackupSubnetMask = TBackupSubnetMask

---@class Ipv4.SubnetMask
---@field SubnetMask string
local TSubnetMask = {}
TSubnetMask.__index = TSubnetMask
TSubnetMask.group = {}

local function TSubnetMask_from_obj(obj) return setmetatable(obj, TSubnetMask) end

function TSubnetMask.new(SubnetMask)
    return TSubnetMask_from_obj({SubnetMask = SubnetMask})
end
---@param obj Ipv4.SubnetMask
function TSubnetMask:init_from_obj(obj) self.SubnetMask = obj.SubnetMask end

function TSubnetMask:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSubnetMask.group)
end

TSubnetMask.from_obj = TSubnetMask_from_obj

TSubnetMask.proto_property = {'SubnetMask'}

TSubnetMask.default = {''}

TSubnetMask.struct = {{name = 'SubnetMask', is_array = false, struct = nil}}

function TSubnetMask:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SubnetMask', self.SubnetMask, "string", true,
                      errs, need_convert)

    TSubnetMask:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSubnetMask.proto_property, errs,
                                 need_convert)
    return self
end

function TSubnetMask:unpack(_) return self.SubnetMask end

Ipv4.SubnetMask = TSubnetMask

---@class Ipv4.BackupIpAddr
---@field BackupIpAddr string
local TBackupIpAddr = {}
TBackupIpAddr.__index = TBackupIpAddr
TBackupIpAddr.group = {}

local function TBackupIpAddr_from_obj(obj)
    return setmetatable(obj, TBackupIpAddr)
end

function TBackupIpAddr.new(BackupIpAddr)
    return TBackupIpAddr_from_obj({BackupIpAddr = BackupIpAddr})
end
---@param obj Ipv4.BackupIpAddr
function TBackupIpAddr:init_from_obj(obj) self.BackupIpAddr = obj.BackupIpAddr end

function TBackupIpAddr:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBackupIpAddr.group)
end

TBackupIpAddr.from_obj = TBackupIpAddr_from_obj

TBackupIpAddr.proto_property = {'BackupIpAddr'}

TBackupIpAddr.default = {''}

TBackupIpAddr.struct = {{name = 'BackupIpAddr', is_array = false, struct = nil}}

function TBackupIpAddr:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BackupIpAddr', self.BackupIpAddr, "string",
                      false, errs, need_convert)

    TBackupIpAddr:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBackupIpAddr.proto_property, errs,
                                 need_convert)
    return self
end

function TBackupIpAddr:unpack(_) return self.BackupIpAddr end

Ipv4.BackupIpAddr = TBackupIpAddr

---@class Ipv4.IpAddr
---@field IpAddr string
local TIpAddr = {}
TIpAddr.__index = TIpAddr
TIpAddr.group = {}

local function TIpAddr_from_obj(obj) return setmetatable(obj, TIpAddr) end

function TIpAddr.new(IpAddr) return TIpAddr_from_obj({IpAddr = IpAddr}) end
---@param obj Ipv4.IpAddr
function TIpAddr:init_from_obj(obj) self.IpAddr = obj.IpAddr end

function TIpAddr:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIpAddr.group)
end

TIpAddr.from_obj = TIpAddr_from_obj

TIpAddr.proto_property = {'IpAddr'}

TIpAddr.default = {''}

TIpAddr.struct = {{name = 'IpAddr', is_array = false, struct = nil}}

function TIpAddr:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IpAddr', self.IpAddr, "string", true, errs,
                      need_convert)

    TIpAddr:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIpAddr.proto_property, errs,
                                 need_convert)
    return self
end

function TIpAddr:unpack(_) return self.IpAddr end

Ipv4.IpAddr = TIpAddr

---@class Ipv4.IpMode
---@field IpMode string
local TIpMode = {}
TIpMode.__index = TIpMode
TIpMode.group = {}

local function TIpMode_from_obj(obj) return setmetatable(obj, TIpMode) end

function TIpMode.new(IpMode) return TIpMode_from_obj({IpMode = IpMode}) end
---@param obj Ipv4.IpMode
function TIpMode:init_from_obj(obj) self.IpMode = obj.IpMode end

function TIpMode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIpMode.group)
end

TIpMode.from_obj = TIpMode_from_obj

TIpMode.proto_property = {'IpMode'}

TIpMode.default = {''}

TIpMode.struct = {{name = 'IpMode', is_array = false, struct = nil}}

function TIpMode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IpMode', self.IpMode, "string", false, errs,
                      need_convert)

    if self.IpMode ~= nil then
        validate.Enum(prefix .. 'IpMode', self.IpMode, '', {"DHCP", "Static"},
                      errs, need_convert)
    end

    TIpMode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIpMode.proto_property, errs,
                                 need_convert)
    return self
end

function TIpMode:unpack(_) return self.IpMode end

Ipv4.IpMode = TIpMode

---@class Ipv4.ChangedSignalSignature
---@field ChangedInfo Ipv4.ChangedInfoItem[]
local TChangedSignalSignature = {}
TChangedSignalSignature.__index = TChangedSignalSignature
TChangedSignalSignature.group = {}

local function TChangedSignalSignature_from_obj(obj)
    obj.ChangedInfo =
        utils.from_obj(Ipv4.ChangedInfoItem, obj.ChangedInfo, true)
    return setmetatable(obj, TChangedSignalSignature)
end

function TChangedSignalSignature.new(ChangedInfo)
    return TChangedSignalSignature_from_obj({ChangedInfo = ChangedInfo})
end
---@param obj Ipv4.ChangedSignalSignature
function TChangedSignalSignature:init_from_obj(obj)
    self.ChangedInfo = obj.ChangedInfo
end

function TChangedSignalSignature:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChangedSignalSignature.group)
end

TChangedSignalSignature.from_obj = TChangedSignalSignature_from_obj

TChangedSignalSignature.proto_property = {'ChangedInfo'}

TChangedSignalSignature.default = {{}}

TChangedSignalSignature.struct = {
    {
        name = 'ChangedInfo',
        is_array = true,
        struct = Ipv4.ChangedInfoItem.struct
    }
}

function TChangedSignalSignature:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.ChangedInfo) do
        Ipv4.ChangedInfoItem.new(v.Field, v.OldValue, v.NewValue):validate(
            prefix, errs, need_convert)
    end

    TChangedSignalSignature:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChangedSignalSignature.proto_property,
                                 errs, need_convert)
    return self
end

function TChangedSignalSignature:unpack(raw)
    return utils.unpack(raw, self.ChangedInfo, true)
end

Ipv4.ChangedSignalSignature = TChangedSignalSignature

---@class Ipv4.SetDedicatedMaintIpMaskRsp
---@field Result boolean
local TSetDedicatedMaintIpMaskRsp = {}
TSetDedicatedMaintIpMaskRsp.__index = TSetDedicatedMaintIpMaskRsp
TSetDedicatedMaintIpMaskRsp.group = {}

local function TSetDedicatedMaintIpMaskRsp_from_obj(obj)
    return setmetatable(obj, TSetDedicatedMaintIpMaskRsp)
end

function TSetDedicatedMaintIpMaskRsp.new(Result)
    return TSetDedicatedMaintIpMaskRsp_from_obj({Result = Result})
end
---@param obj Ipv4.SetDedicatedMaintIpMaskRsp
function TSetDedicatedMaintIpMaskRsp:init_from_obj(obj) self.Result = obj.Result end

function TSetDedicatedMaintIpMaskRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDedicatedMaintIpMaskRsp.group)
end

TSetDedicatedMaintIpMaskRsp.from_obj = TSetDedicatedMaintIpMaskRsp_from_obj

TSetDedicatedMaintIpMaskRsp.proto_property = {'Result'}

TSetDedicatedMaintIpMaskRsp.default = {false}

TSetDedicatedMaintIpMaskRsp.struct = {
    {name = 'Result', is_array = false, struct = nil}
}

function TSetDedicatedMaintIpMaskRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, "bool", false, errs,
                      need_convert)

    TSetDedicatedMaintIpMaskRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self,
                                 TSetDedicatedMaintIpMaskRsp.proto_property,
                                 errs, need_convert)
    return self
end

function TSetDedicatedMaintIpMaskRsp:unpack(_) return self.Result end

Ipv4.SetDedicatedMaintIpMaskRsp = TSetDedicatedMaintIpMaskRsp

---@class Ipv4.SetDedicatedMaintIpMaskReq
---@field IpAddr string
---@field SubnetMask string
local TSetDedicatedMaintIpMaskReq = {}
TSetDedicatedMaintIpMaskReq.__index = TSetDedicatedMaintIpMaskReq
TSetDedicatedMaintIpMaskReq.group = {}

local function TSetDedicatedMaintIpMaskReq_from_obj(obj)
    return setmetatable(obj, TSetDedicatedMaintIpMaskReq)
end

function TSetDedicatedMaintIpMaskReq.new(IpAddr, SubnetMask)
    return TSetDedicatedMaintIpMaskReq_from_obj({
        IpAddr = IpAddr,
        SubnetMask = SubnetMask
    })
end
---@param obj Ipv4.SetDedicatedMaintIpMaskReq
function TSetDedicatedMaintIpMaskReq:init_from_obj(obj)
    self.IpAddr = obj.IpAddr
    self.SubnetMask = obj.SubnetMask
end

function TSetDedicatedMaintIpMaskReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDedicatedMaintIpMaskReq.group)
end

TSetDedicatedMaintIpMaskReq.from_obj = TSetDedicatedMaintIpMaskReq_from_obj

TSetDedicatedMaintIpMaskReq.proto_property = {'IpAddr', 'SubnetMask'}

TSetDedicatedMaintIpMaskReq.default = {'', ''}

TSetDedicatedMaintIpMaskReq.struct = {
    {name = 'IpAddr', is_array = false, struct = nil},
    {name = 'SubnetMask', is_array = false, struct = nil}
}

function TSetDedicatedMaintIpMaskReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IpAddr', self.IpAddr, "string", false, errs,
                      need_convert)
    validate.Optional(prefix .. 'SubnetMask', self.SubnetMask, "string", false,
                      errs, need_convert)

    TSetDedicatedMaintIpMaskReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self,
                                 TSetDedicatedMaintIpMaskReq.proto_property,
                                 errs, need_convert)
    return self
end

function TSetDedicatedMaintIpMaskReq:unpack(_)
    return self.IpAddr, self.SubnetMask
end

Ipv4.SetDedicatedMaintIpMaskReq = TSetDedicatedMaintIpMaskReq

---@class Ipv4.SetDefaultGatewayRsp
---@field Result boolean
local TSetDefaultGatewayRsp = {}
TSetDefaultGatewayRsp.__index = TSetDefaultGatewayRsp
TSetDefaultGatewayRsp.group = {}

local function TSetDefaultGatewayRsp_from_obj(obj)
    return setmetatable(obj, TSetDefaultGatewayRsp)
end

function TSetDefaultGatewayRsp.new(Result)
    return TSetDefaultGatewayRsp_from_obj({Result = Result})
end
---@param obj Ipv4.SetDefaultGatewayRsp
function TSetDefaultGatewayRsp:init_from_obj(obj) self.Result = obj.Result end

function TSetDefaultGatewayRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDefaultGatewayRsp.group)
end

TSetDefaultGatewayRsp.from_obj = TSetDefaultGatewayRsp_from_obj

TSetDefaultGatewayRsp.proto_property = {'Result'}

TSetDefaultGatewayRsp.default = {false}

TSetDefaultGatewayRsp.struct = {
    {name = 'Result', is_array = false, struct = nil}
}

function TSetDefaultGatewayRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, "bool", false, errs,
                      need_convert)

    TSetDefaultGatewayRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDefaultGatewayRsp.proto_property,
                                 errs, need_convert)
    return self
end

function TSetDefaultGatewayRsp:unpack(_) return self.Result end

Ipv4.SetDefaultGatewayRsp = TSetDefaultGatewayRsp

---@class Ipv4.SetDefaultGatewayReq
---@field DefaultGateway string
local TSetDefaultGatewayReq = {}
TSetDefaultGatewayReq.__index = TSetDefaultGatewayReq
TSetDefaultGatewayReq.group = {}

local function TSetDefaultGatewayReq_from_obj(obj)
    return setmetatable(obj, TSetDefaultGatewayReq)
end

function TSetDefaultGatewayReq.new(DefaultGateway)
    return TSetDefaultGatewayReq_from_obj({DefaultGateway = DefaultGateway})
end
---@param obj Ipv4.SetDefaultGatewayReq
function TSetDefaultGatewayReq:init_from_obj(obj)
    self.DefaultGateway = obj.DefaultGateway
end

function TSetDefaultGatewayReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDefaultGatewayReq.group)
end

TSetDefaultGatewayReq.from_obj = TSetDefaultGatewayReq_from_obj

TSetDefaultGatewayReq.proto_property = {'DefaultGateway'}

TSetDefaultGatewayReq.default = {''}

TSetDefaultGatewayReq.struct = {
    {name = 'DefaultGateway', is_array = false, struct = nil}
}

function TSetDefaultGatewayReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DefaultGateway', self.DefaultGateway, "string",
                      false, errs, need_convert)

    TSetDefaultGatewayReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDefaultGatewayReq.proto_property,
                                 errs, need_convert)
    return self
end

function TSetDefaultGatewayReq:unpack(_) return self.DefaultGateway end

Ipv4.SetDefaultGatewayReq = TSetDefaultGatewayReq

---@class Ipv4.SetIpAddrRsp
---@field Result boolean
local TSetIpAddrRsp = {}
TSetIpAddrRsp.__index = TSetIpAddrRsp
TSetIpAddrRsp.group = {}

local function TSetIpAddrRsp_from_obj(obj)
    return setmetatable(obj, TSetIpAddrRsp)
end

function TSetIpAddrRsp.new(Result)
    return TSetIpAddrRsp_from_obj({Result = Result})
end
---@param obj Ipv4.SetIpAddrRsp
function TSetIpAddrRsp:init_from_obj(obj) self.Result = obj.Result end

function TSetIpAddrRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetIpAddrRsp.group)
end

TSetIpAddrRsp.from_obj = TSetIpAddrRsp_from_obj

TSetIpAddrRsp.proto_property = {'Result'}

TSetIpAddrRsp.default = {false}

TSetIpAddrRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TSetIpAddrRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, "bool", false, errs,
                      need_convert)

    TSetIpAddrRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetIpAddrRsp.proto_property, errs,
                                 need_convert)
    return self
end

function TSetIpAddrRsp:unpack(_) return self.Result end

Ipv4.SetIpAddrRsp = TSetIpAddrRsp

---@class Ipv4.SetIpAddrReq
---@field IpAddr string
---@field SubnetMask string
local TSetIpAddrReq = {}
TSetIpAddrReq.__index = TSetIpAddrReq
TSetIpAddrReq.group = {}

local function TSetIpAddrReq_from_obj(obj)
    return setmetatable(obj, TSetIpAddrReq)
end

function TSetIpAddrReq.new(IpAddr, SubnetMask)
    return TSetIpAddrReq_from_obj({IpAddr = IpAddr, SubnetMask = SubnetMask})
end
---@param obj Ipv4.SetIpAddrReq
function TSetIpAddrReq:init_from_obj(obj)
    self.IpAddr = obj.IpAddr
    self.SubnetMask = obj.SubnetMask
end

function TSetIpAddrReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetIpAddrReq.group)
end

TSetIpAddrReq.from_obj = TSetIpAddrReq_from_obj

TSetIpAddrReq.proto_property = {'IpAddr', 'SubnetMask'}

TSetIpAddrReq.default = {'', ''}

TSetIpAddrReq.struct = {
    {name = 'IpAddr', is_array = false, struct = nil},
    {name = 'SubnetMask', is_array = false, struct = nil}
}

function TSetIpAddrReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IpAddr', self.IpAddr, "string", false, errs,
                      need_convert)
    validate.Optional(prefix .. 'SubnetMask', self.SubnetMask, "string", false,
                      errs, need_convert)

    TSetIpAddrReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetIpAddrReq.proto_property, errs,
                                 need_convert)
    return self
end

function TSetIpAddrReq:unpack(_) return self.IpAddr, self.SubnetMask end

Ipv4.SetIpAddrReq = TSetIpAddrReq

---@class Ipv4.SetIpMaskGatewayRsp
---@field IpAddr string
local TSetIpMaskGatewayRsp = {}
TSetIpMaskGatewayRsp.__index = TSetIpMaskGatewayRsp
TSetIpMaskGatewayRsp.group = {}

local function TSetIpMaskGatewayRsp_from_obj(obj)
    return setmetatable(obj, TSetIpMaskGatewayRsp)
end

function TSetIpMaskGatewayRsp.new(IpAddr)
    return TSetIpMaskGatewayRsp_from_obj({IpAddr = IpAddr})
end
---@param obj Ipv4.SetIpMaskGatewayRsp
function TSetIpMaskGatewayRsp:init_from_obj(obj) self.IpAddr = obj.IpAddr end

function TSetIpMaskGatewayRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetIpMaskGatewayRsp.group)
end

TSetIpMaskGatewayRsp.from_obj = TSetIpMaskGatewayRsp_from_obj

TSetIpMaskGatewayRsp.proto_property = {'IpAddr'}

TSetIpMaskGatewayRsp.default = {''}

TSetIpMaskGatewayRsp.struct = {
    {name = 'IpAddr', is_array = false, struct = nil}
}

function TSetIpMaskGatewayRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IpAddr', self.IpAddr, "string", false, errs,
                      need_convert)

    TSetIpMaskGatewayRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetIpMaskGatewayRsp.proto_property,
                                 errs, need_convert)
    return self
end

function TSetIpMaskGatewayRsp:unpack(_) return self.IpAddr end

Ipv4.SetIpMaskGatewayRsp = TSetIpMaskGatewayRsp

---@class Ipv4.SetIpMaskGatewayReq
---@field IpAddr string
---@field SubnetMask string
---@field DefaultGateway string
local TSetIpMaskGatewayReq = {}
TSetIpMaskGatewayReq.__index = TSetIpMaskGatewayReq
TSetIpMaskGatewayReq.group = {}

local function TSetIpMaskGatewayReq_from_obj(obj)
    return setmetatable(obj, TSetIpMaskGatewayReq)
end

function TSetIpMaskGatewayReq.new(IpAddr, SubnetMask, DefaultGateway)
    return TSetIpMaskGatewayReq_from_obj({
        IpAddr = IpAddr,
        SubnetMask = SubnetMask,
        DefaultGateway = DefaultGateway
    })
end
---@param obj Ipv4.SetIpMaskGatewayReq
function TSetIpMaskGatewayReq:init_from_obj(obj)
    self.IpAddr = obj.IpAddr
    self.SubnetMask = obj.SubnetMask
    self.DefaultGateway = obj.DefaultGateway
end

function TSetIpMaskGatewayReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetIpMaskGatewayReq.group)
end

TSetIpMaskGatewayReq.from_obj = TSetIpMaskGatewayReq_from_obj

TSetIpMaskGatewayReq.proto_property = {'IpAddr', 'SubnetMask', 'DefaultGateway'}

TSetIpMaskGatewayReq.default = {'', '', ''}

TSetIpMaskGatewayReq.struct = {
    {name = 'IpAddr', is_array = false, struct = nil},
    {name = 'SubnetMask', is_array = false, struct = nil},
    {name = 'DefaultGateway', is_array = false, struct = nil}
}

function TSetIpMaskGatewayReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IpAddr', self.IpAddr, "string", false, errs,
                      need_convert)
    validate.Optional(prefix .. 'SubnetMask', self.SubnetMask, "string", false,
                      errs, need_convert)
    validate.Optional(prefix .. 'DefaultGateway', self.DefaultGateway, "string",
                      false, errs, need_convert)

    TSetIpMaskGatewayReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetIpMaskGatewayReq.proto_property,
                                 errs, need_convert)
    return self
end

function TSetIpMaskGatewayReq:unpack(_)
    return self.IpAddr, self.SubnetMask, self.DefaultGateway
end

Ipv4.SetIpMaskGatewayReq = TSetIpMaskGatewayReq

Ipv4.interface = mdb.register_interface(
                     'bmc.kepler.Managers.EthernetInterfaces.Ipv4', {
        IpMode = {'s', nil, false, nil, false},
        IpAddr = {'s', nil, true, nil, false},
        BackupIpAddr = {'s', nil, false, nil, false},
        SubnetMask = {'s', nil, true, nil, false},
        BackupSubnetMask = {'s', nil, false, nil, false},
        DefaultGateway = {'s', nil, true, nil, false}
    }, {
        SetIpMaskGateway = {
            'a{ss}sss', 's', TSetIpMaskGatewayReq, TSetIpMaskGatewayRsp
        },
        SetIpAddr = {'a{ss}ss', 'b', TSetIpAddrReq, TSetIpAddrRsp},
        SetDefaultGateway = {
            'a{ss}s', 'b', TSetDefaultGatewayReq, TSetDefaultGatewayRsp
        },
        SetDedicatedMaintIpMask = {
            'a{ss}ss', 'b', TSetDedicatedMaintIpMaskReq,
            TSetDedicatedMaintIpMaskRsp
        }
    }, {ChangedSignal = 'a{ss}a(sss)'})

return Ipv4
