-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-3-15
-- Description: DO NOT EDIT; Code generated by "message.lua.mako"
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local EthernetInterfaces = {}

---@class EthernetInterfaces.ChangedInfoItem
---@field Field string
---@field Value string
local TChangedInfoItem = {}
TChangedInfoItem.__index = TChangedInfoItem
TChangedInfoItem.group = {}

local function TChangedInfoItem_from_obj(obj)
    return setmetatable(obj, TChangedInfoItem)
end

function TChangedInfoItem.new(Field, Value)
    return TChangedInfoItem_from_obj({Field = Field, Value = Value})
end
---@param obj EthernetInterfaces.ChangedInfoItem
function TChangedInfoItem:init_from_obj(obj)
    self.Field = obj.Field
    self.Value = obj.Value
end

function TChangedInfoItem:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChangedInfoItem.group)
end

TChangedInfoItem.from_obj = TChangedInfoItem_from_obj

TChangedInfoItem.proto_property = {'Field', 'Value'}

TChangedInfoItem.default = {'', ''}

TChangedInfoItem.struct = {
    {name = 'Field', is_array = false, struct = nil},
    {name = 'Value', is_array = false, struct = nil}
}

function TChangedInfoItem:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Field', self.Field, "string", false, errs,
                      need_convert)
    validate.Optional(prefix .. 'Value', self.Value, "string", false, errs,
                      need_convert)

    TChangedInfoItem:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChangedInfoItem.proto_property, errs,
                                 need_convert)
    return self
end

function TChangedInfoItem:unpack(_) return self.Field, self.Value end

EthernetInterfaces.ChangedInfoItem = TChangedInfoItem

---@class EthernetInterfaces.Port
---@field Id integer
---@field EthId integer
---@field DeviceId integer
---@field DevicePortId integer
---@field Silkscreen string
---@field Type string
---@field AdaptiveFlag boolean
---@field LinkStatus string
---@field Mac string
local TPort = {}
TPort.__index = TPort
TPort.group = {}

local function TPort_from_obj(obj) return setmetatable(obj, TPort) end

function TPort.new(Id, EthId, DeviceId, DevicePortId, Silkscreen, Type,
                   AdaptiveFlag, LinkStatus, Mac)
    return TPort_from_obj({
        Id = Id,
        EthId = EthId,
        DeviceId = DeviceId,
        DevicePortId = DevicePortId,
        Silkscreen = Silkscreen,
        Type = Type,
        AdaptiveFlag = AdaptiveFlag,
        LinkStatus = LinkStatus,
        Mac = Mac
    })
end
---@param obj EthernetInterfaces.Port
function TPort:init_from_obj(obj)
    self.Id = obj.Id
    self.EthId = obj.EthId
    self.DeviceId = obj.DeviceId
    self.DevicePortId = obj.DevicePortId
    self.Silkscreen = obj.Silkscreen
    self.Type = obj.Type
    self.AdaptiveFlag = obj.AdaptiveFlag
    self.LinkStatus = obj.LinkStatus
    self.Mac = obj.Mac
end

function TPort:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPort.group)
end

TPort.from_obj = TPort_from_obj

TPort.proto_property = {
    'Id', 'EthId', 'DeviceId', 'DevicePortId', 'Silkscreen', 'Type',
    'AdaptiveFlag', 'LinkStatus', 'Mac'
}

TPort.default = {0, 0, 0, 0, '', '', false, '', ''}

TPort.struct = {
    {name = 'Id', is_array = false, struct = nil},
    {name = 'EthId', is_array = false, struct = nil},
    {name = 'DeviceId', is_array = false, struct = nil},
    {name = 'DevicePortId', is_array = false, struct = nil},
    {name = 'Silkscreen', is_array = false, struct = nil},
    {name = 'Type', is_array = false, struct = nil},
    {name = 'AdaptiveFlag', is_array = false, struct = nil},
    {name = 'LinkStatus', is_array = false, struct = nil},
    {name = 'Mac', is_array = false, struct = nil}
}

function TPort:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Id', self.Id, "uint8", false, errs,
                      need_convert)
    validate.Optional(prefix .. 'EthId', self.EthId, "uint8", false, errs,
                      need_convert)
    validate.Optional(prefix .. 'DeviceId', self.DeviceId, "uint8", false, errs,
                      need_convert)
    validate.Optional(prefix .. 'DevicePortId', self.DevicePortId, "uint8",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'Silkscreen', self.Silkscreen, "string", false,
                      errs, need_convert)
    validate.Optional(prefix .. 'Type', self.Type, "string", false, errs,
                      need_convert)
    validate.Optional(prefix .. 'AdaptiveFlag', self.AdaptiveFlag, "bool",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'LinkStatus', self.LinkStatus, "string", false,
                      errs, need_convert)
    validate.Optional(prefix .. 'Mac', self.Mac, "string", false, errs,
                      need_convert)

    TPort:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPort.proto_property, errs, need_convert)
    return self
end

function TPort:unpack(_)
    return self.Id, self.EthId, self.DeviceId, self.DevicePortId,
           self.Silkscreen, self.Type, self.AdaptiveFlag, self.LinkStatus,
           self.Mac
end

EthernetInterfaces.Port = TPort

---@class EthernetInterfaces.DefaultFactoryIpVersion
---@field DefaultFactoryIpVersion string
local TDefaultFactoryIpVersion = {}
TDefaultFactoryIpVersion.__index = TDefaultFactoryIpVersion
TDefaultFactoryIpVersion.group = {}

local function TDefaultFactoryIpVersion_from_obj(obj)
    return setmetatable(obj, TDefaultFactoryIpVersion)
end

function TDefaultFactoryIpVersion.new(DefaultFactoryIpVersion)
    return TDefaultFactoryIpVersion_from_obj({
        DefaultFactoryIpVersion = DefaultFactoryIpVersion or [=[IPv4AndIPv6]=]
    })
end
---@param obj EthernetInterfaces.DefaultFactoryIpVersion
function TDefaultFactoryIpVersion:init_from_obj(obj)
    self.DefaultFactoryIpVersion = obj.DefaultFactoryIpVersion or
                                       [=[IPv4AndIPv6]=]
end

function TDefaultFactoryIpVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDefaultFactoryIpVersion.group)
end

TDefaultFactoryIpVersion.from_obj = TDefaultFactoryIpVersion_from_obj

TDefaultFactoryIpVersion.proto_property = {'DefaultFactoryIpVersion'}

TDefaultFactoryIpVersion.default = {''}

TDefaultFactoryIpVersion.struct = {
    {name = 'DefaultFactoryIpVersion', is_array = false, struct = nil}
}

function TDefaultFactoryIpVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DefaultFactoryIpVersion',
                      self.DefaultFactoryIpVersion, "string", true, errs,
                      need_convert)

    if self.DefaultFactoryIpVersion ~= nil then
        validate.Enum(prefix .. 'DefaultFactoryIpVersion',
                      self.DefaultFactoryIpVersion, '',
                      {"IPv4", "IPv6", "IPv4AndIPv6"}, errs, need_convert)
    end

    TDefaultFactoryIpVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDefaultFactoryIpVersion.proto_property,
                                 errs, need_convert)
    return self
end

function TDefaultFactoryIpVersion:unpack(_) return self.DefaultFactoryIpVersion end

EthernetInterfaces.DefaultFactoryIpVersion = TDefaultFactoryIpVersion

---@class EthernetInterfaces.DefaultFactoryIpv6Addr
---@field DefaultFactoryIpv6Addr string
local TDefaultFactoryIpv6Addr = {}
TDefaultFactoryIpv6Addr.__index = TDefaultFactoryIpv6Addr
TDefaultFactoryIpv6Addr.group = {}

local function TDefaultFactoryIpv6Addr_from_obj(obj)
    return setmetatable(obj, TDefaultFactoryIpv6Addr)
end

function TDefaultFactoryIpv6Addr.new(DefaultFactoryIpv6Addr)
    return TDefaultFactoryIpv6Addr_from_obj({
        DefaultFactoryIpv6Addr = DefaultFactoryIpv6Addr
    })
end
---@param obj EthernetInterfaces.DefaultFactoryIpv6Addr
function TDefaultFactoryIpv6Addr:init_from_obj(obj)
    self.DefaultFactoryIpv6Addr = obj.DefaultFactoryIpv6Addr
end

function TDefaultFactoryIpv6Addr:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDefaultFactoryIpv6Addr.group)
end

TDefaultFactoryIpv6Addr.from_obj = TDefaultFactoryIpv6Addr_from_obj

TDefaultFactoryIpv6Addr.proto_property = {'DefaultFactoryIpv6Addr'}

TDefaultFactoryIpv6Addr.default = {''}

TDefaultFactoryIpv6Addr.struct = {
    {name = 'DefaultFactoryIpv6Addr', is_array = false, struct = nil}
}

function TDefaultFactoryIpv6Addr:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DefaultFactoryIpv6Addr',
                      self.DefaultFactoryIpv6Addr, "string", true, errs,
                      need_convert)

    TDefaultFactoryIpv6Addr:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDefaultFactoryIpv6Addr.proto_property,
                                 errs, need_convert)
    return self
end

function TDefaultFactoryIpv6Addr:unpack(_) return self.DefaultFactoryIpv6Addr end

EthernetInterfaces.DefaultFactoryIpv6Addr = TDefaultFactoryIpv6Addr

---@class EthernetInterfaces.DefaultFactoryIpv6Mode
---@field DefaultFactoryIpv6Mode string
local TDefaultFactoryIpv6Mode = {}
TDefaultFactoryIpv6Mode.__index = TDefaultFactoryIpv6Mode
TDefaultFactoryIpv6Mode.group = {}

local function TDefaultFactoryIpv6Mode_from_obj(obj)
    return setmetatable(obj, TDefaultFactoryIpv6Mode)
end

function TDefaultFactoryIpv6Mode.new(DefaultFactoryIpv6Mode)
    return TDefaultFactoryIpv6Mode_from_obj({
        DefaultFactoryIpv6Mode = DefaultFactoryIpv6Mode or [=[DHCPv6]=]
    })
end
---@param obj EthernetInterfaces.DefaultFactoryIpv6Mode
function TDefaultFactoryIpv6Mode:init_from_obj(obj)
    self.DefaultFactoryIpv6Mode = obj.DefaultFactoryIpv6Mode or [=[DHCPv6]=]
end

function TDefaultFactoryIpv6Mode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDefaultFactoryIpv6Mode.group)
end

TDefaultFactoryIpv6Mode.from_obj = TDefaultFactoryIpv6Mode_from_obj

TDefaultFactoryIpv6Mode.proto_property = {'DefaultFactoryIpv6Mode'}

TDefaultFactoryIpv6Mode.default = {''}

TDefaultFactoryIpv6Mode.struct = {
    {name = 'DefaultFactoryIpv6Mode', is_array = false, struct = nil}
}

function TDefaultFactoryIpv6Mode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DefaultFactoryIpv6Mode',
                      self.DefaultFactoryIpv6Mode, "string", true, errs,
                      need_convert)

    if self.DefaultFactoryIpv6Mode ~= nil then
        validate.Enum(prefix .. 'DefaultFactoryIpv6Mode',
                      self.DefaultFactoryIpv6Mode, '', {"DHCPv6", "Static"},
                      errs, need_convert)
    end

    TDefaultFactoryIpv6Mode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDefaultFactoryIpv6Mode.proto_property,
                                 errs, need_convert)
    return self
end

function TDefaultFactoryIpv6Mode:unpack(_) return self.DefaultFactoryIpv6Mode end

EthernetInterfaces.DefaultFactoryIpv6Mode = TDefaultFactoryIpv6Mode

---@class EthernetInterfaces.DefaultFactoryIpAddr
---@field DefaultFactoryIpAddr string
local TDefaultFactoryIpAddr = {}
TDefaultFactoryIpAddr.__index = TDefaultFactoryIpAddr
TDefaultFactoryIpAddr.group = {}

local function TDefaultFactoryIpAddr_from_obj(obj)
    return setmetatable(obj, TDefaultFactoryIpAddr)
end

function TDefaultFactoryIpAddr.new(DefaultFactoryIpAddr)
    return TDefaultFactoryIpAddr_from_obj({
        DefaultFactoryIpAddr = DefaultFactoryIpAddr
    })
end
---@param obj EthernetInterfaces.DefaultFactoryIpAddr
function TDefaultFactoryIpAddr:init_from_obj(obj)
    self.DefaultFactoryIpAddr = obj.DefaultFactoryIpAddr
end

function TDefaultFactoryIpAddr:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDefaultFactoryIpAddr.group)
end

TDefaultFactoryIpAddr.from_obj = TDefaultFactoryIpAddr_from_obj

TDefaultFactoryIpAddr.proto_property = {'DefaultFactoryIpAddr'}

TDefaultFactoryIpAddr.default = {''}

TDefaultFactoryIpAddr.struct = {
    {name = 'DefaultFactoryIpAddr', is_array = false, struct = nil}
}

function TDefaultFactoryIpAddr:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DefaultFactoryIpAddr',
                      self.DefaultFactoryIpAddr, "string", true, errs,
                      need_convert)

    TDefaultFactoryIpAddr:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDefaultFactoryIpAddr.proto_property,
                                 errs, need_convert)
    return self
end

function TDefaultFactoryIpAddr:unpack(_) return self.DefaultFactoryIpAddr end

EthernetInterfaces.DefaultFactoryIpAddr = TDefaultFactoryIpAddr

---@class EthernetInterfaces.DefaultFactoryIpMode
---@field DefaultFactoryIpMode string
local TDefaultFactoryIpMode = {}
TDefaultFactoryIpMode.__index = TDefaultFactoryIpMode
TDefaultFactoryIpMode.group = {}

local function TDefaultFactoryIpMode_from_obj(obj)
    return setmetatable(obj, TDefaultFactoryIpMode)
end

function TDefaultFactoryIpMode.new(DefaultFactoryIpMode)
    return TDefaultFactoryIpMode_from_obj({
        DefaultFactoryIpMode = DefaultFactoryIpMode
    })
end
---@param obj EthernetInterfaces.DefaultFactoryIpMode
function TDefaultFactoryIpMode:init_from_obj(obj)
    self.DefaultFactoryIpMode = obj.DefaultFactoryIpMode
end

function TDefaultFactoryIpMode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDefaultFactoryIpMode.group)
end

TDefaultFactoryIpMode.from_obj = TDefaultFactoryIpMode_from_obj

TDefaultFactoryIpMode.proto_property = {'DefaultFactoryIpMode'}

TDefaultFactoryIpMode.default = {''}

TDefaultFactoryIpMode.struct = {
    {name = 'DefaultFactoryIpMode', is_array = false, struct = nil}
}

function TDefaultFactoryIpMode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DefaultFactoryIpMode',
                      self.DefaultFactoryIpMode, "string", true, errs,
                      need_convert)

    if self.DefaultFactoryIpMode ~= nil then
        validate.Enum(prefix .. 'DefaultFactoryIpMode',
                      self.DefaultFactoryIpMode, '', {"DHCP", "Static"}, errs,
                      need_convert)
    end

    TDefaultFactoryIpMode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDefaultFactoryIpMode.proto_property,
                                 errs, need_convert)
    return self
end

function TDefaultFactoryIpMode:unpack(_) return self.DefaultFactoryIpMode end

EthernetInterfaces.DefaultFactoryIpMode = TDefaultFactoryIpMode

---@class EthernetInterfaces.BackupIpActivated
---@field BackupIpActivated boolean
local TBackupIpActivated = {}
TBackupIpActivated.__index = TBackupIpActivated
TBackupIpActivated.group = {}

local function TBackupIpActivated_from_obj(obj)
    return setmetatable(obj, TBackupIpActivated)
end

function TBackupIpActivated.new(BackupIpActivated)
    return TBackupIpActivated_from_obj({BackupIpActivated = BackupIpActivated})
end
---@param obj EthernetInterfaces.BackupIpActivated
function TBackupIpActivated:init_from_obj(obj)
    self.BackupIpActivated = obj.BackupIpActivated
end

function TBackupIpActivated:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBackupIpActivated.group)
end

TBackupIpActivated.from_obj = TBackupIpActivated_from_obj

TBackupIpActivated.proto_property = {'BackupIpActivated'}

TBackupIpActivated.default = {false}

TBackupIpActivated.struct = {
    {name = 'BackupIpActivated', is_array = false, struct = nil}
}

function TBackupIpActivated:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BackupIpActivated', self.BackupIpActivated,
                      "bool", true, errs, need_convert)

    TBackupIpActivated:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBackupIpActivated.proto_property, errs,
                                 need_convert)
    return self
end

function TBackupIpActivated:unpack(_) return self.BackupIpActivated end

EthernetInterfaces.BackupIpActivated = TBackupIpActivated

---@class EthernetInterfaces.LinkLocalAddress
---@field LinkLocalAddress string
local TLinkLocalAddress = {}
TLinkLocalAddress.__index = TLinkLocalAddress
TLinkLocalAddress.group = {}

local function TLinkLocalAddress_from_obj(obj)
    return setmetatable(obj, TLinkLocalAddress)
end

function TLinkLocalAddress.new(LinkLocalAddress)
    return TLinkLocalAddress_from_obj({LinkLocalAddress = LinkLocalAddress})
end
---@param obj EthernetInterfaces.LinkLocalAddress
function TLinkLocalAddress:init_from_obj(obj)
    self.LinkLocalAddress = obj.LinkLocalAddress
end

function TLinkLocalAddress:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLinkLocalAddress.group)
end

TLinkLocalAddress.from_obj = TLinkLocalAddress_from_obj

TLinkLocalAddress.proto_property = {'LinkLocalAddress'}

TLinkLocalAddress.default = {''}

TLinkLocalAddress.struct = {
    {name = 'LinkLocalAddress', is_array = false, struct = nil}
}

function TLinkLocalAddress:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LinkLocalAddress', self.LinkLocalAddress,
                      "string", true, errs, need_convert)

    TLinkLocalAddress:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLinkLocalAddress.proto_property, errs,
                                 need_convert)
    return self
end

function TLinkLocalAddress:unpack(_) return self.LinkLocalAddress end

EthernetInterfaces.LinkLocalAddress = TLinkLocalAddress

---@class EthernetInterfaces.SLAACAddressList
---@field SLAACAddressList string[]
local TSLAACAddressList = {}
TSLAACAddressList.__index = TSLAACAddressList
TSLAACAddressList.group = {}

local function TSLAACAddressList_from_obj(obj)
    return setmetatable(obj, TSLAACAddressList)
end

function TSLAACAddressList.new(SLAACAddressList)
    return TSLAACAddressList_from_obj({SLAACAddressList = SLAACAddressList})
end
---@param obj EthernetInterfaces.SLAACAddressList
function TSLAACAddressList:init_from_obj(obj)
    self.SLAACAddressList = obj.SLAACAddressList
end

function TSLAACAddressList:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSLAACAddressList.group)
end

TSLAACAddressList.from_obj = TSLAACAddressList_from_obj

TSLAACAddressList.proto_property = {'SLAACAddressList'}

TSLAACAddressList.default = {{}}

TSLAACAddressList.struct = {
    {name = 'SLAACAddressList', is_array = true, struct = nil}
}

function TSLAACAddressList:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'SLAACAddressList', self.SLAACAddressList,
                           "string", true, errs, need_convert)

    TSLAACAddressList:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSLAACAddressList.proto_property, errs,
                                 need_convert)
    return self
end

function TSLAACAddressList:unpack(_) return self.SLAACAddressList end

EthernetInterfaces.SLAACAddressList = TSLAACAddressList

---@class EthernetInterfaces.VLANId
---@field VLANId integer
local TVLANId = {}
TVLANId.__index = TVLANId
TVLANId.group = {}

local function TVLANId_from_obj(obj) return setmetatable(obj, TVLANId) end

function TVLANId.new(VLANId) return TVLANId_from_obj({VLANId = VLANId}) end
---@param obj EthernetInterfaces.VLANId
function TVLANId:init_from_obj(obj) self.VLANId = obj.VLANId end

function TVLANId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVLANId.group)
end

TVLANId.from_obj = TVLANId_from_obj

TVLANId.proto_property = {'VLANId'}

TVLANId.default = {0}

TVLANId.struct = {{name = 'VLANId', is_array = false, struct = nil}}

function TVLANId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VLANId', self.VLANId, "uint16", true, errs,
                      need_convert)

    TVLANId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVLANId.proto_property, errs,
                                 need_convert)
    return self
end

function TVLANId:unpack(_) return self.VLANId end

EthernetInterfaces.VLANId = TVLANId

---@class EthernetInterfaces.VLANEnable
---@field VLANEnable boolean
local TVLANEnable = {}
TVLANEnable.__index = TVLANEnable
TVLANEnable.group = {}

local function TVLANEnable_from_obj(obj) return setmetatable(obj, TVLANEnable) end

function TVLANEnable.new(VLANEnable)
    return TVLANEnable_from_obj({VLANEnable = VLANEnable})
end
---@param obj EthernetInterfaces.VLANEnable
function TVLANEnable:init_from_obj(obj) self.VLANEnable = obj.VLANEnable end

function TVLANEnable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVLANEnable.group)
end

TVLANEnable.from_obj = TVLANEnable_from_obj

TVLANEnable.proto_property = {'VLANEnable'}

TVLANEnable.default = {false}

TVLANEnable.struct = {{name = 'VLANEnable', is_array = false, struct = nil}}

function TVLANEnable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VLANEnable', self.VLANEnable, "bool", true,
                      errs, need_convert)

    TVLANEnable:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVLANEnable.proto_property, errs,
                                 need_convert)
    return self
end

function TVLANEnable:unpack(_) return self.VLANEnable end

EthernetInterfaces.VLANEnable = TVLANEnable

---@class EthernetInterfaces.PortId
---@field PortId integer
local TPortId = {}
TPortId.__index = TPortId
TPortId.group = {}

local function TPortId_from_obj(obj) return setmetatable(obj, TPortId) end

function TPortId.new(PortId) return TPortId_from_obj({PortId = PortId}) end
---@param obj EthernetInterfaces.PortId
function TPortId:init_from_obj(obj) self.PortId = obj.PortId end

function TPortId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPortId.group)
end

TPortId.from_obj = TPortId_from_obj

TPortId.proto_property = {'PortId'}

TPortId.default = {0}

TPortId.struct = {{name = 'PortId', is_array = false, struct = nil}}

function TPortId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PortId', self.PortId, "uint8", true, errs,
                      need_convert)

    TPortId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPortId.proto_property, errs,
                                 need_convert)
    return self
end

function TPortId:unpack(_) return self.PortId end

EthernetInterfaces.PortId = TPortId

---@class EthernetInterfaces.NcsiEnable
---@field NcsiEnable boolean
local TNcsiEnable = {}
TNcsiEnable.__index = TNcsiEnable
TNcsiEnable.group = {}

local function TNcsiEnable_from_obj(obj) return setmetatable(obj, TNcsiEnable) end

function TNcsiEnable.new(NcsiEnable)
    return TNcsiEnable_from_obj({NcsiEnable = NcsiEnable})
end
---@param obj EthernetInterfaces.NcsiEnable
function TNcsiEnable:init_from_obj(obj) self.NcsiEnable = obj.NcsiEnable end

function TNcsiEnable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNcsiEnable.group)
end

TNcsiEnable.from_obj = TNcsiEnable_from_obj

TNcsiEnable.proto_property = {'NcsiEnable'}

TNcsiEnable.default = {false}

TNcsiEnable.struct = {{name = 'NcsiEnable', is_array = false, struct = nil}}

function TNcsiEnable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NcsiEnable', self.NcsiEnable, "bool", true,
                      errs, need_convert)

    TNcsiEnable:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNcsiEnable.proto_property, errs,
                                 need_convert)
    return self
end

function TNcsiEnable:unpack(_) return self.NcsiEnable end

EthernetInterfaces.NcsiEnable = TNcsiEnable

---@class EthernetInterfaces.IpVersion
---@field IpVersion string
local TIpVersion = {}
TIpVersion.__index = TIpVersion
TIpVersion.group = {}

local function TIpVersion_from_obj(obj) return setmetatable(obj, TIpVersion) end

function TIpVersion.new(IpVersion)
    return TIpVersion_from_obj({IpVersion = IpVersion})
end
---@param obj EthernetInterfaces.IpVersion
function TIpVersion:init_from_obj(obj) self.IpVersion = obj.IpVersion end

function TIpVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIpVersion.group)
end

TIpVersion.from_obj = TIpVersion_from_obj

TIpVersion.proto_property = {'IpVersion'}

TIpVersion.default = {''}

TIpVersion.struct = {{name = 'IpVersion', is_array = false, struct = nil}}

function TIpVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IpVersion', self.IpVersion, "string", false,
                      errs, need_convert)

    if self.IpVersion ~= nil then
        validate.Enum(prefix .. 'IpVersion', self.IpVersion, '',
                      {"IPv4", "IPv6", "IPv4AndIPv6"}, errs, need_convert)
    end

    TIpVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIpVersion.proto_property, errs,
                                 need_convert)
    return self
end

function TIpVersion:unpack(_) return self.IpVersion end

EthernetInterfaces.IpVersion = TIpVersion

---@class EthernetInterfaces.Mac
---@field Mac string
local TMac = {}
TMac.__index = TMac
TMac.group = {}

local function TMac_from_obj(obj) return setmetatable(obj, TMac) end

function TMac.new(Mac) return TMac_from_obj({Mac = Mac}) end
---@param obj EthernetInterfaces.Mac
function TMac:init_from_obj(obj) self.Mac = obj.Mac end

function TMac:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMac.group)
end

TMac.from_obj = TMac_from_obj

TMac.proto_property = {'Mac'}

TMac.default = {''}

TMac.struct = {{name = 'Mac', is_array = false, struct = nil}}

function TMac:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Mac', self.Mac, "string", true, errs,
                      need_convert)

    TMac:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMac.proto_property, errs, need_convert)
    return self
end

function TMac:unpack(_) return self.Mac end

EthernetInterfaces.Mac = TMac

---@class EthernetInterfaces.NetMode
---@field NetMode string
local TNetMode = {}
TNetMode.__index = TNetMode
TNetMode.group = {}

local function TNetMode_from_obj(obj) return setmetatable(obj, TNetMode) end

function TNetMode.new(NetMode) return TNetMode_from_obj({NetMode = NetMode}) end
---@param obj EthernetInterfaces.NetMode
function TNetMode:init_from_obj(obj) self.NetMode = obj.NetMode end

function TNetMode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNetMode.group)
end

TNetMode.from_obj = TNetMode_from_obj

TNetMode.proto_property = {'NetMode'}

TNetMode.default = {''}

TNetMode.struct = {{name = 'NetMode', is_array = false, struct = nil}}

function TNetMode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NetMode', self.NetMode, "string", false, errs,
                      need_convert)

    if self.NetMode ~= nil then
        validate.Enum(prefix .. 'NetMode', self.NetMode, '',
                      {"Fixed", "Automatic"}, errs, need_convert)
    end

    TNetMode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNetMode.proto_property, errs,
                                 need_convert)
    return self
end

function TNetMode:unpack(_) return self.NetMode end

EthernetInterfaces.NetMode = TNetMode

---@class EthernetInterfaces.EthName
---@field EthName string
local TEthName = {}
TEthName.__index = TEthName
TEthName.group = {}

local function TEthName_from_obj(obj) return setmetatable(obj, TEthName) end

function TEthName.new(EthName) return TEthName_from_obj({EthName = EthName}) end
---@param obj EthernetInterfaces.EthName
function TEthName:init_from_obj(obj) self.EthName = obj.EthName end

function TEthName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEthName.group)
end

TEthName.from_obj = TEthName_from_obj

TEthName.proto_property = {'EthName'}

TEthName.default = {''}

TEthName.struct = {{name = 'EthName', is_array = false, struct = nil}}

function TEthName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EthName', self.EthName, "string", true, errs,
                      need_convert)

    TEthName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEthName.proto_property, errs,
                                 need_convert)
    return self
end

function TEthName:unpack(_) return self.EthName end

EthernetInterfaces.EthName = TEthName

---@class EthernetInterfaces.EthMacChangedSignalSignature
---@field EthName string
---@field Mac string
local TEthMacChangedSignalSignature = {}
TEthMacChangedSignalSignature.__index = TEthMacChangedSignalSignature
TEthMacChangedSignalSignature.group = {}

local function TEthMacChangedSignalSignature_from_obj(obj)
    return setmetatable(obj, TEthMacChangedSignalSignature)
end

function TEthMacChangedSignalSignature.new(EthName, Mac)
    return
        TEthMacChangedSignalSignature_from_obj({EthName = EthName, Mac = Mac})
end
---@param obj EthernetInterfaces.EthMacChangedSignalSignature
function TEthMacChangedSignalSignature:init_from_obj(obj)
    self.EthName = obj.EthName
    self.Mac = obj.Mac
end

function TEthMacChangedSignalSignature:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs,
                                    TEthMacChangedSignalSignature.group)
end

TEthMacChangedSignalSignature.from_obj = TEthMacChangedSignalSignature_from_obj

TEthMacChangedSignalSignature.proto_property = {'EthName', 'Mac'}

TEthMacChangedSignalSignature.default = {'', ''}

TEthMacChangedSignalSignature.struct = {
    {name = 'EthName', is_array = false, struct = nil},
    {name = 'Mac', is_array = false, struct = nil}
}

function TEthMacChangedSignalSignature:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EthName', self.EthName, "string", false, errs,
                      need_convert)
    validate.Optional(prefix .. 'Mac', self.Mac, "string", false, errs,
                      need_convert)

    TEthMacChangedSignalSignature:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self,
                                 TEthMacChangedSignalSignature.proto_property,
                                 errs, need_convert)
    return self
end

function TEthMacChangedSignalSignature:unpack(_) return self.EthName, self.Mac end

EthernetInterfaces.EthMacChangedSignalSignature = TEthMacChangedSignalSignature

---@class EthernetInterfaces.NCSIInfoChangedSignalSignature
---@field ChangedInfo EthernetInterfaces.ChangedInfoItem[]
local TNCSIInfoChangedSignalSignature = {}
TNCSIInfoChangedSignalSignature.__index = TNCSIInfoChangedSignalSignature
TNCSIInfoChangedSignalSignature.group = {}

local function TNCSIInfoChangedSignalSignature_from_obj(obj)
    obj.ChangedInfo = utils.from_obj(EthernetInterfaces.ChangedInfoItem,
                                     obj.ChangedInfo, true)
    return setmetatable(obj, TNCSIInfoChangedSignalSignature)
end

function TNCSIInfoChangedSignalSignature.new(ChangedInfo)
    return TNCSIInfoChangedSignalSignature_from_obj({ChangedInfo = ChangedInfo})
end
---@param obj EthernetInterfaces.NCSIInfoChangedSignalSignature
function TNCSIInfoChangedSignalSignature:init_from_obj(obj)
    self.ChangedInfo = obj.ChangedInfo
end

function TNCSIInfoChangedSignalSignature:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs,
                                    TNCSIInfoChangedSignalSignature.group)
end

TNCSIInfoChangedSignalSignature.from_obj =
    TNCSIInfoChangedSignalSignature_from_obj

TNCSIInfoChangedSignalSignature.proto_property = {'ChangedInfo'}

TNCSIInfoChangedSignalSignature.default = {{}}

TNCSIInfoChangedSignalSignature.struct = {
    {
        name = 'ChangedInfo',
        is_array = true,
        struct = EthernetInterfaces.ChangedInfoItem.struct
    }
}

function TNCSIInfoChangedSignalSignature:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.ChangedInfo) do
        EthernetInterfaces.ChangedInfoItem.new(v.Field, v.Value):validate(
            prefix, errs, need_convert)
    end

    TNCSIInfoChangedSignalSignature:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self,
                                 TNCSIInfoChangedSignalSignature.proto_property,
                                 errs, need_convert)
    return self
end

function TNCSIInfoChangedSignalSignature:unpack(raw)
    return utils.unpack(raw, self.ChangedInfo, true)
end

EthernetInterfaces.NCSIInfoChangedSignalSignature =
    TNCSIInfoChangedSignalSignature

---@class EthernetInterfaces.ActivePortChangedSignalSignature
---@field OldPortId integer
---@field PortId integer
local TActivePortChangedSignalSignature = {}
TActivePortChangedSignalSignature.__index = TActivePortChangedSignalSignature
TActivePortChangedSignalSignature.group = {}

local function TActivePortChangedSignalSignature_from_obj(obj)
    return setmetatable(obj, TActivePortChangedSignalSignature)
end

function TActivePortChangedSignalSignature.new(OldPortId, PortId)
    return TActivePortChangedSignalSignature_from_obj({
        OldPortId = OldPortId,
        PortId = PortId
    })
end
---@param obj EthernetInterfaces.ActivePortChangedSignalSignature
function TActivePortChangedSignalSignature:init_from_obj(obj)
    self.OldPortId = obj.OldPortId
    self.PortId = obj.PortId
end

function TActivePortChangedSignalSignature:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs,
                                    TActivePortChangedSignalSignature.group)
end

TActivePortChangedSignalSignature.from_obj =
    TActivePortChangedSignalSignature_from_obj

TActivePortChangedSignalSignature.proto_property = {'OldPortId', 'PortId'}

TActivePortChangedSignalSignature.default = {0, 0}

TActivePortChangedSignalSignature.struct = {
    {name = 'OldPortId', is_array = false, struct = nil},
    {name = 'PortId', is_array = false, struct = nil}
}

function TActivePortChangedSignalSignature:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OldPortId', self.OldPortId, "uint8", false,
                      errs, need_convert)
    validate.Optional(prefix .. 'PortId', self.PortId, "uint8", false, errs,
                      need_convert)

    TActivePortChangedSignalSignature:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self,
                                 TActivePortChangedSignalSignature.proto_property,
                                 errs, need_convert)
    return self
end

function TActivePortChangedSignalSignature:unpack(_)
    return self.OldPortId, self.PortId
end

EthernetInterfaces.ActivePortChangedSignalSignature =
    TActivePortChangedSignalSignature

---@class EthernetInterfaces.NetworkFailoverRsp
---@field Result boolean
local TNetworkFailoverRsp = {}
TNetworkFailoverRsp.__index = TNetworkFailoverRsp
TNetworkFailoverRsp.group = {}

local function TNetworkFailoverRsp_from_obj(obj)
    return setmetatable(obj, TNetworkFailoverRsp)
end

function TNetworkFailoverRsp.new(Result)
    return TNetworkFailoverRsp_from_obj({Result = Result})
end
---@param obj EthernetInterfaces.NetworkFailoverRsp
function TNetworkFailoverRsp:init_from_obj(obj) self.Result = obj.Result end

function TNetworkFailoverRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNetworkFailoverRsp.group)
end

TNetworkFailoverRsp.from_obj = TNetworkFailoverRsp_from_obj

TNetworkFailoverRsp.proto_property = {'Result'}

TNetworkFailoverRsp.default = {false}

TNetworkFailoverRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TNetworkFailoverRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, "bool", false, errs,
                      need_convert)

    TNetworkFailoverRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNetworkFailoverRsp.proto_property, errs,
                                 need_convert)
    return self
end

function TNetworkFailoverRsp:unpack(_) return self.Result end

EthernetInterfaces.NetworkFailoverRsp = TNetworkFailoverRsp

---@class EthernetInterfaces.NetworkFailoverReq
---@field From string
---@field To string
local TNetworkFailoverReq = {}
TNetworkFailoverReq.__index = TNetworkFailoverReq
TNetworkFailoverReq.group = {}

local function TNetworkFailoverReq_from_obj(obj)
    return setmetatable(obj, TNetworkFailoverReq)
end

function TNetworkFailoverReq.new(From, To)
    return TNetworkFailoverReq_from_obj({From = From, To = To})
end
---@param obj EthernetInterfaces.NetworkFailoverReq
function TNetworkFailoverReq:init_from_obj(obj)
    self.From = obj.From
    self.To = obj.To
end

function TNetworkFailoverReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNetworkFailoverReq.group)
end

TNetworkFailoverReq.from_obj = TNetworkFailoverReq_from_obj

TNetworkFailoverReq.proto_property = {'From', 'To'}

TNetworkFailoverReq.default = {'', ''}

TNetworkFailoverReq.struct = {
    {name = 'From', is_array = false, struct = nil},
    {name = 'To', is_array = false, struct = nil}
}

function TNetworkFailoverReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'From', self.From, "string", false, errs,
                      need_convert)
    validate.Optional(prefix .. 'To', self.To, "string", false, errs,
                      need_convert)

    TNetworkFailoverReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNetworkFailoverReq.proto_property, errs,
                                 need_convert)
    return self
end

function TNetworkFailoverReq:unpack(_) return self.From, self.To end

EthernetInterfaces.NetworkFailoverReq = TNetworkFailoverReq

---@class EthernetInterfaces.SetEthStateRsp
---@field Result boolean
local TSetEthStateRsp = {}
TSetEthStateRsp.__index = TSetEthStateRsp
TSetEthStateRsp.group = {}

local function TSetEthStateRsp_from_obj(obj)
    return setmetatable(obj, TSetEthStateRsp)
end

function TSetEthStateRsp.new(Result)
    return TSetEthStateRsp_from_obj({Result = Result})
end
---@param obj EthernetInterfaces.SetEthStateRsp
function TSetEthStateRsp:init_from_obj(obj) self.Result = obj.Result end

function TSetEthStateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetEthStateRsp.group)
end

TSetEthStateRsp.from_obj = TSetEthStateRsp_from_obj

TSetEthStateRsp.proto_property = {'Result'}

TSetEthStateRsp.default = {false}

TSetEthStateRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TSetEthStateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, "bool", false, errs,
                      need_convert)

    TSetEthStateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetEthStateRsp.proto_property, errs,
                                 need_convert)
    return self
end

function TSetEthStateRsp:unpack(_) return self.Result end

EthernetInterfaces.SetEthStateRsp = TSetEthStateRsp

---@class EthernetInterfaces.SetEthStateReq
---@field EthName string
---@field EthEnabled boolean
local TSetEthStateReq = {}
TSetEthStateReq.__index = TSetEthStateReq
TSetEthStateReq.group = {}

local function TSetEthStateReq_from_obj(obj)
    return setmetatable(obj, TSetEthStateReq)
end

function TSetEthStateReq.new(EthName, EthEnabled)
    return
        TSetEthStateReq_from_obj({EthName = EthName, EthEnabled = EthEnabled})
end
---@param obj EthernetInterfaces.SetEthStateReq
function TSetEthStateReq:init_from_obj(obj)
    self.EthName = obj.EthName
    self.EthEnabled = obj.EthEnabled
end

function TSetEthStateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetEthStateReq.group)
end

TSetEthStateReq.from_obj = TSetEthStateReq_from_obj

TSetEthStateReq.proto_property = {'EthName', 'EthEnabled'}

TSetEthStateReq.default = {'', false}

TSetEthStateReq.struct = {
    {name = 'EthName', is_array = false, struct = nil},
    {name = 'EthEnabled', is_array = false, struct = nil}
}

function TSetEthStateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EthName', self.EthName, "string", false, errs,
                      need_convert)
    validate.Optional(prefix .. 'EthEnabled', self.EthEnabled, "bool", false,
                      errs, need_convert)

    TSetEthStateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetEthStateReq.proto_property, errs,
                                 need_convert)
    return self
end

function TSetEthStateReq:unpack(_) return self.EthName, self.EthEnabled end

EthernetInterfaces.SetEthStateReq = TSetEthStateReq

---@class EthernetInterfaces.SetVLANConfigRsp
---@field Result boolean
local TSetVLANConfigRsp = {}
TSetVLANConfigRsp.__index = TSetVLANConfigRsp
TSetVLANConfigRsp.group = {}

local function TSetVLANConfigRsp_from_obj(obj)
    return setmetatable(obj, TSetVLANConfigRsp)
end

function TSetVLANConfigRsp.new(Result)
    return TSetVLANConfigRsp_from_obj({Result = Result})
end
---@param obj EthernetInterfaces.SetVLANConfigRsp
function TSetVLANConfigRsp:init_from_obj(obj) self.Result = obj.Result end

function TSetVLANConfigRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetVLANConfigRsp.group)
end

TSetVLANConfigRsp.from_obj = TSetVLANConfigRsp_from_obj

TSetVLANConfigRsp.proto_property = {'Result'}

TSetVLANConfigRsp.default = {false}

TSetVLANConfigRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TSetVLANConfigRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, "bool", false, errs,
                      need_convert)

    TSetVLANConfigRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetVLANConfigRsp.proto_property, errs,
                                 need_convert)
    return self
end

function TSetVLANConfigRsp:unpack(_) return self.Result end

EthernetInterfaces.SetVLANConfigRsp = TSetVLANConfigRsp

---@class EthernetInterfaces.SetVLANConfigReq
---@field VLANEnabled boolean
---@field VLANId integer
---@field PortType integer
local TSetVLANConfigReq = {}
TSetVLANConfigReq.__index = TSetVLANConfigReq
TSetVLANConfigReq.group = {}

local function TSetVLANConfigReq_from_obj(obj)
    return setmetatable(obj, TSetVLANConfigReq)
end

function TSetVLANConfigReq.new(VLANEnabled, VLANId, PortType)
    return TSetVLANConfigReq_from_obj({
        VLANEnabled = VLANEnabled,
        VLANId = VLANId,
        PortType = PortType
    })
end
---@param obj EthernetInterfaces.SetVLANConfigReq
function TSetVLANConfigReq:init_from_obj(obj)
    self.VLANEnabled = obj.VLANEnabled
    self.VLANId = obj.VLANId
    self.PortType = obj.PortType
end

function TSetVLANConfigReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetVLANConfigReq.group)
end

TSetVLANConfigReq.from_obj = TSetVLANConfigReq_from_obj

TSetVLANConfigReq.proto_property = {'VLANEnabled', 'VLANId', 'PortType'}

TSetVLANConfigReq.default = {false, 0, 0}

TSetVLANConfigReq.struct = {
    {name = 'VLANEnabled', is_array = false, struct = nil},
    {name = 'VLANId', is_array = false, struct = nil},
    {name = 'PortType', is_array = false, struct = nil}
}

function TSetVLANConfigReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VLANEnabled', self.VLANEnabled, "bool", false,
                      errs, need_convert)
    validate.Optional(prefix .. 'VLANId', self.VLANId, "uint16", false, errs,
                      need_convert)
    validate.Optional(prefix .. 'PortType', self.PortType, "uint8", false, errs,
                      need_convert)

    TSetVLANConfigReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetVLANConfigReq.proto_property, errs,
                                 need_convert)
    return self
end

function TSetVLANConfigReq:unpack(_)
    return self.VLANEnabled, self.VLANId, self.PortType
end

EthernetInterfaces.SetVLANConfigReq = TSetVLANConfigReq

---@class EthernetInterfaces.AddIp6tablesRuleRsp
---@field Result boolean
local TAddIp6tablesRuleRsp = {}
TAddIp6tablesRuleRsp.__index = TAddIp6tablesRuleRsp
TAddIp6tablesRuleRsp.group = {}

local function TAddIp6tablesRuleRsp_from_obj(obj)
    return setmetatable(obj, TAddIp6tablesRuleRsp)
end

function TAddIp6tablesRuleRsp.new(Result)
    return TAddIp6tablesRuleRsp_from_obj({Result = Result})
end
---@param obj EthernetInterfaces.AddIp6tablesRuleRsp
function TAddIp6tablesRuleRsp:init_from_obj(obj) self.Result = obj.Result end

function TAddIp6tablesRuleRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddIp6tablesRuleRsp.group)
end

TAddIp6tablesRuleRsp.from_obj = TAddIp6tablesRuleRsp_from_obj

TAddIp6tablesRuleRsp.proto_property = {'Result'}

TAddIp6tablesRuleRsp.default = {false}

TAddIp6tablesRuleRsp.struct = {
    {name = 'Result', is_array = false, struct = nil}
}

function TAddIp6tablesRuleRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, "bool", false, errs,
                      need_convert)

    TAddIp6tablesRuleRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddIp6tablesRuleRsp.proto_property,
                                 errs, need_convert)
    return self
end

function TAddIp6tablesRuleRsp:unpack(_) return self.Result end

EthernetInterfaces.AddIp6tablesRuleRsp = TAddIp6tablesRuleRsp

---@class EthernetInterfaces.AddIp6tablesRuleReq
---@field InterfaceName string
---@field Ipv6Addr string
local TAddIp6tablesRuleReq = {}
TAddIp6tablesRuleReq.__index = TAddIp6tablesRuleReq
TAddIp6tablesRuleReq.group = {}

local function TAddIp6tablesRuleReq_from_obj(obj)
    return setmetatable(obj, TAddIp6tablesRuleReq)
end

function TAddIp6tablesRuleReq.new(InterfaceName, Ipv6Addr)
    return TAddIp6tablesRuleReq_from_obj({
        InterfaceName = InterfaceName,
        Ipv6Addr = Ipv6Addr
    })
end
---@param obj EthernetInterfaces.AddIp6tablesRuleReq
function TAddIp6tablesRuleReq:init_from_obj(obj)
    self.InterfaceName = obj.InterfaceName
    self.Ipv6Addr = obj.Ipv6Addr
end

function TAddIp6tablesRuleReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddIp6tablesRuleReq.group)
end

TAddIp6tablesRuleReq.from_obj = TAddIp6tablesRuleReq_from_obj

TAddIp6tablesRuleReq.proto_property = {'InterfaceName', 'Ipv6Addr'}

TAddIp6tablesRuleReq.default = {'', ''}

TAddIp6tablesRuleReq.struct = {
    {name = 'InterfaceName', is_array = false, struct = nil},
    {name = 'Ipv6Addr', is_array = false, struct = nil}
}

function TAddIp6tablesRuleReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'InterfaceName', self.InterfaceName, "string",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'Ipv6Addr', self.Ipv6Addr, "string", false,
                      errs, need_convert)

    TAddIp6tablesRuleReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddIp6tablesRuleReq.proto_property,
                                 errs, need_convert)
    return self
end

function TAddIp6tablesRuleReq:unpack(_) return self.InterfaceName, self.Ipv6Addr end

EthernetInterfaces.AddIp6tablesRuleReq = TAddIp6tablesRuleReq

---@class EthernetInterfaces.AddIptablesRuleRsp
---@field Result boolean
local TAddIptablesRuleRsp = {}
TAddIptablesRuleRsp.__index = TAddIptablesRuleRsp
TAddIptablesRuleRsp.group = {}

local function TAddIptablesRuleRsp_from_obj(obj)
    return setmetatable(obj, TAddIptablesRuleRsp)
end

function TAddIptablesRuleRsp.new(Result)
    return TAddIptablesRuleRsp_from_obj({Result = Result})
end
---@param obj EthernetInterfaces.AddIptablesRuleRsp
function TAddIptablesRuleRsp:init_from_obj(obj) self.Result = obj.Result end

function TAddIptablesRuleRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddIptablesRuleRsp.group)
end

TAddIptablesRuleRsp.from_obj = TAddIptablesRuleRsp_from_obj

TAddIptablesRuleRsp.proto_property = {'Result'}

TAddIptablesRuleRsp.default = {false}

TAddIptablesRuleRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TAddIptablesRuleRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, "bool", false, errs,
                      need_convert)

    TAddIptablesRuleRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddIptablesRuleRsp.proto_property, errs,
                                 need_convert)
    return self
end

function TAddIptablesRuleRsp:unpack(_) return self.Result end

EthernetInterfaces.AddIptablesRuleRsp = TAddIptablesRuleRsp

---@class EthernetInterfaces.AddIptablesRuleReq
---@field InterfaceName string
---@field IpAddr string
local TAddIptablesRuleReq = {}
TAddIptablesRuleReq.__index = TAddIptablesRuleReq
TAddIptablesRuleReq.group = {}

local function TAddIptablesRuleReq_from_obj(obj)
    return setmetatable(obj, TAddIptablesRuleReq)
end

function TAddIptablesRuleReq.new(InterfaceName, IpAddr)
    return TAddIptablesRuleReq_from_obj({
        InterfaceName = InterfaceName,
        IpAddr = IpAddr
    })
end
---@param obj EthernetInterfaces.AddIptablesRuleReq
function TAddIptablesRuleReq:init_from_obj(obj)
    self.InterfaceName = obj.InterfaceName
    self.IpAddr = obj.IpAddr
end

function TAddIptablesRuleReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddIptablesRuleReq.group)
end

TAddIptablesRuleReq.from_obj = TAddIptablesRuleReq_from_obj

TAddIptablesRuleReq.proto_property = {'InterfaceName', 'IpAddr'}

TAddIptablesRuleReq.default = {'', ''}

TAddIptablesRuleReq.struct = {
    {name = 'InterfaceName', is_array = false, struct = nil},
    {name = 'IpAddr', is_array = false, struct = nil}
}

function TAddIptablesRuleReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'InterfaceName', self.InterfaceName, "string",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'IpAddr', self.IpAddr, "string", false, errs,
                      need_convert)

    TAddIptablesRuleReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddIptablesRuleReq.proto_property, errs,
                                 need_convert)
    return self
end

function TAddIptablesRuleReq:unpack(_) return self.InterfaceName, self.IpAddr end

EthernetInterfaces.AddIptablesRuleReq = TAddIptablesRuleReq

---@class EthernetInterfaces.DeleteMgmtPortRsp
local TDeleteMgmtPortRsp = {}
TDeleteMgmtPortRsp.__index = TDeleteMgmtPortRsp
TDeleteMgmtPortRsp.group = {}

local function TDeleteMgmtPortRsp_from_obj(obj)
    return setmetatable(obj, TDeleteMgmtPortRsp)
end

function TDeleteMgmtPortRsp.new() return TDeleteMgmtPortRsp_from_obj({}) end
---@param obj EthernetInterfaces.DeleteMgmtPortRsp
function TDeleteMgmtPortRsp:init_from_obj(obj) end

function TDeleteMgmtPortRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeleteMgmtPortRsp.group)
end

TDeleteMgmtPortRsp.from_obj = TDeleteMgmtPortRsp_from_obj

TDeleteMgmtPortRsp.proto_property = {}

TDeleteMgmtPortRsp.default = {}

TDeleteMgmtPortRsp.struct = {}

function TDeleteMgmtPortRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TDeleteMgmtPortRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeleteMgmtPortRsp.proto_property, errs,
                                 need_convert)
    return self
end

function TDeleteMgmtPortRsp:unpack(_) end

EthernetInterfaces.DeleteMgmtPortRsp = TDeleteMgmtPortRsp

---@class EthernetInterfaces.DeleteMgmtPortReq
---@field PortId integer
local TDeleteMgmtPortReq = {}
TDeleteMgmtPortReq.__index = TDeleteMgmtPortReq
TDeleteMgmtPortReq.group = {}

local function TDeleteMgmtPortReq_from_obj(obj)
    return setmetatable(obj, TDeleteMgmtPortReq)
end

function TDeleteMgmtPortReq.new(PortId)
    return TDeleteMgmtPortReq_from_obj({PortId = PortId})
end
---@param obj EthernetInterfaces.DeleteMgmtPortReq
function TDeleteMgmtPortReq:init_from_obj(obj) self.PortId = obj.PortId end

function TDeleteMgmtPortReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeleteMgmtPortReq.group)
end

TDeleteMgmtPortReq.from_obj = TDeleteMgmtPortReq_from_obj

TDeleteMgmtPortReq.proto_property = {'PortId'}

TDeleteMgmtPortReq.default = {0}

TDeleteMgmtPortReq.struct = {{name = 'PortId', is_array = false, struct = nil}}

function TDeleteMgmtPortReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PortId', self.PortId, "uint8", false, errs,
                      need_convert)

    TDeleteMgmtPortReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeleteMgmtPortReq.proto_property, errs,
                                 need_convert)
    return self
end

function TDeleteMgmtPortReq:unpack(_) return self.PortId end

EthernetInterfaces.DeleteMgmtPortReq = TDeleteMgmtPortReq

---@class EthernetInterfaces.AddMgmtPortRsp
---@field PortId integer
local TAddMgmtPortRsp = {}
TAddMgmtPortRsp.__index = TAddMgmtPortRsp
TAddMgmtPortRsp.group = {}

local function TAddMgmtPortRsp_from_obj(obj)
    return setmetatable(obj, TAddMgmtPortRsp)
end

function TAddMgmtPortRsp.new(PortId)
    return TAddMgmtPortRsp_from_obj({PortId = PortId})
end
---@param obj EthernetInterfaces.AddMgmtPortRsp
function TAddMgmtPortRsp:init_from_obj(obj) self.PortId = obj.PortId end

function TAddMgmtPortRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddMgmtPortRsp.group)
end

TAddMgmtPortRsp.from_obj = TAddMgmtPortRsp_from_obj

TAddMgmtPortRsp.proto_property = {'PortId'}

TAddMgmtPortRsp.default = {0}

TAddMgmtPortRsp.struct = {{name = 'PortId', is_array = false, struct = nil}}

function TAddMgmtPortRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PortId', self.PortId, "uint8", false, errs,
                      need_convert)

    TAddMgmtPortRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddMgmtPortRsp.proto_property, errs,
                                 need_convert)
    return self
end

function TAddMgmtPortRsp:unpack(_) return self.PortId end

EthernetInterfaces.AddMgmtPortRsp = TAddMgmtPortRsp

---@class EthernetInterfaces.AddMgmtPortReq
---@field DeviceId integer
---@field DevicePortId integer
---@field Silkscreen string
---@field EthId integer
---@field Type string
---@field PortId integer
local TAddMgmtPortReq = {}
TAddMgmtPortReq.__index = TAddMgmtPortReq
TAddMgmtPortReq.group = {}

local function TAddMgmtPortReq_from_obj(obj)
    return setmetatable(obj, TAddMgmtPortReq)
end

function TAddMgmtPortReq.new(DeviceId, DevicePortId, Silkscreen, EthId, Type,
                             PortId)
    return TAddMgmtPortReq_from_obj({
        DeviceId = DeviceId,
        DevicePortId = DevicePortId,
        Silkscreen = Silkscreen,
        EthId = EthId,
        Type = Type,
        PortId = PortId
    })
end
---@param obj EthernetInterfaces.AddMgmtPortReq
function TAddMgmtPortReq:init_from_obj(obj)
    self.DeviceId = obj.DeviceId
    self.DevicePortId = obj.DevicePortId
    self.Silkscreen = obj.Silkscreen
    self.EthId = obj.EthId
    self.Type = obj.Type
    self.PortId = obj.PortId
end

function TAddMgmtPortReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddMgmtPortReq.group)
end

TAddMgmtPortReq.from_obj = TAddMgmtPortReq_from_obj

TAddMgmtPortReq.proto_property = {
    'DeviceId', 'DevicePortId', 'Silkscreen', 'EthId', 'Type', 'PortId'
}

TAddMgmtPortReq.default = {0, 0, '', 0, '', 0}

TAddMgmtPortReq.struct = {
    {name = 'DeviceId', is_array = false, struct = nil},
    {name = 'DevicePortId', is_array = false, struct = nil},
    {name = 'Silkscreen', is_array = false, struct = nil},
    {name = 'EthId', is_array = false, struct = nil},
    {name = 'Type', is_array = false, struct = nil},
    {name = 'PortId', is_array = false, struct = nil}
}

function TAddMgmtPortReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DeviceId', self.DeviceId, "uint8", false, errs,
                      need_convert)
    validate.Optional(prefix .. 'DevicePortId', self.DevicePortId, "uint8",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'Silkscreen', self.Silkscreen, "string", false,
                      errs, need_convert)
    validate.Optional(prefix .. 'EthId', self.EthId, "uint8", false, errs,
                      need_convert)
    validate.Optional(prefix .. 'Type', self.Type, "string", false, errs,
                      need_convert)
    validate.Optional(prefix .. 'PortId', self.PortId, "uint8", false, errs,
                      need_convert)

    TAddMgmtPortReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddMgmtPortReq.proto_property, errs,
                                 need_convert)
    return self
end

function TAddMgmtPortReq:unpack(_)
    return self.DeviceId, self.DevicePortId, self.Silkscreen, self.EthId,
           self.Type, self.PortId
end

EthernetInterfaces.AddMgmtPortReq = TAddMgmtPortReq

---@class EthernetInterfaces.SetNetworkConfigRsp
local TSetNetworkConfigRsp = {}
TSetNetworkConfigRsp.__index = TSetNetworkConfigRsp
TSetNetworkConfigRsp.group = {}

local function TSetNetworkConfigRsp_from_obj(obj)
    return setmetatable(obj, TSetNetworkConfigRsp)
end

function TSetNetworkConfigRsp.new() return TSetNetworkConfigRsp_from_obj({}) end
---@param obj EthernetInterfaces.SetNetworkConfigRsp
function TSetNetworkConfigRsp:init_from_obj(obj) end

function TSetNetworkConfigRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetNetworkConfigRsp.group)
end

TSetNetworkConfigRsp.from_obj = TSetNetworkConfigRsp_from_obj

TSetNetworkConfigRsp.proto_property = {}

TSetNetworkConfigRsp.default = {}

TSetNetworkConfigRsp.struct = {}

function TSetNetworkConfigRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetNetworkConfigRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetNetworkConfigRsp.proto_property,
                                 errs, need_convert)
    return self
end

function TSetNetworkConfigRsp:unpack(_) end

EthernetInterfaces.SetNetworkConfigRsp = TSetNetworkConfigRsp

---@class EthernetInterfaces.SetNetworkConfigReq
---@field NetMode string
---@field PortId integer
---@field VLANEnable boolean
---@field VLANId integer
local TSetNetworkConfigReq = {}
TSetNetworkConfigReq.__index = TSetNetworkConfigReq
TSetNetworkConfigReq.group = {}

local function TSetNetworkConfigReq_from_obj(obj)
    return setmetatable(obj, TSetNetworkConfigReq)
end

function TSetNetworkConfigReq.new(NetMode, PortId, VLANEnable, VLANId)
    return TSetNetworkConfigReq_from_obj({
        NetMode = NetMode,
        PortId = PortId,
        VLANEnable = VLANEnable,
        VLANId = VLANId
    })
end
---@param obj EthernetInterfaces.SetNetworkConfigReq
function TSetNetworkConfigReq:init_from_obj(obj)
    self.NetMode = obj.NetMode
    self.PortId = obj.PortId
    self.VLANEnable = obj.VLANEnable
    self.VLANId = obj.VLANId
end

function TSetNetworkConfigReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetNetworkConfigReq.group)
end

TSetNetworkConfigReq.from_obj = TSetNetworkConfigReq_from_obj

TSetNetworkConfigReq.proto_property = {
    'NetMode', 'PortId', 'VLANEnable', 'VLANId'
}

TSetNetworkConfigReq.default = {'', 0, false, 0}

TSetNetworkConfigReq.struct = {
    {name = 'NetMode', is_array = false, struct = nil},
    {name = 'PortId', is_array = false, struct = nil},
    {name = 'VLANEnable', is_array = false, struct = nil},
    {name = 'VLANId', is_array = false, struct = nil}
}

function TSetNetworkConfigReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NetMode', self.NetMode, "string", false, errs,
                      need_convert)
    validate.Optional(prefix .. 'PortId', self.PortId, "uint8", false, errs,
                      need_convert)
    validate.Optional(prefix .. 'VLANEnable', self.VLANEnable, "bool", false,
                      errs, need_convert)
    validate.Optional(prefix .. 'VLANId', self.VLANId, "uint16", false, errs,
                      need_convert)

    TSetNetworkConfigReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetNetworkConfigReq.proto_property,
                                 errs, need_convert)
    return self
end

function TSetNetworkConfigReq:unpack(_)
    return self.NetMode, self.PortId, self.VLANEnable, self.VLANId
end

EthernetInterfaces.SetNetworkConfigReq = TSetNetworkConfigReq

---@class EthernetInterfaces.GetAllPortRsp
---@field Port EthernetInterfaces.Port[]
local TGetAllPortRsp = {}
TGetAllPortRsp.__index = TGetAllPortRsp
TGetAllPortRsp.group = {}

local function TGetAllPortRsp_from_obj(obj)
    obj.Port = utils.from_obj(EthernetInterfaces.Port, obj.Port, true)
    return setmetatable(obj, TGetAllPortRsp)
end

function TGetAllPortRsp.new(Port) return TGetAllPortRsp_from_obj({Port = Port}) end
---@param obj EthernetInterfaces.GetAllPortRsp
function TGetAllPortRsp:init_from_obj(obj) self.Port = obj.Port end

function TGetAllPortRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetAllPortRsp.group)
end

TGetAllPortRsp.from_obj = TGetAllPortRsp_from_obj

TGetAllPortRsp.proto_property = {'Port'}

TGetAllPortRsp.default = {{}}

TGetAllPortRsp.struct = {
    {name = 'Port', is_array = true, struct = EthernetInterfaces.Port.struct}
}

function TGetAllPortRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.Port) do
        EthernetInterfaces.Port.new(v.Id, v.EthId, v.DeviceId, v.DevicePortId,
                                    v.Silkscreen, v.Type, v.AdaptiveFlag,
                                    v.LinkStatus, v.Mac):validate(prefix, errs,
                                                                  need_convert)
    end

    TGetAllPortRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetAllPortRsp.proto_property, errs,
                                 need_convert)
    return self
end

function TGetAllPortRsp:unpack(raw) return utils.unpack(raw, self.Port, true) end

EthernetInterfaces.GetAllPortRsp = TGetAllPortRsp

---@class EthernetInterfaces.GetAllPortReq
local TGetAllPortReq = {}
TGetAllPortReq.__index = TGetAllPortReq
TGetAllPortReq.group = {}

local function TGetAllPortReq_from_obj(obj)
    return setmetatable(obj, TGetAllPortReq)
end

function TGetAllPortReq.new() return TGetAllPortReq_from_obj({}) end
---@param obj EthernetInterfaces.GetAllPortReq
function TGetAllPortReq:init_from_obj(obj) end

function TGetAllPortReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetAllPortReq.group)
end

TGetAllPortReq.from_obj = TGetAllPortReq_from_obj

TGetAllPortReq.proto_property = {}

TGetAllPortReq.default = {}

TGetAllPortReq.struct = {}

function TGetAllPortReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetAllPortReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetAllPortReq.proto_property, errs,
                                 need_convert)
    return self
end

function TGetAllPortReq:unpack(_) end

EthernetInterfaces.GetAllPortReq = TGetAllPortReq

EthernetInterfaces.interface = mdb.register_interface(
                                   'bmc.kepler.Managers.EthernetInterfaces', {
        EthName = {'s', nil, true, nil, false},
        NetMode = {'s', {}, false, nil, false},
        Mac = {'s', nil, true, nil, false},
        IpVersion = {'s', nil, false, nil, false},
        NcsiEnable = {'b', {}, true, nil, false},
        PortId = {'y', {}, true, nil, false},
        VLANEnable = {'b', nil, true, nil, false},
        VLANId = {'q', nil, true, nil, false},
        SLAACAddressList = {'as', nil, true, nil, false},
        LinkLocalAddress = {'s', nil, true, nil, false},
        BackupIpActivated = {'b', nil, true, nil, false},
        DefaultFactoryIpMode = {'s', nil, true, nil, false},
        DefaultFactoryIpAddr = {'s', nil, true, nil, false},
        DefaultFactoryIpv6Mode = {'s', nil, true, 'DHCPv6', false},
        DefaultFactoryIpv6Addr = {'s', nil, true, nil, false},
        DefaultFactoryIpVersion = {'s', nil, true, 'IPv4AndIPv6', false}
    }, {
        GetAllPort = {'a{ss}', 'a(yyyyssbss)', TGetAllPortReq, TGetAllPortRsp},
        SetNetworkConfig = {
            'a{ss}sybq', '', TSetNetworkConfigReq, TSetNetworkConfigRsp
        },
        AddMgmtPort = {'a{ss}yysysy', 'y', TAddMgmtPortReq, TAddMgmtPortRsp},
        DeleteMgmtPort = {'a{ss}y', '', TDeleteMgmtPortReq, TDeleteMgmtPortRsp},
        AddIptablesRule = {
            'a{ss}ss', 'b', TAddIptablesRuleReq, TAddIptablesRuleRsp
        },
        AddIp6tablesRule = {
            'a{ss}ss', 'b', TAddIp6tablesRuleReq, TAddIp6tablesRuleRsp
        },
        SetVLANConfig = {'a{ss}bqy', 'b', TSetVLANConfigReq, TSetVLANConfigRsp},
        SetEthState = {'a{ss}sb', 'b', TSetEthStateReq, TSetEthStateRsp},
        NetworkFailover = {
            'a{ss}ss', 'b', TNetworkFailoverReq, TNetworkFailoverRsp
        }
    }, {
        ActivePortChangedSignal = 'a{ss}yy',
        NCSIInfoChangedSignal = 'a{ss}a(ss)',
        EthMacChangedSignal = 'a{ss}ss'
    })

return EthernetInterfaces
