--[[-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-3-15
-- Description: DO NOT EDIT; Code generated by "ipmi_message.lua.mako"
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetSNMPConfiguration = {}

---@class AccountIpmiCmds.SetSNMPConfigurationReq
---@field ManufactureId integer
---@field SNMPParameter integer
---@field BlockSelector integer
---@field SubBlockSelector integer
---@field Length integer
---@field Data string
local TSetSNMPConfigurationReq = {}
TSetSNMPConfigurationReq.__index = TSetSNMPConfigurationReq
TSetSNMPConfigurationReq.group = {}

local function TSetSNMPConfigurationReq_from_obj(obj)
    return setmetatable(obj, TSetSNMPConfigurationReq)
end

function TSetSNMPConfigurationReq.new(ManufactureId, SNMPParameter,
                                      BlockSelector, SubBlockSelector, Length,
                                      Data)
    return TSetSNMPConfigurationReq_from_obj({
        ManufactureId = ManufactureId,
        SNMPParameter = SNMPParameter,
        BlockSelector = BlockSelector,
        SubBlockSelector = SubBlockSelector,
        Length = Length,
        Data = Data
    })
end
---@param obj AccountIpmiCmds.SetSNMPConfigurationReq
function TSetSNMPConfigurationReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.SNMPParameter = obj.SNMPParameter
    self.BlockSelector = obj.BlockSelector
    self.SubBlockSelector = obj.SubBlockSelector
    self.Length = obj.Length
    self.Data = obj.Data
end

function TSetSNMPConfigurationReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSNMPConfigurationReq.group)
end

TSetSNMPConfigurationReq.from_obj = TSetSNMPConfigurationReq_from_obj

TSetSNMPConfigurationReq.proto_property = {
    'ManufactureId', 'SNMPParameter', 'BlockSelector', 'SubBlockSelector',
    'Length', 'Data'
}

TSetSNMPConfigurationReq.default = {0, 0, 0, 0, 0, ''}

TSetSNMPConfigurationReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'SNMPParameter', is_array = false, struct = nil},
    {name = 'BlockSelector', is_array = false, struct = nil},
    {name = 'SubBlockSelector', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TSetSNMPConfigurationReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, "uint32",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'SNMPParameter', self.SNMPParameter, "uint8",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'BlockSelector', self.BlockSelector, "uint8",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'SubBlockSelector', self.SubBlockSelector,
                      "uint8", false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, "uint8", false, errs,
                      need_convert)
    validate.Optional(prefix .. 'Data', self.Data, "string", false, errs,
                      need_convert)

    TSetSNMPConfigurationReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSNMPConfigurationReq.proto_property,
                                 errs, need_convert)
    return self
end

function TSetSNMPConfigurationReq:unpack(_)
    return self.ManufactureId, self.SNMPParameter, self.BlockSelector,
           self.SubBlockSelector, self.Length, self.Data
end

SetSNMPConfiguration.SetSNMPConfigurationReq = TSetSNMPConfigurationReq

---@class AccountIpmiCmds.SetSNMPConfigurationRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetSNMPConfigurationRsp = {}
TSetSNMPConfigurationRsp.__index = TSetSNMPConfigurationRsp
TSetSNMPConfigurationRsp.group = {}

local function TSetSNMPConfigurationRsp_from_obj(obj)
    return setmetatable(obj, TSetSNMPConfigurationRsp)
end

function TSetSNMPConfigurationRsp.new(CompletionCode, ManufactureId)
    return TSetSNMPConfigurationRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId
    })
end
---@param obj AccountIpmiCmds.SetSNMPConfigurationRsp
function TSetSNMPConfigurationRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetSNMPConfigurationRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSNMPConfigurationRsp.group)
end

TSetSNMPConfigurationRsp.from_obj = TSetSNMPConfigurationRsp_from_obj

TSetSNMPConfigurationRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetSNMPConfigurationRsp.default = {0, 0}

TSetSNMPConfigurationRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil},
    {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetSNMPConfigurationRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, "uint8",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, "uint32",
                      false, errs, need_convert)

    TSetSNMPConfigurationRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSNMPConfigurationRsp.proto_property,
                                 errs, need_convert)
    return self
end

function TSetSNMPConfigurationRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetSNMPConfiguration.SetSNMPConfigurationRsp = TSetSNMPConfigurationRsp

return SetSNMPConfiguration
