--[[-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-3-15
-- Description: DO NOT EDIT; Code generated by "ipmi_message.lua.mako"
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetUserAccess = {}

---@class AccountIpmiCmds.GetUserAccessReq
---@field ChannelNumber integer
---@field MessagingEnable integer
---@field AuthenticationEnable integer
---@field UserRestricted integer
---@field ChangeEnable integer
---@field UserId integer
---@field Reserved1 integer
local TGetUserAccessReq = {}
TGetUserAccessReq.__index = TGetUserAccessReq
TGetUserAccessReq.group = {}

local function TGetUserAccessReq_from_obj(obj)
    return setmetatable(obj, TGetUserAccessReq)
end

function TGetUserAccessReq.new(ChannelNumber, MessagingEnable,
                               AuthenticationEnable, UserRestricted,
                               ChangeEnable, UserId, Reserved1)
    return TGetUserAccessReq_from_obj({
        ChannelNumber = ChannelNumber,
        MessagingEnable = MessagingEnable,
        AuthenticationEnable = AuthenticationEnable,
        UserRestricted = UserRestricted,
        ChangeEnable = ChangeEnable,
        UserId = UserId,
        Reserved1 = Reserved1
    })
end
---@param obj AccountIpmiCmds.GetUserAccessReq
function TGetUserAccessReq:init_from_obj(obj)
    self.ChannelNumber = obj.ChannelNumber
    self.MessagingEnable = obj.MessagingEnable
    self.AuthenticationEnable = obj.AuthenticationEnable
    self.UserRestricted = obj.UserRestricted
    self.ChangeEnable = obj.ChangeEnable
    self.UserId = obj.UserId
    self.Reserved1 = obj.Reserved1
end

function TGetUserAccessReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetUserAccessReq.group)
end

TGetUserAccessReq.from_obj = TGetUserAccessReq_from_obj

TGetUserAccessReq.proto_property = {
    'ChannelNumber', 'MessagingEnable', 'AuthenticationEnable',
    'UserRestricted', 'ChangeEnable', 'UserId', 'Reserved1'
}

TGetUserAccessReq.default = {0, 0, 0, 0, 0, 0, 0}

TGetUserAccessReq.struct = {
    {name = 'ChannelNumber', is_array = false, struct = nil},
    {name = 'MessagingEnable', is_array = false, struct = nil},
    {name = 'AuthenticationEnable', is_array = false, struct = nil},
    {name = 'UserRestricted', is_array = false, struct = nil},
    {name = 'ChangeEnable', is_array = false, struct = nil},
    {name = 'UserId', is_array = false, struct = nil},
    {name = 'Reserved1', is_array = false, struct = nil}
}

function TGetUserAccessReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ChannelNumber', self.ChannelNumber, "uint8",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'MessagingEnable', self.MessagingEnable,
                      "uint8", false, errs, need_convert)
    validate.Optional(prefix .. 'AuthenticationEnable',
                      self.AuthenticationEnable, "uint8", false, errs,
                      need_convert)
    validate.Optional(prefix .. 'UserRestricted', self.UserRestricted, "uint8",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'ChangeEnable', self.ChangeEnable, "uint8",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'UserId', self.UserId, "uint8", false, errs,
                      need_convert)
    validate.Optional(prefix .. 'Reserved1', self.Reserved1, "uint8", false,
                      errs, need_convert)

    TGetUserAccessReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetUserAccessReq.proto_property, errs,
                                 need_convert)
    return self
end

function TGetUserAccessReq:unpack(_)
    return self.ChannelNumber, self.MessagingEnable, self.AuthenticationEnable,
           self.UserRestricted, self.ChangeEnable, self.UserId, self.Reserved1
end

GetUserAccess.GetUserAccessReq = TGetUserAccessReq

---@class AccountIpmiCmds.GetUserAccessRsp
---@field CompletionCode integer
---@field MaxUserNumber integer
---@field Reserved integer
---@field EnabledUser integer
---@field EnableStatus integer
---@field UserNumber integer
---@field Reserved2 integer
---@field PrivilegeLimit integer
---@field IpmiMessaging integer
---@field LinkAuthentication integer
---@field ChaAccessMode integer
---@field Reserved3 integer
local TGetUserAccessRsp = {}
TGetUserAccessRsp.__index = TGetUserAccessRsp
TGetUserAccessRsp.group = {}

local function TGetUserAccessRsp_from_obj(obj)
    return setmetatable(obj, TGetUserAccessRsp)
end

function TGetUserAccessRsp.new(CompletionCode, MaxUserNumber, Reserved,
                               EnabledUser, EnableStatus, UserNumber, Reserved2,
                               PrivilegeLimit, IpmiMessaging,
                               LinkAuthentication, ChaAccessMode, Reserved3)
    return TGetUserAccessRsp_from_obj({
        CompletionCode = CompletionCode,
        MaxUserNumber = MaxUserNumber,
        Reserved = Reserved,
        EnabledUser = EnabledUser,
        EnableStatus = EnableStatus,
        UserNumber = UserNumber,
        Reserved2 = Reserved2,
        PrivilegeLimit = PrivilegeLimit,
        IpmiMessaging = IpmiMessaging,
        LinkAuthentication = LinkAuthentication,
        ChaAccessMode = ChaAccessMode,
        Reserved3 = Reserved3
    })
end
---@param obj AccountIpmiCmds.GetUserAccessRsp
function TGetUserAccessRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.MaxUserNumber = obj.MaxUserNumber
    self.Reserved = obj.Reserved
    self.EnabledUser = obj.EnabledUser
    self.EnableStatus = obj.EnableStatus
    self.UserNumber = obj.UserNumber
    self.Reserved2 = obj.Reserved2
    self.PrivilegeLimit = obj.PrivilegeLimit
    self.IpmiMessaging = obj.IpmiMessaging
    self.LinkAuthentication = obj.LinkAuthentication
    self.ChaAccessMode = obj.ChaAccessMode
    self.Reserved3 = obj.Reserved3
end

function TGetUserAccessRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetUserAccessRsp.group)
end

TGetUserAccessRsp.from_obj = TGetUserAccessRsp_from_obj

TGetUserAccessRsp.proto_property = {
    'CompletionCode', 'MaxUserNumber', 'Reserved', 'EnabledUser',
    'EnableStatus', 'UserNumber', 'Reserved2', 'PrivilegeLimit',
    'IpmiMessaging', 'LinkAuthentication', 'ChaAccessMode', 'Reserved3'
}

TGetUserAccessRsp.default = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}

TGetUserAccessRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil},
    {name = 'MaxUserNumber', is_array = false, struct = nil},
    {name = 'Reserved', is_array = false, struct = nil},
    {name = 'EnabledUser', is_array = false, struct = nil},
    {name = 'EnableStatus', is_array = false, struct = nil},
    {name = 'UserNumber', is_array = false, struct = nil},
    {name = 'Reserved2', is_array = false, struct = nil},
    {name = 'PrivilegeLimit', is_array = false, struct = nil},
    {name = 'IpmiMessaging', is_array = false, struct = nil},
    {name = 'LinkAuthentication', is_array = false, struct = nil},
    {name = 'ChaAccessMode', is_array = false, struct = nil},
    {name = 'Reserved3', is_array = false, struct = nil}
}

function TGetUserAccessRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, "uint8",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'MaxUserNumber', self.MaxUserNumber, "uint8",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, "uint8", false, errs,
                      need_convert)
    validate.Optional(prefix .. 'EnabledUser', self.EnabledUser, "uint8", false,
                      errs, need_convert)
    validate.Optional(prefix .. 'EnableStatus', self.EnableStatus, "uint8",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'UserNumber', self.UserNumber, "uint8", false,
                      errs, need_convert)
    validate.Optional(prefix .. 'Reserved2', self.Reserved2, "uint8", false,
                      errs, need_convert)
    validate.Optional(prefix .. 'PrivilegeLimit', self.PrivilegeLimit, "uint8",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'IpmiMessaging', self.IpmiMessaging, "uint8",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'LinkAuthentication', self.LinkAuthentication,
                      "uint8", false, errs, need_convert)
    validate.Optional(prefix .. 'ChaAccessMode', self.ChaAccessMode, "uint8",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved3', self.Reserved3, "uint8", false,
                      errs, need_convert)

    TGetUserAccessRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetUserAccessRsp.proto_property, errs,
                                 need_convert)
    return self
end

function TGetUserAccessRsp:unpack(_)
    return self.CompletionCode, self.MaxUserNumber, self.Reserved,
           self.EnabledUser, self.EnableStatus, self.UserNumber, self.Reserved2,
           self.PrivilegeLimit, self.IpmiMessaging, self.LinkAuthentication,
           self.ChaAccessMode, self.Reserved3
end

GetUserAccess.GetUserAccessRsp = TGetUserAccessRsp

return GetUserAccess
